/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.gradle.eclipse.AdtImportProvider;
import com.android.tools.idea.gradle.eclipse.GradleImport;
import com.android.tools.idea.gradle.project.AdtModuleImporter;
import com.android.tools.idea.gradle.project.ProjectImportUtil;
import com.android.tools.idea.gradle.project.importing.GradleProjectImporter;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.OpenProjectFileChooserDescriptor;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidImportProjectAction
extends AnAction {
    @NonNls
    private static final String LAST_IMPORTED_LOCATION = "last.imported.location";
    private static final Logger LOG = Logger.getInstance(AndroidImportProjectAction.class);
    private static final String WIZARD_TITLE = "Select Eclipse or Gradle Project to Import";
    private static final String WIZARD_DESCRIPTION = "Select your Eclipse project folder, build.gradle or settings.gradle";

    public AndroidImportProjectAction() {
        this("Import Project...");
    }

    public AndroidImportProjectAction(@NotNull String text) {
        if (text == null) {
            AndroidImportProjectAction.$$$reportNull$$$0(0);
        }
        super(text);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AndroidImportProjectAction.$$$reportNull$$$0(1);
        }
        if (NewWelcomeScreen.isNewWelcomeScreen((AnActionEvent)e)) {
            e.getPresentation().setIcon(AllIcons.Welcome.ImportProject);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        try {
            AddModuleWizard wizard = this.selectFileAndCreateWizard();
            if (wizard != null && wizard.getStepCount() > 0) {
                if (!wizard.showAndGet()) {
                    return;
                }
                NewProjectUtil.createFromWizard((AbstractProjectWizard)wizard, null);
            }
        }
        catch (IOException exception) {
            AndroidImportProjectAction.handleImportException(e.getProject(), exception);
        }
        catch (ConfigurationException exception) {
            AndroidImportProjectAction.handleImportException(e.getProject(), (Exception)((Object)exception));
        }
    }

    private static void handleImportException(@Nullable Project project, @NotNull Exception e) {
        if (e == null) {
            AndroidImportProjectAction.$$$reportNull$$$0(2);
        }
        String message = String.format("Project import failed: %s", e.getMessage());
        Messages.showErrorDialog((Project)project, (String)message, (String)"Import Project");
        LOG.error((Throwable)e);
    }

    @NotNull
    protected FileChooserDescriptor createFileChooserDescriptor() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, true, true, false, false){
            FileChooserDescriptor myDelegate;
            {
                this.myDelegate = new OpenProjectFileChooserDescriptor(true);
            }

            public Icon getIcon(VirtualFile file) {
                Icon icon = this.myDelegate.getIcon(file);
                return icon == null ? super.getIcon(file) : icon;
            }
        };
        descriptor.setHideIgnored(false);
        descriptor.setTitle(WIZARD_TITLE);
        descriptor.setDescription(WIZARD_DESCRIPTION);
        FileChooserDescriptor fileChooserDescriptor = descriptor;
        if (fileChooserDescriptor == null) {
            AndroidImportProjectAction.$$$reportNull$$$0(3);
        }
        return fileChooserDescriptor;
    }

    @Nullable
    private AddModuleWizard selectFileAndCreateWizard() throws IOException, ConfigurationException {
        return this.selectFileAndCreateWizard(this.createFileChooserDescriptor());
    }

    @Nullable
    private AddModuleWizard selectFileAndCreateWizard(@NotNull FileChooserDescriptor descriptor) throws IOException, ConfigurationException {
        VirtualFile[] files;
        if (descriptor == null) {
            AndroidImportProjectAction.$$$reportNull$$$0(4);
        }
        FileChooserDialog chooser = FileChooserFactory.getInstance().createFileChooser(descriptor, null, null);
        VirtualFile toSelect = null;
        String lastLocation = PropertiesComponent.getInstance().getValue(LAST_IMPORTED_LOCATION);
        if (lastLocation != null) {
            toSelect = LocalFileSystem.getInstance().refreshAndFindFileByPath(lastLocation);
        }
        if ((files = chooser.choose(null, new VirtualFile[]{toSelect})).length == 0) {
            return null;
        }
        VirtualFile file = files[0];
        PropertiesComponent.getInstance().setValue(LAST_IMPORTED_LOCATION, file.getPath());
        return this.createImportWizard(file);
    }

    @Nullable
    protected AddModuleWizard createImportWizard(@NotNull VirtualFile file) throws IOException, ConfigurationException {
        VirtualFile target;
        if (file == null) {
            AndroidImportProjectAction.$$$reportNull$$$0(5);
        }
        if ((target = ProjectImportUtil.findImportTarget(file)) == null) {
            return null;
        }
        VirtualFile targetDir = target.isDirectory() ? target : target.getParent();
        File targetDirFile = VfsUtilCore.virtualToIoFile((VirtualFile)targetDir);
        if (AdtModuleImporter.isAdtProjectLocation(file)) {
            AndroidImportProjectAction.importAdtProject(file);
        } else if (GradleImport.isEclipseProjectDir(targetDirFile) && targetDir.findChild("build.gradle") == null && !ApplicationManager.getApplication().isUnitTestMode()) {
            String message = String.format("%1$s is an Eclipse project, but not an Android Eclipse project.\n\nPlease select the directory of an Android Eclipse project(which for example will contain\nan AndroidManifest.xml file) and try again.", file.getPath());
            Messages.showErrorDialog((String)message, (String)"Import Project");
        } else if (Projects.canImportAsGradleProject(target)) {
            GradleProjectImporter gradleImporter = GradleProjectImporter.getInstance();
            gradleImporter.importProject(file);
        } else {
            return AndroidImportProjectAction.importWithExtensions(file);
        }
        return null;
    }

    @Nullable
    private static AddModuleWizard importWithExtensions(@NotNull VirtualFile file) {
        List<ProjectImportProvider> available;
        if (file == null) {
            AndroidImportProjectAction.$$$reportNull$$$0(6);
        }
        if ((available = AndroidImportProjectAction.getImportProvidersForTarget(file)).isEmpty()) {
            Messages.showInfoMessage((Project)null, (String)("Cannot import anything from " + file.getPath()), (String)"Cannot Import");
            return null;
        }
        String path = available.size() == 1 ? available.get(0).getPathToBeImported(file) : ProjectImportProvider.getDefaultPath((VirtualFile)file);
        ProjectImportProvider[] availableProviders = available.toArray(new ProjectImportProvider[available.size()]);
        return new AddModuleWizard(null, path, availableProviders);
    }

    @NotNull
    private static List<ProjectImportProvider> getImportProvidersForTarget(@NotNull VirtualFile file) {
        VirtualFile target;
        if (file == null) {
            AndroidImportProjectAction.$$$reportNull$$$0(7);
        }
        if ((target = ProjectImportUtil.findImportTarget(file)) == null) {
            List<ProjectImportProvider> list = Collections.emptyList();
            if (list == null) {
                AndroidImportProjectAction.$$$reportNull$$$0(8);
            }
            return list;
        }
        ArrayList available = Lists.newArrayList();
        for (ProjectImportProvider provider : (ProjectImportProvider[])ProjectImportProvider.PROJECT_IMPORT_PROVIDER.getExtensions()) {
            if (!provider.canImport(target, null)) continue;
            available.add(provider);
        }
        ArrayList arrayList = available;
        if (arrayList == null) {
            AndroidImportProjectAction.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private static void importAdtProject(@NotNull VirtualFile file) {
        if (file == null) {
            AndroidImportProjectAction.$$$reportNull$$$0(10);
        }
        AdtImportProvider adtImportProvider = new AdtImportProvider(true);
        AddModuleWizard wizard = new AddModuleWizard(null, ProjectImportProvider.getDefaultPath((VirtualFile)file), new ProjectImportProvider[]{adtImportProvider});
        if (wizard.showAndGet()) {
            try {
                AndroidImportProjectAction.doCreate(wizard);
            }
            catch (IOException e) {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((String)e.getMessage(), (String)"Project Initialization Failed");
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCreate(@NotNull AddModuleWizard wizard) throws IOException {
        if (wizard == null) {
            AndroidImportProjectAction.$$$reportNull$$$0(11);
        }
        ProjectBuilder projectBuilder = wizard.getProjectBuilder();
        try {
            File projectFilePath = new File(wizard.getNewProjectFilePath());
            File projectDirPath = projectFilePath.isDirectory() ? projectFilePath : projectFilePath.getParentFile();
            LOG.assertTrue(projectDirPath != null, (Object)("Cannot create project in '" + projectFilePath + "': no parent file exists"));
            FileUtil.ensureExists((File)projectDirPath);
            if (StorageScheme.DIRECTORY_BASED == wizard.getStorageScheme()) {
                FileUtil.ensureExists((File)new File(projectDirPath, ".idea"));
            }
            boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
            ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
            Project project = projectManager.newProject(wizard.getProjectName(), projectDirPath.getPath(), true, false);
            if (project == null) {
                return;
            }
            if (!unitTestMode) {
                project.save();
            }
            if (projectBuilder != null) {
                if (!projectBuilder.validate(null, project)) {
                    return;
                }
                projectBuilder.commit(project, null, ModulesProvider.EMPTY_MODULES_PROVIDER);
            }
            if (!unitTestMode) {
                project.save();
            }
        }
        finally {
            if (projectBuilder != null) {
                projectBuilder.cleanup();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/actions/AndroidImportProjectAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/actions/AndroidImportProjectAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileChooserDescriptor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportProvidersForTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleImportException";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectFileAndCreateWizard";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createImportWizard";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "importWithExtensions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getImportProvidersForTarget";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "importAdtProject";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doCreate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

