/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc;

import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.JdbcInjection;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.impl.FileBlob;
import com.intellij.database.remote.jdbc.impl.FileClob;
import com.intellij.database.remote.jdbc.impl.PostgresHelper;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import com.intellij.database.remote.jdbc.impl.RemotePreparedStatementImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Exasol;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Oracle;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.Redshift;
import org.jetbrains.dekaf.Sqlite;
import org.jetbrains.dekaf.Sybase;

public class JdbcNativeUtil {
    public static final String PG_TIMESTAMP_TZ = "timestamptz";
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final String ORA_TIMESTAMP_TZ = "timestamp with time zone";
    private static final String PG_TIME_TZ_NAME = "timetz";
    private static final String ESCAPE_SYMBOL = "#";

    public static boolean isRedshiftOrPostgres(@NotNull Rdbms rdbms) {
        if (rdbms == null) {
            JdbcNativeUtil.$$$reportNull$$$0(0);
        }
        return rdbms == Postgres.RDBMS || rdbms.code.equalsIgnoreCase("redshift");
    }

    @NotNull
    public static Calendar getUtcCalendar() {
        Calendar calendar = Calendar.getInstance(UTC);
        if (calendar == null) {
            JdbcNativeUtil.$$$reportNull$$$0(1);
        }
        return calendar;
    }

    public static void setStatementParameter(@NotNull RemotePreparedStatement statement, @Nullable Object value, @NotNull Rdbms rdbms, @NotNull ColumnInfo columnInfo, boolean needsEscaping, int idx) throws Exception {
        if (statement == null) {
            JdbcNativeUtil.$$$reportNull$$$0(2);
        }
        if (rdbms == null) {
            JdbcNativeUtil.$$$reportNull$$$0(3);
        }
        if (columnInfo == null) {
            JdbcNativeUtil.$$$reportNull$$$0(4);
        }
        String typeName = columnInfo.getTypeName();
        int type = columnInfo.getType();
        String javaClassName = columnInfo.getJavaClassName();
        if (value == null) {
            statement.setNull(idx, JdbcNativeUtil.isPgUuidColumn(typeName, rdbms) || PostgresHelper.isPgBitColumn(rdbms, typeName) ? 1111 : type);
        } else if (value instanceof JdbcInjection) {
            ((JdbcInjection)value).inject(idx, (RemotePreparedStatementImpl)statement);
        } else if (value instanceof LobInfo.FileBlobInfo) {
            LobInfo.FileBlobInfo info = (LobInfo.FileBlobInfo)value;
            statement.setBlob(idx, new FileBlob(info.file));
        } else if (value instanceof LobInfo.FileClobInfo) {
            LobInfo.FileClobInfo info = (LobInfo.FileClobInfo)value;
            statement.setClob(idx, new FileClob(info.file, info.charset));
        } else if (value instanceof LobInfo.BlobInfo) {
            statement.setBytes(idx, ((LobInfo.BlobInfo)value).data);
        } else if (value instanceof LobInfo.ClobInfo) {
            statement.setString(idx, JdbcNativeUtil.escapeSql(((LobInfo.ClobInfo)value).data, needsEscaping, rdbms));
        } else if (value instanceof byte[]) {
            statement.setBytes(idx, (byte[])value);
        } else if (!(value instanceof String) || !PostgresHelper.setNative(rdbms, (String)value, typeName, statement, type, idx)) {
            if (JdbcNativeUtil.isRedshiftOrPostgres(rdbms) && type == 2003 && value instanceof Object[]) {
                statement.setArray(idx, StringUtil.replace((String)typeName, (String)"_", (String)""), (Object[])value);
            } else if (JdbcNativeUtil.isRedshiftOrPostgres(rdbms) && (Arrays.asList("tid", "uuid", "money", "interval").contains(typeName) || PostgresHelper.isPgBitColumn(rdbms, typeName) || type == 2003 || type == 2002 || type == 1111 || Object.class.getName().equals(javaClassName))) {
                boolean isBooleanBit;
                boolean bl = isBooleanBit = PostgresHelper.isPgBitColumn(rdbms, typeName) && value instanceof Boolean;
                statement.setObject(idx, isBooleanBit ? (((Boolean)value).booleanValue() ? "1" : "0") : value, 1111);
            } else if (JdbcNativeUtil.isRedshiftOrPostgres(rdbms) && type == 2009) {
                statement.setObject(idx, JdbcNativeUtil.escapeSql(value, needsEscaping, rdbms), 2009);
            } else if (value instanceof java.util.Date) {
                JdbcNativeUtil.setDate(statement, value, rdbms, idx, type);
            } else if (type == -5 && value instanceof BigInteger) {
                JdbcNativeUtil.setBigInteger(rdbms, statement, (BigInteger)value, idx);
            } else if (rdbms == Mysql.RDBMS && value instanceof String && StringUtil.equalsIgnoreCase((CharSequence)"bit", (CharSequence)typeName)) {
                JdbcNativeUtil.setBits(statement, (String)value, idx);
            } else {
                statement.setObject(idx, JdbcNativeUtil.escapeSql(value, needsEscaping, rdbms));
            }
        }
    }

    private static void setBits(@NotNull RemotePreparedStatement statement, @NotNull String value, int idx) throws Exception {
        if (statement == null) {
            JdbcNativeUtil.$$$reportNull$$$0(5);
        }
        if (value == null) {
            JdbcNativeUtil.$$$reportNull$$$0(6);
        }
        int length = value.length();
        int size = length / 8 + (length % 8 > 0 ? 1 : 0);
        byte[] bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            int start = Math.max(length - (i + 1) * 8, 0);
            int end = length - i * 8;
            String substring = value.substring(start, end);
            bytes[size - i - 1] = (byte)Short.parseShort(substring, 2);
        }
        statement.setBytes(idx, bytes);
    }

    private static void setDate(@NotNull RemotePreparedStatement statement, @NotNull Object value, @NotNull Rdbms rdbms, int idx, int type) throws Exception {
        if (statement == null) {
            JdbcNativeUtil.$$$reportNull$$$0(7);
        }
        if (value == null) {
            JdbcNativeUtil.$$$reportNull$$$0(8);
        }
        if (rdbms == null) {
            JdbcNativeUtil.$$$reportNull$$$0(9);
        }
        long millis = ((java.util.Date)value).getTime();
        if (JdbcNativeUtil.isTimestamp(rdbms, type)) {
            Timestamp timestamp;
            Timestamp timestamp2 = timestamp = value instanceof Timestamp ? (Timestamp)value : new Timestamp(millis);
            if (rdbms == Oracle.RDBMS) {
                Constructor<?> constructor;
                Class<?> clazz = Class.forName("oracle.sql.TIMESTAMP");
                Constructor<?> constructor2 = constructor = clazz == null ? null : clazz.getConstructor(Timestamp.class, Calendar.class);
                if (constructor != null) {
                    Object o = constructor.newInstance(timestamp, JdbcNativeUtil.getUtcCalendar());
                    statement.setObject(idx, o);
                    return;
                }
            }
            statement.setTimestamp(idx, timestamp, JdbcNativeUtil.getUtcCalendar());
            return;
        }
        if (type == 92) {
            statement.setTime(idx, value instanceof Time ? (Time)value : new Time(millis), JdbcNativeUtil.getUtcCalendar());
            return;
        }
        statement.setDate(idx, JdbcNativeUtil.createSqlDate((java.util.Date)value));
    }

    @NotNull
    public static Date createSqlDate(@NotNull java.util.Date value) {
        if (value == null) {
            JdbcNativeUtil.$$$reportNull$$$0(10);
        }
        Date date = value instanceof Date ? (Date)value : new Date(value.getTime());
        if (date == null) {
            JdbcNativeUtil.$$$reportNull$$$0(11);
        }
        return date;
    }

    public static boolean isTimestamp(@NotNull Rdbms rdbms, int type) {
        if (rdbms == null) {
            JdbcNativeUtil.$$$reportNull$$$0(12);
        }
        return type == 93 || rdbms == Mssql.RDBMS && type == -151;
    }

    public static <T> T escapeSql(T value, boolean needsEscaping, @NotNull Rdbms rdbms) {
        if (rdbms == null) {
            JdbcNativeUtil.$$$reportNull$$$0(13);
        }
        if (!needsEscaping) {
            return value;
        }
        if (!JdbcNativeUtil.supportsLike(rdbms)) {
            return value;
        }
        if (!(value instanceof String)) {
            return value;
        }
        String s = (String)value;
        List<String> unescapedChars = rdbms == Mysql.RDBMS ? Arrays.asList("%", "_", "\\", ESCAPE_SYMBOL) : (rdbms == Mssql.RDBMS ? Arrays.asList("%", "_", "[", "]", ESCAPE_SYMBOL) : Arrays.asList("%", "_", ESCAPE_SYMBOL));
        List escapedChars = ContainerUtil.map2List(unescapedChars, (Function)new Function<String, String>(){

            public String fun(String s) {
                return JdbcNativeUtil.ESCAPE_SYMBOL + s;
            }
        });
        return (T)StringUtil.replace((String)s, unescapedChars, (List)escapedChars);
    }

    public static boolean supportsLike(@NotNull Rdbms rdbms) {
        if (rdbms == null) {
            JdbcNativeUtil.$$$reportNull$$$0(14);
        }
        return rdbms != Sqlite.RDBMS && rdbms != Redshift.RDBMS && rdbms != Exasol.RDBMS;
    }

    private static void setBigInteger(@NotNull Rdbms rdbms, @NotNull RemotePreparedStatement statement, @NotNull BigInteger value, int idx) throws Exception {
        if (rdbms == null) {
            JdbcNativeUtil.$$$reportNull$$$0(15);
        }
        if (statement == null) {
            JdbcNativeUtil.$$$reportNull$$$0(16);
        }
        if (value == null) {
            JdbcNativeUtil.$$$reportNull$$$0(17);
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)rdbms.code, (CharSequence)"DB2") || rdbms == Sybase.RDBMS || rdbms == Mssql.RDBMS) {
            statement.setObject(idx, value.longValue());
            return;
        }
        statement.setObject(idx, value, -5);
    }

    public static void closeRemoteStatementSafe(final @Nullable RemoteStatement statement) {
        if (statement == null) {
            return;
        }
        JdbcNativeUtil.performSafe(new ThrowableRunnable<Exception>(){

            public void run() throws Exception {
                statement.close();
            }
        });
    }

    public static void performSafe(@NotNull ThrowableRunnable<Exception> runnable) {
        if (runnable == null) {
            JdbcNativeUtil.$$$reportNull$$$0(18);
        }
        try {
            runnable.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public static Object tryGetString(@NotNull Object o) {
        if (o == null) {
            JdbcNativeUtil.$$$reportNull$$$0(19);
        }
        return ReflectionHelper.tryInvokeMethod(o, "getString", null, null);
    }

    @Nullable
    public static Object tryGetBytes(@NotNull Object o) {
        if (o == null) {
            JdbcNativeUtil.$$$reportNull$$$0(20);
        }
        return ReflectionHelper.tryInvokeMethod(o, "getBytes", null, null);
    }

    public static boolean isZonedColumn(@Nullable String typeName, @NotNull Rdbms rdbms) {
        if (rdbms == null) {
            JdbcNativeUtil.$$$reportNull$$$0(21);
        }
        return JdbcNativeUtil.isZonedTimeColumn(typeName, rdbms) || JdbcNativeUtil.isZonedTimestampColumn(typeName, rdbms);
    }

    public static boolean isZonedTimestampColumn(@Nullable String typeName, @NotNull Rdbms rdbms) {
        if (rdbms == null) {
            JdbcNativeUtil.$$$reportNull$$$0(22);
        }
        return typeName != null && (JdbcNativeUtil.isRedshiftOrPostgres(rdbms) && StringUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)PG_TIMESTAMP_TZ) || rdbms == Oracle.RDBMS && StringUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)ORA_TIMESTAMP_TZ));
    }

    public static boolean isZonedTimeColumn(@Nullable String typeName, @NotNull Rdbms rdbms) {
        if (rdbms == null) {
            JdbcNativeUtil.$$$reportNull$$$0(23);
        }
        return typeName != null && JdbcNativeUtil.isRedshiftOrPostgres(rdbms) && PG_TIME_TZ_NAME.equals(typeName);
    }

    private static boolean isPgUuidColumn(@Nullable String typeName, @NotNull Rdbms rdbms) {
        if (rdbms == null) {
            JdbcNativeUtil.$$$reportNull$$$0(24);
        }
        return typeName != null && JdbcNativeUtil.isRedshiftOrPostgres(rdbms) && StringUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"uuid");
    }

    public static int fixJdbcType(@NotNull Rdbms rdbms, @Nullable String typeName, @Nullable String clazz, int type) {
        if (rdbms == null) {
            JdbcNativeUtil.$$$reportNull$$$0(25);
        }
        if (rdbms == Mysql.RDBMS) {
            if (type == 91 && "YEAR".equals(typeName) && Short.class.getCanonicalName().equals(clazz)) {
                return 5;
            }
        } else if (rdbms == Postgres.RDBMS) {
            if (Arrays.asList("bit", "varbit", "tid", "uuid").contains(typeName)) {
                return 12;
            }
            if ("money".equals(typeName)) {
                return 1111;
            }
        } else if (rdbms == Oracle.RDBMS) {
            if (type == -101 || type == -102) {
                return 93;
            }
            if (type == 2007) {
                return 12;
            }
        } else if (rdbms == Sqlite.RDBMS && StringUtil.equalsIgnoreCase((CharSequence)"datetime", (CharSequence)typeName)) {
            return 93;
        }
        return type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rdbms";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/JdbcNativeUtil";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnInfo";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/JdbcNativeUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUtcCalendar";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createSqlDate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isRedshiftOrPostgres";
                break;
            }
            case 1: 
            case 11: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setStatementParameter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setBits";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setDate";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createSqlDate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isTimestamp";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "escapeSql";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "supportsLike";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setBigInteger";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "performSafe";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "tryGetString";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "tryGetBytes";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isZonedColumn";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isZonedTimestampColumn";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isZonedTimeColumn";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isPgUuidColumn";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "fixJdbcType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

