/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.jasper2;

import java.io.PrintStream;
import javax.servlet.ServletException;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.ErrorHandler;
import org.apache.jasper.compiler.JavacErrorDetail;

public class CompilerNotifier
implements ErrorHandler {
    private static final boolean DEBUG = true;
    private int myErrors;
    private static final CompilerNotifier instance = new CompilerNotifier();
    private String myJspFile;

    public static CompilerNotifier getInstance() {
        return instance;
    }

    public void beforeCompile(String jspFile) {
        CompilerNotifier.outputBeforeCompile(jspFile, System.out);
        CompilerNotifier.outputBeforeCompile(jspFile, System.err);
    }

    public void compiledOk(String jspFile) {
        CompilerNotifier.outputOk(jspFile, System.out);
        CompilerNotifier.outputOk(jspFile, System.err);
    }

    public void jspError(String fname, int line, int column, String msg, Exception exception) {
        this.outputValidateError(fname, line, column, msg, System.out);
        this.outputValidateError(fname, line, column, "jsperr: msg " + msg, System.err);
        ++this.myErrors;
    }

    public void jspError(String msg, Exception exception) {
        String s;
        if ("org.apache.jasper.JasperException".equals(msg)) {
            msg = null;
        }
        String message = msg;
        Throwable rootException = exception;
        while (rootException instanceof ServletException && ((ServletException)rootException).getRootCause() != null) {
            rootException = ((ServletException)rootException).getRootCause();
        }
        String string = s = rootException == null ? null : rootException.getLocalizedMessage();
        if (s != null) {
            message = message == null ? s : message + " " + s;
        }
        this.outputValidateError("", -1, -1, message, System.out);
        String errorMessage = "jsperr: exc orig:" + (exception == null ? null : exception.getClass());
        errorMessage = errorMessage + "; root=" + (rootException == null ? null : rootException.getClass()) + "; msg=" + msg + ";" + message;
        this.outputValidateError("", -1, -1, errorMessage, System.err);
        ++this.myErrors;
    }

    public void javacError(JavacErrorDetail[] errorDetails) {
        for (int i = 0; i < errorDetails.length; ++i) {
            JavacErrorDetail errorDetail = errorDetails[i];
            this.outputValidateError(errorDetail.getJspFileName(), errorDetail.getJspBeginLineNumber(), 0, errorDetail.getErrorMessage(), System.out);
            this.outputValidateError(errorDetail.getJspFileName(), errorDetail.getJspBeginLineNumber(), 0, "jsperr: errdetail " + errorDetail.getErrorMessage(), System.err);
            ++this.myErrors;
        }
    }

    public void javacError(String string, Exception exception) throws JasperException {
        this.jspError(string, exception);
    }

    private static void outputOk(String jspFile, PrintStream out) {
        out.println("VALIDATE-SUCCESS");
        out.println(jspFile);
    }

    private static void outputBeforeCompile(String jspFile, PrintStream out) {
        out.println("VALIDATING");
        out.println(jspFile);
    }

    private void outputValidateError(String jspFileName, int line, int column, String errorMessage, PrintStream out) {
        out.println("VALIDATE-ERROR");
        out.println(jspFileName != null ? jspFileName : this.myJspFile);
        out.println(line);
        out.println(column);
        out.println(errorMessage);
        out.println("END-MESSAGE");
    }

    public int getErrorCount() {
        return this.myErrors;
    }

    public void setCompilingFile(String jspFile) {
        this.myJspFile = jspFile;
    }
}

