/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.remotebrowser;

import com.intellij.ide.CopyPasteSupport;
import com.intellij.ide.FileSelectInContext;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerItemsDeleteProvider;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.dnd.MoveCopyPasteSupport;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.dnd.MyDnDSource;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.dnd.MyDnDTarget;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.vfs2.FileObject;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ServerTree
extends ProjectViewTree
implements DataProvider {
    private final CopyPasteSupport myCopyPasteSupport = new MoveCopyPasteSupport();
    @Nullable
    private final Project myProject;
    private Deployable myServer;
    private PublishConfig myConfig;

    public ServerTree(@Nullable Project project, @Nullable Deployable server, ServerTreeNode root) {
        super(project, (TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode((Object)root)));
        this.myProject = project;
        this.myServer = server;
        this.enableDnD();
    }

    public void setServer(@Nullable Deployable server) {
        this.myServer = server;
    }

    public void setConfig(PublishConfig config) {
        this.myConfig = config;
    }

    public DefaultMutableTreeNode getSelectedNode() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object lastPathComponent = path.getLastPathComponent();
        if (!(lastPathComponent instanceof DefaultMutableTreeNode)) {
            return null;
        }
        return (DefaultMutableTreeNode)lastPathComponent;
    }

    public Color getFileColorFor(Object object) {
        SimpleTextAttributes attr;
        if (object instanceof ServerTreeNode && (attr = ((ServerTreeNode)((Object)object)).getNameAttributes()) != null) {
            return attr.getBgColor();
        }
        return super.getFileColorFor(object);
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (WebDeploymentDataKeys.REMOTE_ITEMS.is(dataId)) {
            return this.getSelectedFileObjects();
        }
        if (WebDeploymentDataKeys.SERVER_TREE.is(dataId)) {
            return this;
        }
        if (WebDeploymentDataKeys.DEPLOYABLE.is(dataId)) {
            return this.myServer;
        }
        if (WebDeploymentDataKeys.SERVER_NODES.is(dataId)) {
            return this.getSelectedNodes();
        }
        if (WebDeploymentDataKeys.REMOTE_CONNECTION.is(dataId)) {
            ServerTreeNode rootNode = (ServerTreeNode)((Object)((DefaultMutableTreeNode)this.getModel().getRoot()).getUserObject());
            if (rootNode == null) {
                return null;
            }
            return rootNode.getOpenRemoteConnection();
        }
        if (WebDeploymentDataKeys.PUBLISH_CONFIG.is(dataId)) {
            if (this.myConfig != null) {
                return this.myConfig;
            }
            if (this.myProject != null && !this.myProject.isDisposed() && !this.myProject.isDefault()) {
                return PublishConfig.getInstance(this.myProject);
            }
        }
        if (this.myServer == null || this.myProject == null || this.myProject.isDisposed() || this.myProject.isDefault()) {
            return null;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            ArrayList<OpenFileDescriptor> result = new ArrayList<OpenFileDescriptor>();
            for (VirtualFile vFile : this.getMappedLocalItems(false)) {
                result.add(new OpenFileDescriptor(this.myProject, vFile));
            }
            return result.toArray(new Navigatable[result.size()]);
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            VirtualFile[] files = this.getMappedLocalItems(false);
            return files.length > 0 ? new OpenFileDescriptor(this.myProject, files[0]) : null;
        }
        if (WebDeploymentDataKeys.MAPPED_LOCAL_ITEMS.is(dataId)) {
            return this.getMappedLocalItems(true);
        }
        if (SelectInContext.DATA_KEY.is(dataId)) {
            VirtualFile[] files = this.getMappedLocalItems(true);
            return files.length > 0 ? new FileSelectInContext(this.myProject, files[0], null) : null;
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return new ServerItemsDeleteProvider();
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
            return this.myCopyPasteSupport.getCutProvider();
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myCopyPasteSupport.getCopyProvider();
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.myCopyPasteSupport.getPasteProvider();
        }
        return null;
    }

    public ServerTreeNode[] getSelectedNodes() {
        ArrayList<ServerTreeNode> result = new ArrayList<ServerTreeNode>();
        TreePath[] treePaths = this.getSelectionModel().getSelectionPaths();
        if (treePaths == null) {
            return new ServerTreeNode[0];
        }
        for (TreePath treePath : treePaths) {
            ServerTreeNode serverTreeNode = ServerTree.getServerTreeNode(treePath);
            if (serverTreeNode == null) continue;
            result.add(serverTreeNode);
        }
        return result.toArray(new ServerTreeNode[result.size()]);
    }

    @Nullable
    public static ServerTreeNode getServerTreeNode(TreePath treePath) {
        Object o = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
        return o instanceof ServerTreeNode ? (ServerTreeNode)((Object)o) : null;
    }

    private FileObject[] getSelectedFileObjects() {
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        for (ServerTreeNode node : this.getSelectedNodes()) {
            FileObject fileObject = node.getFileObject();
            if (fileObject == null) continue;
            result.add(fileObject);
        }
        return result.toArray(new FileObject[result.size()]);
    }

    private VirtualFile[] getMappedLocalItems(boolean ignoreExcludedPaths) {
        assert (this.myServer != null);
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (FileObject deployedItem : this.getSelectedFileObjects()) {
            DeploymentPathMapping mapping = (DeploymentPathMapping)PublishConfig.getInstance(this.myProject).getNearestMappingDeploy2Local(deployedItem, false, (Mappable)this.myServer, ignoreExcludedPaths).getFirst();
            if (mapping == null) continue;
            String localPath = mapping.mapToLocalPath(deployedItem.getName(), (Mappable)this.myServer);
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(localPath);
            if (vFile == null) continue;
            result.add(vFile);
        }
        return VfsUtilCore.toVirtualFileArray(result);
    }

    public Deployable getServer() {
        return this.myServer;
    }

    private void enableDnD() {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && this.myProject != null && !this.myProject.isDefault()) {
            DnDManager.getInstance().registerTarget((DnDTarget)new MyDnDTarget(this), (JComponent)((Object)this));
            DnDManager.getInstance().registerSource((DnDSource)new MyDnDSource(this), (JComponent)((Object)this));
        }
    }
}

