/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.remoteEdit;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.remoteEdit.EditRemoteFileTask;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditRemoteFileAction
extends AnAction {
    public EditRemoteFileAction() {
        super(WDBundle.message("remote.edit.edit.action.title", new Object[0]), WDBundle.message("remote.edit.edit.action.description", new Object[0]), null);
    }

    public void update(AnActionEvent event) {
        boolean enabled = EditRemoteFileAction.isEnabled(event);
        Presentation presentation = event.getPresentation();
        presentation.setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
            presentation.setVisible(enabled);
        }
    }

    private static boolean isEnabled(AnActionEvent event) {
        if (event.getProject() == null) {
            return false;
        }
        if (!"RemoteHostPopup".equals(event.getPlace())) {
            return false;
        }
        ServerTreeNode[] serverTreeNodes = (ServerTreeNode[])WebDeploymentDataKeys.SERVER_NODES.getData(event.getDataContext());
        if (serverTreeNodes == null || serverTreeNodes.length != 1 || serverTreeNodes[0].getFileType() != org.apache.commons.vfs2.FileType.FILE) {
            return false;
        }
        Deployable serverConfig = (Deployable)WebDeploymentDataKeys.DEPLOYABLE.getData(event.getDataContext());
        return serverConfig != null;
    }

    public void actionPerformed(AnActionEvent event) {
        ServerTreeNode[] serverTreeNodes = (ServerTreeNode[])event.getData(WebDeploymentDataKeys.SERVER_NODES);
        if (serverTreeNodes == null || serverTreeNodes.length != 1) {
            return;
        }
        EditRemoteFileAction.editRemoteFile(event.getDataContext(), serverTreeNodes[0]);
    }

    public static void editRemoteFile(DataContext context, ServerTreeNode node) {
        if (node == null || node.getFileType() != org.apache.commons.vfs2.FileType.FILE) {
            return;
        }
        Deployable serverConfig = (Deployable)WebDeploymentDataKeys.DEPLOYABLE.getData(context);
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        FileObject file = node.getFileObject();
        if (serverConfig == null || project == null || file == null) {
            return;
        }
        EditRemoteFileAction.editRemoteFile(serverConfig, project, file, node.getOpenRemoteConnection());
    }

    public static void editRemoteFile(@NotNull Deployable serverConfig, @NotNull Project project, @NotNull FileObject file, @Nullable RemoteConnection connection) {
        if (serverConfig == null) {
            EditRemoteFileAction.$$$reportNull$$$0(0);
        }
        if (project == null) {
            EditRemoteFileAction.$$$reportNull$$$0(1);
        }
        if (file == null) {
            EditRemoteFileAction.$$$reportNull$$$0(2);
        }
        boolean symbolicLink = false;
        try {
            symbolicLink = file.isSymbolicLink();
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        if (!symbolicLink && !EditRemoteFileAction.ensureFileTypeKnown(project, file.getName().getBaseName())) {
            return;
        }
        EditRemoteFileAction.editRemoteFile(serverConfig, project, file, connection, null);
    }

    public static void editRemoteFile(@NotNull Deployable serverConfig, @NotNull Project project, @NotNull FileObject file, @Nullable RemoteConnection connection, @Nullable String presentableServerName) {
        if (serverConfig == null) {
            EditRemoteFileAction.$$$reportNull$$$0(3);
        }
        if (project == null) {
            EditRemoteFileAction.$$$reportNull$$$0(4);
        }
        if (file == null) {
            EditRemoteFileAction.$$$reportNull$$$0(5);
        }
        new EditRemoteFileTask(true, project, serverConfig, file, connection, presentableServerName).queue();
    }

    private static boolean ensureFileTypeKnown(Project project, String fileName) {
        FileType fileType = FileTypeChooser.getKnownFileTypeOrAssociate((String)fileName);
        if (fileType == null) {
            return false;
        }
        if (fileType instanceof INativeFileType) {
            Messages.showInfoMessage((Project)project, (String)WDBundle.message("remote.edit.please.associate.0.with.some.file.type.in.settings.editor.file.types", fileName), (String)WDBundle.message("remote.edit.message.title", new Object[0]));
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "serverConfig";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/plugins/webDeployment/remoteEdit/EditRemoteFileAction";
        objectArray[2] = "editRemoteFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

