/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.autoupload;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MuteFilter {
    private static final Logger LOG_OF_MUTING = Logger.getInstance((String)"#autoupload.mute");

    public abstract boolean isMuted(@NotNull VirtualFile var1);

    public abstract boolean isMuted(@NotNull VirtualFile var1, @NotNull String var2);

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
    }

    @NotNull
    public static MuteFilter create(@NotNull Change[] changes) {
        if (changes == null) {
            MuteFilter.$$$reportNull$$$0(0);
        }
        MyChangesMuteFilter filter = new MyChangesMuteFilter(changes);
        if (LOG_OF_MUTING.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Created new ").append(filter).append(" for changes:\n");
            for (Change change : changes) {
                stringBuilder.append("Change:\n").append(MyChangesMuteFilter.getRevisionPath(change.getBeforeRevision())).append("\n").append(MyChangesMuteFilter.getRevisionPath(change.getAfterRevision())).append("\n");
            }
            LOG_OF_MUTING.debug(stringBuilder.toString());
        }
        MuteFilter muteFilter = MuteFilter.wrap(filter);
        if (muteFilter == null) {
            MuteFilter.$$$reportNull$$$0(1);
        }
        return muteFilter;
    }

    @NotNull
    public static MuteFilter create(@NotNull String path) {
        if (path == null) {
            MuteFilter.$$$reportNull$$$0(2);
        }
        MyPathMuteFilter filter = new MyPathMuteFilter(path);
        if (LOG_OF_MUTING.isDebugEnabled()) {
            LOG_OF_MUTING.debug("Created new " + filter + " for path \"" + path + "\"");
        }
        MuteFilter muteFilter = MuteFilter.wrap(filter);
        if (muteFilter == null) {
            MuteFilter.$$$reportNull$$$0(3);
        }
        return muteFilter;
    }

    public static MuteFilter create(Collection<VirtualFile> roots) {
        MyFilesMuteFilter filter = new MyFilesMuteFilter(roots);
        if (LOG_OF_MUTING.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Created new ").append(filter).append(" for changes:\n");
            for (VirtualFile root : roots) {
                stringBuilder.append(root.getPath()).append("\n");
            }
            LOG_OF_MUTING.debug(stringBuilder.toString());
        }
        return MuteFilter.wrap(filter);
    }

    private static MuteFilter wrap(MuteFilter filter) {
        return LOG_OF_MUTING.isDebugEnabled() ? new LoggingMuteFilter(filter) : filter;
    }

    private static boolean isAncestor(String ancestorPath, String path) {
        ancestorPath = FileUtil.toSystemIndependentName((String)ancestorPath);
        path = FileUtil.toSystemIndependentName((String)path);
        return VfsUtilCore.isEqualOrAncestor((String)ancestorPath, (String)path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LoggingMuteFilter
    extends MuteFilter {
        private final MuteFilter myFilter;

        private LoggingMuteFilter(MuteFilter filter) {
            this.myFilter = filter;
        }

        @Override
        public boolean isMuted(@NotNull VirtualFile file) {
            if (file == null) {
                LoggingMuteFilter.$$$reportNull$$$0(0);
            }
            boolean muted = this.myFilter.isMuted(file);
            LOG_OF_MUTING.debug(this.myFilter + " for \"" + file.getPath() + "\" is " + (muted ? "" : "not ") + muted);
            return muted;
        }

        @Override
        public boolean isMuted(@NotNull VirtualFile parent, @NotNull String fileName) {
            if (parent == null) {
                LoggingMuteFilter.$$$reportNull$$$0(1);
            }
            if (fileName == null) {
                LoggingMuteFilter.$$$reportNull$$$0(2);
            }
            boolean muted = this.myFilter.isMuted(parent, fileName);
            LOG_OF_MUTING.debug(this.myFilter + " for \"" + parent.getPath() + "\" and \"" + fileName + "\" is " + (muted ? "" : "not ") + muted);
            return muted;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileName";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter$LoggingMuteFilter";
            objectArray[2] = "isMuted";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyFilesMuteFilter
    extends MuteFilter {
        private final Collection<VirtualFile> myRoots;

        public MyFilesMuteFilter(Collection<VirtualFile> roots) {
            this.myRoots = roots;
        }

        @Override
        public boolean isMuted(@NotNull VirtualFile file) {
            if (file == null) {
                MyFilesMuteFilter.$$$reportNull$$$0(0);
            }
            for (VirtualFile root : this.myRoots) {
                if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isMuted(@NotNull VirtualFile parent, @NotNull String fileName) {
            if (parent == null) {
                MyFilesMuteFilter.$$$reportNull$$$0(1);
            }
            if (fileName == null) {
                MyFilesMuteFilter.$$$reportNull$$$0(2);
            }
            for (VirtualFile root : this.myRoots) {
                if (fileName.equals(root.getName()) && parent.equals(root.getParent())) {
                    return true;
                }
                if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)parent, (boolean)false)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileName";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter$MyFilesMuteFilter";
            objectArray[2] = "isMuted";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyPathMuteFilter
    extends MuteFilter {
        private final String myPath;

        public MyPathMuteFilter(String path) {
            if (SystemInfo.isWindows && path.length() >= 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':') {
                path = path.substring(2);
            }
            this.myPath = path;
        }

        @Override
        public boolean isMuted(@NotNull VirtualFile file) {
            if (file == null) {
                MyPathMuteFilter.$$$reportNull$$$0(0);
            }
            return MuteFilter.isAncestor(this.myPath, file.getPath());
        }

        @Override
        public boolean isMuted(@NotNull VirtualFile parent, @NotNull String fileName) {
            if (parent == null) {
                MyPathMuteFilter.$$$reportNull$$$0(1);
            }
            if (fileName == null) {
                MyPathMuteFilter.$$$reportNull$$$0(2);
            }
            String path = parent.getPath() + "/" + fileName;
            return MuteFilter.isAncestor(this.myPath, path);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileName";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter$MyPathMuteFilter";
            objectArray[2] = "isMuted";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyChangesMuteFilter
    extends MuteFilter {
        private final Change[] myChanges;

        public MyChangesMuteFilter(@NotNull Change[] changes) {
            if (changes == null) {
                MyChangesMuteFilter.$$$reportNull$$$0(0);
            }
            this.myChanges = changes;
        }

        @Override
        public boolean isMuted(@NotNull VirtualFile file) {
            if (file == null) {
                MyChangesMuteFilter.$$$reportNull$$$0(1);
            }
            return this.isMuted(file.getPath());
        }

        @Override
        public boolean isMuted(@NotNull VirtualFile parent, @NotNull String fileName) {
            if (parent == null) {
                MyChangesMuteFilter.$$$reportNull$$$0(2);
            }
            if (fileName == null) {
                MyChangesMuteFilter.$$$reportNull$$$0(3);
            }
            return this.isMuted(parent.getPath() + "/" + fileName);
        }

        private boolean isMuted(String path) {
            for (Change change : this.myChanges) {
                if (MyChangesMuteFilter.isMuted(path, change.getBeforeRevision())) {
                    return true;
                }
                if (!MyChangesMuteFilter.isMuted(path, change.getAfterRevision())) continue;
                return true;
            }
            return false;
        }

        private static boolean isMuted(String path, @Nullable ContentRevision revision) {
            String revisionPath = MyChangesMuteFilter.getRevisionPath(revision);
            return revisionPath != null && MuteFilter.isAncestor(revisionPath, path);
        }

        @Nullable
        static String getRevisionPath(@Nullable ContentRevision revision) {
            if (revision == null) {
                return null;
            }
            FilePath filePath = revision.getFile();
            return filePath.getPath();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileName";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter$MyChangesMuteFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isMuted";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

