/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.webDeployment.AutoUploadComponent;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DistinctRootsCollections;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.UploadCheckinHandlerFactory;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.LoadFilesAction;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UploadFilesAction
extends LoadFilesAction {
    private static final Logger LOG = Logger.getInstance(UploadFilesAction.class);

    @Override
    @Nls
    @NotNull
    protected String getLoadHereMessage() {
        String string = WDBundle.message("action.title.upload.here", new Object[0]);
        if (string == null) {
            UploadFilesAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    protected String getLoadToServerMessage(Deployable server) {
        String string = WDBundle.message("action.title.upload.to", server.getName());
        if (string == null) {
            UploadFilesAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    protected String getServerChooserTitle() {
        String string = WDBundle.message("choose.server.to.upload.to", new Object[0]);
        if (string == null) {
            UploadFilesAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected boolean isChooseServer() {
        return false;
    }

    @Override
    protected void execute(@NotNull Project project, PublishConfig publishConfig, @NotNull Deployable server, final Change[] changes, ChangeList[] changeLists, final FileObject[] remoteFiles, final @Nullable RemoteConnection connection, final Collection<VirtualFile> roots) {
        String title;
        if (project == null) {
            UploadFilesAction.$$$reportNull$$$0(3);
        }
        if (server == null) {
            UploadFilesAction.$$$reportNull$$$0(4);
        }
        if (changes != null) {
            title = changeLists != null && changeLists.length == 1 && changeLists[0].getChanges().size() == changes.length ? WDBundle.message("upload.changelist.to", changeLists[0].getName(), StringUtil.notNullize((String)server.getName())) : WDBundle.message("upload.changes.to", changes.length, changes.length == 1 ? 1 : 2, StringUtil.notNullize((String)server.getName()));
            AutoUploadComponent.saveDocumentsSilently(project, changes);
        } else if (roots != null) {
            title = WDBundle.message("upload.to", StringUtil.notNullize((String)server.getName()));
            AutoUploadComponent.saveDocumentsSilently(project, roots);
        } else {
            title = WDBundle.message("upload.to", StringUtil.notNullize((String)server.getName()));
            AutoUploadComponent.saveDocumentsSilently(project, UploadFilesAction.getLocalRoots(publishConfig, remoteFiles, server));
        }
        TransferTask.ListBased transferTask = new TransferTask.ListBased(project, ConnectionOwnerFactory.createConnectionOwner(project), true, publishConfig, server, title, true, true, true, ProjectDeploymentRevisionTracker.getInstance(project)){

            @Override
            protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) throws FileSystemException {
                if (changes != null) {
                    return UploadCheckinHandlerFactory.doScanFiles(context, Arrays.asList(changes));
                }
                if (roots != null) {
                    return PublishActionUtil.scanFiles(context, roots);
                }
                LOG.assertTrue(remoteFiles != null);
                DistinctRootsCollections.FileObjects uploadRoots = new DistinctRootsCollections.FileObjects(remoteFiles);
                ArrayList<TransferOperation> result = new ArrayList<TransferOperation>();
                DeploymentPathUtils.ErrorsAndExclusions errors = new DeploymentPathUtils.ErrorsAndExclusions();
                Iterator iterator = uploadRoots.iterator();
                while (iterator.hasNext()) {
                    FileObject uploadRoot = (FileObject)iterator.next();
                    DeploymentPathUtils.refreshRemoteFile(uploadRoot, context);
                    DeploymentPathUtils.ErrorsAndExclusions e = DeploymentPathUtils.processIncoming(uploadRoot, context, result);
                    errors.addAll(e);
                }
                return new TransferTask.ListBased.ResultWithErrors(result, errors);
            }

            @Override
            protected RemoteConnection getExistingConnection() {
                return connection;
            }
        };
        FileTransferToolWindow.printWithTimestamp(project, server, title, ConsoleViewContentType.SYSTEM_OUTPUT, publishConfig.getTraceLevel());
        ProgressManager.getInstance().run((Task)transferTask);
    }

    public static Collection<VirtualFile> getLocalRoots(PublishConfig publishConfig, FileObject[] remoteFiles, Deployable server) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        DistinctRootsCollections.FileObjects remoteRoots = new DistinctRootsCollections.FileObjects(remoteFiles);
        Iterator iterator = remoteRoots.iterator();
        while (iterator.hasNext()) {
            FileObject remoteRoot = (FileObject)iterator.next();
            DeploymentPathMapping parentMapping = (DeploymentPathMapping)publishConfig.getNearestMappingDeploy2Local(remoteRoot.getName(), false, (Mappable)server).getFirst();
            if (parentMapping != null) {
                UploadFilesAction.processMapping(result, parentMapping);
                continue;
            }
            Collection childMappings = (Collection)publishConfig.getChildMappingsDeploy2Local(remoteRoot.getName(), (Mappable)server).getFirst();
            for (DeploymentPathMapping childMapping : childMappings) {
                UploadFilesAction.processMapping(result, childMapping);
            }
        }
        return result;
    }

    private static void processMapping(Collection<VirtualFile> result, DeploymentPathMapping parentMapping) {
        VirtualFile localRoot = LocalFileSystem.getInstance().findFileByPath(parentMapping.getLocalPath());
        if (localRoot != null && localRoot.isValid()) {
            result.add(localRoot);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadHereMessage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadToServerMessage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerChooserTitle";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

