/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import com.jetbrains.plugins.webDeployment.ui.DeploymentNotifier;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurable;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DeploymentNotificationsComponent
implements ProjectComponent {
    @NonNls
    private static final String WARNING_DISPLAYED_PROPERTY = "DeploymentNotificationsComponent.WarnDisplayed.Java7&Windows7FTPIssue";
    private final Project myProject;

    public DeploymentNotificationsComponent(Project project) {
        this.myProject = project;
    }

    public void projectOpened() {
        DeploymentNotificationsComponent.warnAboutWindowsAndJavaBug(this.myProject);
        PublishConfig publishConfig = PublishConfig.getInstance(this.myProject);
        Pair<String, String> idAndName = publishConfig.getDefaultServerIdAndName();
        StringBuilder message = new StringBuilder();
        int page = 0;
        if (idAndName.first != null) {
            WebServerConfig server = WebServersConfigManager.getInstance(this.myProject).findServer((String)idAndName.first);
            if (server == null) {
                message.append(WDBundle.message("default.server.not.exists", idAndName.second));
            } else {
                String error = server.validateFast();
                if (error != null) {
                    message.append(WDBundle.message("default.server.invalid", idAndName.second, error));
                }
            }
        }
        if (message.length() == 0) {
            return;
        }
        message.append("\n").append(WDBundle.message("review.deployment.config", new Object[0]));
        final int page_ = page;
        NotificationListener listener = new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    DeploymentConfigurable.show(null, false, DeploymentNotificationsComponent.this.myProject, page_);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/plugins/webDeployment/DeploymentNotificationsComponent$1";
                objectArray[2] = "hyperlinkUpdate";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DeploymentNotifier.notifyWithBalloon(null, message.toString(), NotificationType.WARNING, listener, this.myProject, FileTransferToolWindow.ID_PROVIDER);
    }

    private static void warnAboutWindowsAndJavaBug(Project project) {
        boolean shouldWarn;
        PropertiesComponent component = PropertiesComponent.getInstance();
        if (component.isValueSet(WARNING_DISPLAYED_PROPERTY)) {
            return;
        }
        boolean bl = shouldWarn = SystemInfo.isJavaVersionAtLeast((String)"1.7") && !SystemInfo.isJavaVersionAtLeast((String)"1.8") && SystemInfo.isWin7OrNewer && !SystemInfo.isWin8OrNewer;
        if (shouldWarn) {
            String message = WDBundle.message("win.7.and.java.7.firewall.issue.description", new Object[0]);
            NotificationListener listener = new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (event == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        BrowserUtil.browse((String)"https://youtrack.jetbrains.com/issue/WI-17206");
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/plugins/webDeployment/DeploymentNotificationsComponent$2";
                    objectArray[2] = "hyperlinkUpdate";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            DeploymentNotifier.notifyWithBalloon(null, message, NotificationType.WARNING, listener, project, FileTransferToolWindow.ID_PROVIDER);
            component.setValue(WARNING_DISPLAYED_PROPERTY, "true");
        } else {
            component.setValue(WARNING_DISPLAYED_PROPERTY, "false");
        }
    }
}

