/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.actions.SaveAllAction;
import com.intellij.ide.actions.SaveDocumentAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.containers.HashMap;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.UploadPostponer;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.autoupload.MuteFilter;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.DeploymentNotifier;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoUploadComponent
extends AbstractProjectComponent {
    private static final Logger LOG = Logger.getInstance(AutoUploadComponent.class);
    private static final int CHECK_RELATED_CHANGES_TIMEOUT = 5000;
    private FileListenerImpl myListener;
    private final Map<MuteLock, MuteFilter> myMutedPaths = new ConcurrentHashMap<MuteLock, MuteFilter>();

    protected AutoUploadComponent(Project project) {
        super(project);
    }

    public static AutoUploadComponent getInstance(@NotNull Project project) {
        if (project == null) {
            AutoUploadComponent.$$$reportNull$$$0(0);
        }
        return (AutoUploadComponent)((Object)project.getComponent(AutoUploadComponent.class));
    }

    public void initComponent() {
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(WebDeploymentTopics.DEPLOYMENT_CONFIG, (Object)new DeploymentConfigChangeListener(){

            @Override
            public void deploymentConfigChanged() {
                AutoUploadComponent.this.addOrRemoveListener();
            }

            @Override
            public void optionsChanged() {
                AutoUploadComponent.this.addOrRemoveListener();
            }

            @Override
            public void excludedPathsChanged() {
                AutoUploadComponent.this.addOrRemoveListener();
            }
        });
    }

    public void projectOpened() {
        this.addOrRemoveListener();
    }

    public void projectClosed() {
        this.addOrRemoveListener();
    }

    public void addOrRemoveListener() {
        boolean shouldBeListening;
        PublishConfig publishConfig = PublishConfig.getInstance(this.myProject).clone();
        WebServerConfig server = null;
        boolean bl = shouldBeListening = this.myProject.isOpen() && !this.myProject.isDisposed() && publishConfig.getAutoUploadState() != PublishConfig.AutoUploadState.NEVER && (server = publishConfig.findDefaultServer()) != null && server.needsTransfer() && server.getFileTransferConfig().validateFast() == null;
        if (shouldBeListening) {
            if (this.myListener == null) {
                this.myListener = new FileListenerImpl(this.myProject, publishConfig, server);
                LocalFileSystem.getInstance().addVirtualFileListener((VirtualFileListener)this.myListener);
            } else {
                this.myListener.setConfigs(publishConfig, server);
            }
            if (publishConfig.getAutoUploadState() == PublishConfig.AutoUploadState.ON_EXPLICIT_SAVE) {
                this.myListener.registerActionListener();
            } else {
                this.myListener.unregisterActionListener();
            }
        } else if (this.myListener != null) {
            LocalFileSystem.getInstance().removeVirtualFileListener((VirtualFileListener)this.myListener);
            this.myListener.unregisterActionListener();
            this.myListener.stopUpload();
            this.myListener = null;
        }
    }

    @NotNull
    public MuteLock mutePaths(@NotNull MuteFilter filter) {
        if (filter == null) {
            AutoUploadComponent.$$$reportNull$$$0(1);
        }
        MuteLock lock = new MuteLock();
        this.myMutedPaths.put(lock, filter);
        MuteLock muteLock = lock;
        if (muteLock == null) {
            AutoUploadComponent.$$$reportNull$$$0(2);
        }
        return muteLock;
    }

    public void unmutePaths(@NotNull MuteLock lock) {
        if (lock == null) {
            AutoUploadComponent.$$$reportNull$$$0(3);
        }
        this.myMutedPaths.remove(lock);
    }

    private boolean isMuted(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            AutoUploadComponent.$$$reportNull$$$0(4);
        }
        for (MuteFilter filter : this.myMutedPaths.values()) {
            if (!filter.isMuted(virtualFile)) continue;
            return true;
        }
        return false;
    }

    private boolean isMuted(@NotNull VirtualFile parent, @NotNull String fileName) {
        if (parent == null) {
            AutoUploadComponent.$$$reportNull$$$0(5);
        }
        if (fileName == null) {
            AutoUploadComponent.$$$reportNull$$$0(6);
        }
        for (MuteFilter filter : this.myMutedPaths.values()) {
            if (!filter.isMuted(parent, fileName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public String getComponentName() {
        if ("AutoUploadComponent" == null) {
            AutoUploadComponent.$$$reportNull$$$0(7);
        }
        return "AutoUploadComponent";
    }

    public static void executeWriteActionSilently(@Nullable Project project, @NotNull MuteFilter muteFilter, Runnable runnable) {
        if (muteFilter == null) {
            AutoUploadComponent.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (muteFilter == null) {
                AutoUploadComponent.$$$reportNull$$$0(10);
            }
            AutoUploadComponent.executeSilently(project, muteFilter, runnable);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeSilently(Project project, @NotNull MuteFilter muteFilter, Runnable runnable) {
        if (muteFilter == null) {
            AutoUploadComponent.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        MuteLock lock = null;
        if (project != null && !project.isDisposed()) {
            lock = AutoUploadComponent.getInstance(project).mutePaths(muteFilter);
        }
        try {
            runnable.run();
        }
        finally {
            if (lock != null && !project.isDisposed()) {
                AutoUploadComponent.getInstance(project).unmutePaths(lock);
            }
        }
    }

    public static void saveDocumentsSilently(Project project, Change[] changes) {
        AutoUploadComponent.executeWriteActionSilently(project, MuteFilter.create(changes), () -> {
            FileDocumentManager mgr = FileDocumentManager.getInstance();
            for (Change change : changes) {
                Document document;
                VirtualFile file;
                ContentRevision contentRevision = change.getAfterRevision();
                if (contentRevision == null || (file = contentRevision.getFile().getVirtualFile()) == null || !file.isValid() || (document = mgr.getDocument(file)) == null) continue;
                mgr.saveDocument(document);
            }
        });
    }

    public static void saveDocumentsSilently(Project project, Collection<VirtualFile> roots) {
        AutoUploadComponent.executeWriteActionSilently(project, MuteFilter.create(roots), () -> {
            FileDocumentManager mgr = FileDocumentManager.getInstance();
            for (Document document : mgr.getUnsavedDocuments()) {
                VirtualFile file = mgr.getFile(document);
                if (file == null || !file.isValid()) continue;
                boolean save = false;
                for (VirtualFile root : roots) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
                    save = true;
                    break;
                }
                if (!save) continue;
                mgr.saveDocument(document);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/AutoUploadComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lock";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "muteFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/AutoUploadComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "mutePaths";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "mutePaths";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "unmutePaths";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isMuted";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeWriteActionSilently";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "executeSilently";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$executeWriteActionSilently$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class FileMovedData
    implements ChangeData {
        private final VirtualFileMoveEvent myEvent;
        private final boolean mySourceMuted;
        private final boolean myTargetMuted;

        FileMovedData(VirtualFileMoveEvent event, boolean sourceMuted, boolean targetMuted) {
            this.myEvent = event;
            this.mySourceMuted = sourceMuted;
            this.myTargetMuted = targetMuted;
        }

        @Override
        public void apply(FileListenerImpl listener, Set<VirtualFile> justUploadedFiles) {
            listener.handleFileMovedEvent(this.myEvent, this.mySourceMuted, this.myTargetMuted);
            VirtualFile deletedFile = null;
            for (VirtualFile file : justUploadedFiles) {
                if (!file.getName().equals(this.myEvent.getFileName()) || !file.getParent().equals(this.myEvent.getOldParent())) continue;
                deletedFile = file;
                break;
            }
            if (deletedFile != null) {
                justUploadedFiles.remove(deletedFile);
            }
        }

        @Override
        public boolean affects(@NotNull VirtualFile file) {
            if (file == null) {
                FileMovedData.$$$reportNull$$$0(0);
            }
            return this.myEvent.getFile().equals(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/AutoUploadComponent$FileMovedData", "affects"));
        }
    }

    static class FileDeletedData
    implements ChangeData {
        private final VirtualFileEvent myEvent;

        FileDeletedData(VirtualFileEvent event) {
            this.myEvent = event;
        }

        @Override
        public void apply(FileListenerImpl listener, Set<VirtualFile> justUploadedFiles) {
            justUploadedFiles.remove(this.myEvent.getFile());
            listener.handleFileDeletedEvent(this.myEvent);
        }

        @Override
        public boolean affects(@NotNull VirtualFile file) {
            if (file == null) {
                FileDeletedData.$$$reportNull$$$0(0);
            }
            return this.myEvent.getFile().equals(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/AutoUploadComponent$FileDeletedData", "affects"));
        }
    }

    static class FileCreatedData
    implements ChangeData {
        private final VirtualFileEvent myEvent;

        FileCreatedData(VirtualFileEvent event) {
            this.myEvent = event;
        }

        @Override
        public void apply(FileListenerImpl listener, Set<VirtualFile> justUploadedFiles) {
            if (justUploadedFiles.contains(this.myEvent.getFile())) {
                return;
            }
            listener.handleFileCreatedEvent(this.myEvent);
            justUploadedFiles.add(this.myEvent.getFile());
        }

        @Override
        public boolean affects(@NotNull VirtualFile file) {
            if (file == null) {
                FileCreatedData.$$$reportNull$$$0(0);
            }
            return this.myEvent.getFile().equals(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/AutoUploadComponent$FileCreatedData", "affects"));
        }
    }

    static class PropertyChangedData
    implements ChangeData {
        private final VirtualFilePropertyEvent myEvent;
        private final boolean mySourceMuted;
        private final boolean myTargetMuted;

        PropertyChangedData(VirtualFilePropertyEvent event, boolean sourceMuted, boolean targetMuted) {
            this.myEvent = event;
            this.mySourceMuted = sourceMuted;
            this.myTargetMuted = targetMuted;
        }

        @Override
        public void apply(FileListenerImpl listener, Set<VirtualFile> justUploadedFiles) {
            listener.handlePropertyChangeEvent(this.myEvent, this.mySourceMuted, this.myTargetMuted);
            VirtualFile deletedFile = null;
            for (VirtualFile file : justUploadedFiles) {
                if (!file.getName().equals(this.myEvent.getOldValue()) && !file.getName().equals(this.myEvent.getNewValue()) || !file.getParent().equals(this.myEvent.getParent())) continue;
                deletedFile = file;
                break;
            }
            if (deletedFile != null) {
                justUploadedFiles.remove(deletedFile);
            }
        }

        @Override
        public boolean affects(@NotNull VirtualFile file) {
            if (file == null) {
                PropertyChangedData.$$$reportNull$$$0(0);
            }
            return this.myEvent.getFile().equals(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/AutoUploadComponent$PropertyChangedData", "affects"));
        }
    }

    static class ContentChangeData
    implements ChangeData {
        private final VirtualFileEvent myEvent;

        ContentChangeData(VirtualFileEvent event) {
            this.myEvent = event;
        }

        @Override
        public void apply(FileListenerImpl listener, Set<VirtualFile> justUploadedFiles) {
            if (justUploadedFiles.contains(this.myEvent.getFile())) {
                return;
            }
            listener.handleContentChangedEvent(this.myEvent);
            justUploadedFiles.add(this.myEvent.getFile());
        }

        @Override
        public boolean affects(@NotNull VirtualFile file) {
            if (file == null) {
                ContentChangeData.$$$reportNull$$$0(0);
            }
            return this.myEvent.getFile().equals(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/AutoUploadComponent$ContentChangeData", "affects"));
        }
    }

    private static interface ChangeData {
        public void apply(FileListenerImpl var1, Set<VirtualFile> var2);

        public boolean affects(@NotNull VirtualFile var1);
    }

    private static abstract class CopyFolder
    extends TransferOperation {
        private String mySourcePath;
        private WebServerConfig.RemotePath myTargetPath;

        protected abstract void handle(List<TransferOperation> var1);

        public CopyFolder(String sourcePath, WebServerConfig.RemotePath targetPath) {
            this.mySourcePath = sourcePath;
            this.myTargetPath = targetPath;
        }

        @Override
        public String getProgressText(ExecutionContext context) {
            return WDBundle.message("collecting.files", new Object[0]);
        }

        @Override
        public String getDetailedText(ExecutionContext context) {
            return WDBundle.message("preparing.upload.0.to.1", this.mySourcePath, context.getServer().getPresentablePath(this.myTargetPath));
        }

        @Override
        public void execute(ExecutionContext context) throws FileSystemException {
            FileObject source = DeploymentPathUtils.getLocalFile(this.mySourcePath);
            ArrayList<TransferOperation> newOperations = new ArrayList<TransferOperation>();
            DeploymentPathUtils.ErrorsAndExclusions errors = DeploymentPathUtils.processOutgoing(source, newOperations, context);
            for (String error : errors.getReadOnlyErrors()) {
                FileTransferToolWindow.printWithTimestamp(context.getProject(), context.getServer(), error, ConsoleViewContentType.SYSTEM_OUTPUT, context.getConfig().getTraceLevel());
            }
            for (String path : errors.getReadOnlyPaths()) {
                FileTransferToolWindow.printWithTimestamp(context.getProject(), context.getServer(), WDBundle.message("excluded.message", path), ConsoleViewContentType.NORMAL_OUTPUT, context.getConfig().getTraceLevel());
            }
            this.handle(newOperations);
        }

        @Override
        public String getErrorMessage(ExecutionContext serverConfig, String reason) {
            return WDBundle.message("preparing.upload.failed", this.mySourcePath, reason);
        }

        @Override
        public void onLocalMove(FileObject sourceFrom, FileObject sourceTo) throws FileSystemException {
            this.mySourcePath = CopyFolder.updateOnParentMove(this.mySourcePath, sourceFrom, sourceTo, SystemInfo.isFileSystemCaseSensitive);
        }
    }

    private class FileListenerImpl
    implements AnActionListener,
    VirtualFileListener {
        @NotNull
        private final Project myProject;
        private PublishConfig myPublishConfig;
        private WebServerConfig myServer;
        private volatile boolean myUploadExternalChanges;
        private final LinkedList<TransferOperation> myQueue;
        private final Map<TransferOperation, String> myExcludedPaths;
        private ProgressIndicator myProgressIndicator;
        private volatile boolean myUploadOnSaveAll;
        private final List<ChangeData> myChanges;
        private volatile boolean myActionListenerRegistered;
        private final Map<AnActionEvent, Editor> myActionsToHandle;
        private final AtomicBoolean myChecksRelatedChanges;

        private FileListenerImpl(Project project, PublishConfig publishConfig, WebServerConfig server) {
            if (project == null) {
                FileListenerImpl.$$$reportNull$$$0(0);
            }
            this.myQueue = new LinkedList();
            this.myExcludedPaths = new HashMap();
            this.myChanges = new ArrayList<ChangeData>();
            this.myActionListenerRegistered = false;
            this.myActionsToHandle = new HashMap();
            this.myChecksRelatedChanges = new AtomicBoolean(false);
            this.myPublishConfig = publishConfig;
            this.myUploadExternalChanges = this.myPublishConfig.isAutoUploadExternalChanges();
            this.myServer = server;
            this.myProject = project;
            this.myUploadOnSaveAll = this.myPublishConfig.getAutoUploadState() == PublishConfig.AutoUploadState.ON_EXPLICIT_SAVE;
        }

        public synchronized void stopUpload() {
            if (this.myProgressIndicator != null) {
                this.myProgressIndicator.cancel();
            }
        }

        private synchronized void setConfigs(PublishConfig publishConfig, WebServerConfig serverConfig) {
            this.myPublishConfig = publishConfig.clone();
            this.myUploadExternalChanges = this.myPublishConfig.isAutoUploadExternalChanges();
            this.myServer = serverConfig;
            boolean oldUploadOnSaveAll = this.myUploadOnSaveAll;
            this.myUploadOnSaveAll = this.myPublishConfig.getAutoUploadState() == PublishConfig.AutoUploadState.ON_EXPLICIT_SAVE;
            this.stopUpload();
            if (publishConfig.getAutoUploadState() == PublishConfig.AutoUploadState.ALWAYS && oldUploadOnSaveAll) {
                this.uploadCollectedChanges(null);
            }
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                FileListenerImpl.$$$reportNull$$$0(1);
            }
            if (!this.myUploadExternalChanges && !event.isFromSave()) {
                return;
            }
            if (AutoUploadComponent.this.isMuted(event.getFile())) {
                return;
            }
            if (this.myUploadOnSaveAll) {
                this.myChanges.add(new ContentChangeData(event));
                return;
            }
            this.handleContentChangedEvent(event);
        }

        private void handleContentChangedEvent(VirtualFileEvent event) {
            LOG.assertTrue(!event.getFile().isDirectory(), (Object)("Contents changed fired for a directory " + event.getFile().getPresentableUrl()));
            this.onFileModified(event.getFile().getPath());
        }

        @Nullable
        private synchronized WebServerConfig.RemotePath getDeployPath(String localPath, @Nullable Ref<String> excludedPathRef) {
            Pair<DeploymentPathMapping, Boolean> mappingPair = this.myPublishConfig.getNearestMappingForLocal(localPath, false, true, false, (Mappable)this.myServer);
            if (mappingPair.getFirst() == null) {
                if (excludedPathRef != null && Boolean.TRUE == mappingPair.getSecond()) {
                    excludedPathRef.set((Object)localPath);
                }
                return null;
            }
            WebServerConfig.RemotePath remotePath = ((DeploymentPathMapping)mappingPair.getFirst()).mapToDeployPath(localPath, (Mappable)this.myServer);
            if (PublishConfig.isRemotePathExcluded(remotePath, (Mappable)this.myServer, this.myPublishConfig)) {
                if (excludedPathRef != null) {
                    excludedPathRef.set((Object)remotePath.path);
                }
                return null;
            }
            return remotePath;
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                FileListenerImpl.$$$reportNull$$$0(2);
            }
            if (!this.myUploadExternalChanges && event.isFromRefresh()) {
                return;
            }
            if (!"name".equals(event.getPropertyName())) {
                return;
            }
            if (event.getParent() == null) {
                return;
            }
            boolean sourceMuted = AutoUploadComponent.this.isMuted(event.getParent(), (String)event.getOldValue());
            boolean targetMuted = AutoUploadComponent.this.isMuted(event.getParent(), (String)event.getNewValue());
            if (sourceMuted && targetMuted) {
                return;
            }
            if (this.myUploadOnSaveAll) {
                this.myChanges.add(new PropertyChangedData(event, sourceMuted, targetMuted));
                return;
            }
            this.handlePropertyChangeEvent(event, sourceMuted, targetMuted);
        }

        private void handlePropertyChangeEvent(VirtualFilePropertyEvent event, boolean sourceMuted, boolean targetMuted) {
            WebServerConfig.RemotePath remoteNewPath;
            if (event.getPropertyName() != "name" || event.getNewValue() != null && event.getNewValue().equals(event.getOldValue())) {
                return;
            }
            String parentPath = event.getFile().getParent().getPath();
            String oldPath = DeploymentPathUtils.join(parentPath, (String)event.getOldValue());
            String newPath = DeploymentPathUtils.join(parentPath, (String)event.getNewValue());
            String excludedPath = null;
            Ref excluded = new Ref();
            WebServerConfig.RemotePath remoteOldPath = this.getDeployPath(oldPath, (Ref<String>)excluded);
            if (remoteOldPath == null && !excluded.isNull()) {
                excludedPath = (String)excluded.get();
                excluded.set(null);
            }
            if ((remoteNewPath = this.getDeployPath(newPath, (Ref<String>)excluded)) == null && !excluded.isNull()) {
                excludedPath = (String)excluded.get();
            }
            if (remoteOldPath == null && remoteNewPath == null) {
                return;
            }
            if (remoteOldPath == null) {
                if (!targetMuted) {
                    this.onCreate(newPath, event.getFile().isDirectory(), true, excludedPath);
                }
            } else if (remoteNewPath == null) {
                if (!sourceMuted) {
                    this.onDelete(oldPath, event.getFile().isDirectory(), excludedPath);
                }
            } else if (sourceMuted && !targetMuted) {
                this.onCreate(newPath, event.getFile().isDirectory(), true, excludedPath);
            } else if (!sourceMuted && targetMuted) {
                this.onDelete(oldPath, event.getFile().isDirectory(), excludedPath);
            } else if (!sourceMuted && !targetMuted) {
                this.onMove(oldPath, newPath, event.getFile().isDirectory(), excludedPath);
            }
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                FileListenerImpl.$$$reportNull$$$0(3);
            }
            if (!this.myUploadExternalChanges && event.isFromRefresh()) {
                return;
            }
            if (AutoUploadComponent.this.isMuted(event.getFile())) {
                return;
            }
            if (this.myUploadOnSaveAll) {
                this.myChanges.add(new FileCreatedData(event));
                return;
            }
            this.handleFileCreatedEvent(event);
        }

        private void handleFileCreatedEvent(VirtualFileEvent event) {
            this.onCreate(event.getFile().getPath(), event.getFile().isDirectory(), event.isFromRefresh(), null);
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                FileListenerImpl.$$$reportNull$$$0(4);
            }
            if (!this.myUploadExternalChanges && event.isFromRefresh()) {
                return;
            }
            if (AutoUploadComponent.this.isMuted(event.getFile())) {
                return;
            }
            if (this.myUploadOnSaveAll) {
                this.myChanges.add(new FileDeletedData(event));
                return;
            }
            this.handleFileDeletedEvent(event);
        }

        private void handleFileDeletedEvent(VirtualFileEvent event) {
            this.onDelete(event.getFile().getPath(), event.getFile().isDirectory(), null);
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                FileListenerImpl.$$$reportNull$$$0(5);
            }
            if (!this.myUploadExternalChanges && event.isFromRefresh()) {
                return;
            }
            boolean sourceMuted = AutoUploadComponent.this.isMuted(event.getOldParent(), event.getFileName());
            boolean targetMuted = AutoUploadComponent.this.isMuted(event.getNewParent(), event.getFileName());
            if (sourceMuted && targetMuted) {
                return;
            }
            if (this.myUploadOnSaveAll) {
                this.myChanges.add(new FileMovedData(event, sourceMuted, targetMuted));
                return;
            }
            this.handleFileMovedEvent(event, sourceMuted, targetMuted);
        }

        private void handleFileMovedEvent(VirtualFileMoveEvent event, boolean sourceMuted, boolean targetMuted) {
            WebServerConfig.RemotePath remoteNewPath;
            String oldPath = DeploymentPathUtils.join(event.getOldParent().getPath(), event.getFileName());
            String newPath = DeploymentPathUtils.join(event.getNewParent().getPath(), event.getFileName());
            String excludedPath = null;
            Ref excluded = new Ref();
            WebServerConfig.RemotePath remoteOldPath = this.getDeployPath(oldPath, (Ref<String>)excluded);
            if (remoteOldPath == null && !excluded.isNull()) {
                excludedPath = (String)excluded.get();
                excluded.set(null);
            }
            if ((remoteNewPath = this.getDeployPath(newPath, (Ref<String>)excluded)) == null && !excluded.isNull()) {
                excludedPath = (String)excluded.get();
                excluded.set(null);
            }
            if (remoteOldPath == null && remoteNewPath == null) {
                return;
            }
            if (remoteOldPath == null) {
                if (!targetMuted) {
                    this.onCreate(newPath, event.getFile().isDirectory(), true, excludedPath);
                }
            } else if (remoteNewPath == null) {
                if (!sourceMuted) {
                    this.onDelete(oldPath, event.getFile().isDirectory(), excludedPath);
                }
            } else {
                if (!targetMuted && sourceMuted) {
                    this.onCreate(newPath, event.getFile().isDirectory(), true, excludedPath);
                }
                if (!sourceMuted && targetMuted) {
                    this.onDelete(oldPath, event.getFile().isDirectory(), excludedPath);
                }
                if (!sourceMuted && !targetMuted) {
                    this.onMove(oldPath, newPath, event.getFile().isDirectory(), excludedPath);
                }
            }
        }

        private synchronized void onCreate(String path, boolean isDirectory, boolean recursive, @Nullable String excludedPath) {
            WebServerConfig.RemotePath remotePath = this.getDeployPath(path, null);
            if (remotePath == null) {
                return;
            }
            if (isDirectory) {
                if (recursive) {
                    this.offerTransferOperation(new CopyFolder(path, remotePath){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        protected void handle(List<TransferOperation> newOperations) {
                            FileListenerImpl fileListenerImpl = FileListenerImpl.this;
                            synchronized (fileListenerImpl) {
                                FileListenerImpl.this.myQueue.addAll(newOperations);
                            }
                        }
                    }, excludedPath);
                } else {
                    this.offerTransferOperation(new TransferOperation.CreateFolder(this.getDeployPath(path, null)), excludedPath);
                }
            } else {
                this.offerTransferOperation(new TransferOperation.Copy(DeploymentPathUtils.getLocalFile(path), this.getDeployPath(path, null)), excludedPath);
            }
            this.ensureTaskRunning();
        }

        private synchronized void onFileModified(String path) {
            WebServerConfig.RemotePath targetPath = this.getDeployPath(path, null);
            if (targetPath == null) {
                return;
            }
            this.offerTransferOperation(new TransferOperation.Copy(DeploymentPathUtils.getLocalFile(path), targetPath), null);
            this.ensureTaskRunning();
        }

        private synchronized void onMove(String oldPath, String newPath, boolean isDirectory, @Nullable String excludedPath) {
            if (oldPath.equals(newPath)) {
                return;
            }
            for (TransferOperation operation : this.myQueue) {
                try {
                    operation.onLocalMove(DeploymentPathUtils.getLocalFile(oldPath), DeploymentPathUtils.getLocalFile(newPath));
                }
                catch (FileSystemException e) {
                    LOG.error((Throwable)e);
                }
            }
            this.offerTransferOperation(new TransferOperation.RemoteMoveOrUpload(newPath, this.getDeployPath(oldPath, null), this.getDeployPath(newPath, null), isDirectory), excludedPath);
            this.ensureTaskRunning();
        }

        private synchronized void onDelete(String path, boolean isDirectory, @Nullable String excludedPath) {
            WebServerConfig.RemotePath remotePath = this.getDeployPath(path, null);
            if (remotePath == null) {
                return;
            }
            this.offerTransferOperation(new TransferOperation.Delete(remotePath, isDirectory, true), excludedPath);
            this.ensureTaskRunning();
        }

        private void offerTransferOperation(TransferOperation e, @Nullable String excludedFolders) {
            this.myQueue.offer(e);
            if (excludedFolders != null) {
                this.myExcludedPaths.put(e, excludedFolders);
            }
        }

        private void ensureTaskRunning() {
            if (!this.myQueue.isEmpty() && this.myProgressIndicator == null) {
                String title = WDBundle.message("auto.upload.task.title", new Object[0]);
                FileTransferToolWindow.printWithTimestamp(this.myProject, this.myServer, title, ConsoleViewContentType.SYSTEM_OUTPUT, this.myPublishConfig.getTraceLevel());
                new TransferTask(this.myProject, ConnectionOwnerFactory.createConnectionOwner(this.myProject), true, this.myPublishConfig, Deployable.create(this.myServer), title, false, true, true, ProjectDeploymentRevisionTracker.getInstance(this.myProject)){
                    private int myProcessed;
                    {
                        this.myProcessed = 0;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run(@NotNull ProgressIndicator pi) {
                        ArrayList operations;
                        if (pi == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        FileListenerImpl fileListenerImpl = FileListenerImpl.this;
                        synchronized (fileListenerImpl) {
                            if (FileListenerImpl.this.myProgressIndicator != null) {
                                return;
                            }
                            FileListenerImpl.this.myProgressIndicator = pi;
                            operations = new ArrayList(FileListenerImpl.this.myQueue);
                        }
                        try {
                            this.doRun(pi);
                        }
                        finally {
                            fileListenerImpl = FileListenerImpl.this;
                            synchronized (fileListenerImpl) {
                                FileListenerImpl.this.myQueue.removeAll(operations);
                                FileListenerImpl.this.myProgressIndicator = null;
                            }
                        }
                    }

                    @Override
                    protected boolean isMultipleOperations() {
                        return true;
                    }

                    @Override
                    protected boolean prepareOperations(ExecutionContext context) throws FileSystemException {
                        for (int i = 0; i < FileListenerImpl.this.myExcludedPaths.size(); ++i) {
                            context.incCounter("transfer.details.excluded");
                        }
                        return true;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected TransferOperation getNextOperation() {
                        FileListenerImpl fileListenerImpl = FileListenerImpl.this;
                        synchronized (fileListenerImpl) {
                            TransferOperation info = (TransferOperation)FileListenerImpl.this.myQueue.poll();
                            if (info == null) {
                                return null;
                            }
                            ++this.myProcessed;
                            String excludedPath = (String)FileListenerImpl.this.myExcludedPaths.remove(info);
                            if (excludedPath != null) {
                                this.print(WDBundle.message("excluded.message", excludedPath), ConsoleViewContentType.NORMAL_OUTPUT);
                            }
                            return info;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected int getDoneStepsNumber() {
                        FileListenerImpl fileListenerImpl = FileListenerImpl.this;
                        synchronized (fileListenerImpl) {
                            return this.myProcessed - 1;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected int getTotalStepsNumber() {
                        FileListenerImpl fileListenerImpl = FileListenerImpl.this;
                        synchronized (fileListenerImpl) {
                            return this.myProcessed + FileListenerImpl.this.myQueue.size();
                        }
                    }

                    @Override
                    protected void assertAllExecuted(int totalProcessed, int failed) {
                    }

                    @Override
                    protected void showBalloon(MessageType type, String text, boolean isSummary) {
                        if (isSummary ? type != MessageType.INFO : type == MessageType.ERROR) {
                            super.showBalloon(type, text, isSummary);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/plugins/webDeployment/AutoUploadComponent$FileListenerImpl$2", "run"));
                    }
                }.queue();
            }
        }

        public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
            if (!this.myUploadOnSaveAll || !(action instanceof SaveAllAction) && !(action instanceof SaveDocumentAction)) {
                return;
            }
            if (!this.myProject.equals(event.getProject())) {
                return;
            }
            this.myActionsToHandle.put(event, action instanceof SaveDocumentAction ? (Editor)CommonDataKeys.EDITOR.getData(dataContext) : null);
        }

        public void beforeEditorTyping(char c, DataContext dataContext) {
        }

        public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
            if (!(action instanceof SaveAllAction) && !(action instanceof SaveDocumentAction)) {
                return;
            }
            if (!this.myUploadOnSaveAll) {
                this.myActionsToHandle.remove(event);
                return;
            }
            if (!this.myActionsToHandle.containsKey(event)) {
                return;
            }
            Editor editor = this.myActionsToHandle.remove(event);
            VirtualFile target = null;
            if (action instanceof SaveDocumentAction) {
                if (editor == null) {
                    return;
                }
                Document document = editor.getDocument();
                target = FileDocumentManager.getInstance().getFile(document);
                if (target == null) {
                    return;
                }
            }
            this.waitForRelatedChangesAndUpload(target);
        }

        private void waitForRelatedChangesAndUpload(final @Nullable VirtualFile target) {
            if (this.myChecksRelatedChanges.get()) {
                return;
            }
            Task.Backgroundable task = new Task.Backgroundable(this.myProject, WDBundle.message("auto.upload.wait.for.related.changes.to.apply.before.upload", new Object[0]), true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                public void run(@NotNull ProgressIndicator pi) {
                    if (pi == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (FileListenerImpl.this.myChecksRelatedChanges.get()) {
                        return;
                    }
                    Future checkFuture = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        boolean wasNotChecking;
                        if (pi == null) {
                            3.$$$reportNull$$$0(1);
                        }
                        if (!(wasNotChecking = FileListenerImpl.this.myChecksRelatedChanges.compareAndSet(false, true))) {
                            return;
                        }
                        UploadPostponer[] extensions = (UploadPostponer[])UploadPostponer.EP_NAME.getExtensions();
                        try {
                            for (UploadPostponer extension : extensions) {
                                LOG.debug("Checking for related changes " + extension.getPresentableName());
                                pi.setText(WDBundle.message("auto.upload.checking.0", extension.getPresentableName()));
                                extension.waitForRelatedChanges(pi, this.myProject);
                                pi.checkCanceled();
                            }
                        }
                        finally {
                            FileListenerImpl.this.myChecksRelatedChanges.set(false);
                        }
                    });
                    boolean checkFailedByTimeout = false;
                    try {
                        checkFuture.get(5000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        LOG.warn((Throwable)e);
                    }
                    catch (ExecutionException e) {
                        LOG.error((Throwable)e);
                    }
                    catch (TimeoutException e) {
                        LOG.debug((Throwable)e);
                        checkFailedByTimeout = true;
                        checkFuture.cancel(true);
                    }
                    pi.checkCanceled();
                    boolean finalCheckFailedByTimeout = checkFailedByTimeout;
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (this.myProject.isDisposed()) {
                            return;
                        }
                        if (finalCheckFailedByTimeout) {
                            String text = WDBundle.message("auto.upload.check.for.related.changes.took.too.much.time.and.was.cancelled", new Object[0]);
                            FileTransferToolWindow.printWithTimestamp(this.myProject, FileListenerImpl.this.myServer, text, ConsoleViewContentType.NORMAL_OUTPUT, PublishConfig.TraceLevel.ERRORS);
                            DeploymentNotifier.notifyWithBalloon(null, text, NotificationType.WARNING, null, this.myProject, FileTransferToolWindow.ID_PROVIDER);
                        }
                        FileListenerImpl.this.uploadCollectedChanges(target);
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "pi";
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/AutoUploadComponent$FileListenerImpl$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "run";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$run$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            task.queue();
        }

        private void uploadCollectedChanges(@Nullable VirtualFile filteringFile) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            FileListenerImpl listener = AutoUploadComponent.this.myListener;
            HashSet<VirtualFile> justUploadedFiles = new HashSet<VirtualFile>();
            Iterator<ChangeData> it = this.myChanges.iterator();
            while (it.hasNext()) {
                ChangeData next = it.next();
                if (filteringFile != null && !next.affects(filteringFile)) continue;
                next.apply(listener, justUploadedFiles);
                it.remove();
            }
        }

        public void registerActionListener() {
            if (!this.myActionListenerRegistered) {
                ActionManager.getInstance().addAnActionListener((AnActionListener)this);
                this.myActionListenerRegistered = true;
            }
        }

        public void unregisterActionListener() {
            if (this.myActionListenerRegistered) {
                ActionManager.getInstance().removeAnActionListener((AnActionListener)this);
                this.myActionListenerRegistered = false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/plugins/webDeployment/AutoUploadComponent$FileListenerImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentsChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileDeleted";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileMoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MuteLock {
    }
}

