/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudfoundry.agent.cloud;

import com.intellij.javaee.cloudfoundry.agent.base.cloud.CFCloudAgentBase;
import com.intellij.javaee.cloudfoundry.agent.cloud.CFCloudAgentApplicationV1Impl;
import com.intellij.javaee.cloudfoundry.agent.cloud.CFCloudAgentConfiguration;
import com.intellij.javaee.cloudfoundry.agent.cloud.CFCloudAgentDeploymentConfiguration;
import com.intellij.javaee.cloudfoundry.agent.cloud.CFCloudAgentDeploymentV1Impl;
import com.intellij.javaee.cloudfoundry.agent.cloud.CFCloudAgentV1;
import com.intellij.javaee.cloudfoundry.agent.service.CFAppServicesDomain;
import com.intellij.javaee.cloudfoundry.agent.service.CFAppServicesDomainImpl;
import com.intellij.javaee.cloudfoundry.agent.service.CFServiceConfigWrapperImpl;
import com.intellij.javaee.cloudfoundry.agent.service.CFServiceTierWrapper;
import com.intellij.javaee.cloudfoundry.agent.service.CFServiceTierWrapperImpl;
import com.intellij.javaee.cloudfoundry.agent.service.CFServiceWrapper;
import com.intellij.javaee.cloudfoundry.agent.service.CFServiceWrapperImpl;
import com.intellij.javaee.cloudfoundry.agent.service.CFServicesDomain;
import com.intellij.javaee.cloudfoundry.agent.service.CFServicesDomainImpl;
import com.intellij.javaee.cloudfoundry.agent.settings.CFAppSettingsRange;
import com.intellij.javaee.cloudfoundry.agent.settings.CFAppSettingsRangeImpl;
import com.intellij.javaee.cloudfoundry.agent.wrappers.CFApplication;
import com.intellij.javaee.cloudfoundry.agent.wrappers.CFApplicationV1Impl;
import com.intellij.javaee.oss.cloud.agent.CloudListWrapper;
import com.intellij.remoteServer.agent.util.CloudAgentApplication;
import com.intellij.remoteServer.agent.util.CloudAgentDeployment;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.agent.util.CloudProxySettings;
import com.intellij.remoteServer.agent.util.CloudRemoteApplication;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.cloudfoundry.client.lib.CloudFoundryClient;
import org.cloudfoundry.client.lib.HttpProxyConfiguration;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.CloudService;
import org.cloudfoundry.client.lib.domain.ServiceConfiguration;

public class CFCloudAgentV1Impl
extends CFCloudAgentBase
implements CFCloudAgentV1 {
    private CloudFoundryClient myClient;
    private final ServicesWrapper myServicesWrapper = new ServicesWrapper();

    protected void doConnect(CFCloudAgentConfiguration config) throws MalformedURLException {
        URL apiUrl = new URL(config.getLocationApiUrl());
        CloudProxySettings proxySettings = config.getProxySettings();
        HttpProxyConfiguration proxyConfiguration = null;
        if (proxySettings.useHttpProxy()) {
            proxyConfiguration = new HttpProxyConfiguration(proxySettings.getHost(), proxySettings.getPort());
        }
        this.myClient = new CloudFoundryClient(new CloudCredentials(config.getEmail(), config.getPassword()), apiUrl, proxyConfiguration);
        this.myClient.login();
    }

    public CloudAgentApplication createApplication(CloudRemoteApplication applicationIdentity) {
        return new CFCloudAgentApplicationV1Impl(this, this.myClient, applicationIdentity.getName());
    }

    public CloudAgentDeployment createDeployment(CFCloudAgentDeploymentConfiguration config, CloudAgentLoggingHandler loggingHandler) {
        return new CFCloudAgentDeploymentV1Impl(this, this.myClient, config);
    }

    public List<CFApplication> doGetApplications() {
        ArrayList<CFApplication> result = new ArrayList<CFApplication>();
        for (CloudApplication application : this.myClient.getApplications()) {
            result.add(new CFApplicationV1Impl(application));
        }
        return result;
    }

    public CFAppSettingsRange getAppSettingsRange() {
        return (CFAppSettingsRange)new CFCloudAgentBase.ApiTask<CFAppSettingsRange>(){

            protected CFAppSettingsRange doPerform() {
                return new CFAppSettingsRangeImpl(CFCloudAgentV1Impl.this.myClient.getApplicationMemoryChoices());
            }
        }.perform();
    }

    public CFServicesDomain getServicesDomain() {
        return (CFServicesDomain)new CFCloudAgentBase.ApiTask<CFServicesDomain>(){

            protected CFServicesDomain doPerform() {
                ArrayList<CFServiceConfigWrapperImpl> wrappedServiceConfigs = new ArrayList<CFServiceConfigWrapperImpl>();
                for (ServiceConfiguration serviceConfig : CFCloudAgentV1Impl.this.myClient.getServiceConfigurations()) {
                    ArrayList<CFServiceTierWrapperImpl> wrappedTiers = new ArrayList<CFServiceTierWrapperImpl>();
                    for (ServiceConfiguration.Tier tier : serviceConfig.getTiers()) {
                        wrappedTiers.add(new CFServiceTierWrapperImpl(tier.getType()));
                    }
                    wrappedServiceConfigs.add(new CFServiceConfigWrapperImpl(serviceConfig.getVendor(), serviceConfig.getType(), serviceConfig.getVersion(), serviceConfig.getDescription(), wrappedTiers.toArray(new CFServiceTierWrapper[wrappedTiers.size()])));
                }
                return new CFServicesDomainImpl(wrappedServiceConfigs);
            }
        }.perform();
    }

    public CFAppServicesDomain getAppServicesDomain() {
        return (CFAppServicesDomain)new CFCloudAgentBase.ApiTask<CFAppServicesDomain>(){

            protected CFAppServicesDomain doPerform() {
                return (CFAppServicesDomain)CFCloudAgentV1Impl.this.myServicesWrapper.getModel();
            }
        }.perform();
    }

    public void setAppServicesDomain(final CFAppServicesDomain appServicesDomain) {
        new CFCloudAgentBase.ApiTask(){

            protected Object doPerform() {
                CFCloudAgentV1Impl.this.myServicesWrapper.setModel(appServicesDomain);
                return null;
            }
        }.perform();
    }

    private class ServicesWrapper
    extends CloudListWrapper<CFAppServicesDomain, CloudService, CFServiceWrapper> {
        private ServicesWrapper() {
        }

        protected List<CloudService> loadItems() {
            return CFCloudAgentV1Impl.this.myClient.getServices();
        }

        protected void deleteItem(String id) {
            CFCloudAgentV1Impl.this.myClient.deleteService(id);
        }

        protected void createItem(CFServiceWrapper wrapper) {
            CloudService service = new CloudService();
            service.setName(wrapper.getName());
            service.setTier(wrapper.getTier());
            service.setType(wrapper.getType());
            service.setVersion(wrapper.getVersion());
            service.setVendor(wrapper.getVendor());
            CFCloudAgentV1Impl.this.myClient.createService(service);
        }

        protected CFServiceWrapper wrapItem(CloudService service) {
            return new CFServiceWrapperImpl(false, service.getName(), service.getTier(), service.getType(), service.getVendor(), service.getVersion());
        }

        protected CFAppServicesDomain createModel(List<CFServiceWrapper> wrappers) {
            return new CFAppServicesDomainImpl(wrappers);
        }

        protected CFServiceWrapper[] getWrappers(CFAppServicesDomain model) {
            return model.getAvailableServices();
        }
    }
}

