/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.editor.reference;

import com.intellij.javaee.model.xml.EjbRef;
import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.javaee.model.xml.JndiEnvironmentRefsGroup;
import com.intellij.javaee.oss.editor.JavaeeSectionInfo;
import com.intellij.javaee.oss.editor.JavaeeSectionInfoEditable;
import com.intellij.javaee.oss.jboss.JBossBundle;
import com.intellij.javaee.oss.jboss.editor.reference.JBossReferenceSection;
import com.intellij.javaee.oss.jboss.editor.reference.JBossReferenceUtil;
import com.intellij.javaee.oss.jboss.model.JBossEjbRef;
import com.intellij.javaee.oss.jboss.model.JBossReferenceHolder;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

class JBossEjbRefSection
extends JBossReferenceSection<EjbRef> {
    private final JndiEnvironmentRefsGroup group;
    private final JBossReferenceHolder holder;

    JBossEjbRefSection(JndiEnvironmentRefsGroup group, JBossReferenceHolder holder) {
        this.group = group;
        this.holder = holder;
    }

    public List<EjbRef> getValues() {
        return this.group == null ? Collections.emptyList() : this.group.getEjbRefs();
    }

    @Override
    JavaeeSectionInfo<EjbRef> createFirstColumn() {
        return new JavaeeSectionInfo<EjbRef>(JBossBundle.getText("JBossReferenceEditor.ejb.remote", new Object[0])){

            public String valueOf(EjbRef source) {
                return (String)source.getEjbRefName().getValue();
            }
        };
    }

    @Override
    JavaeeSectionInfo<EjbRef> createSecondColumn() {
        return new JavaeeSectionInfoEditable<EjbRef>(JBossBundle.getText("JBossReferenceEditor.jndi.name", new Object[0]), (JavaeeDomModelElement)this.holder){

            @Nullable
            public String valueOf(EjbRef source) {
                JBossEjbRef target = JBossReferenceUtil.findEjbRef(JBossEjbRefSection.this.holder, source);
                return target == null ? null : (String)target.getJndiName().getValue();
            }

            protected void write(EjbRef item, String value) {
                JBossEjbRef target = JBossReferenceUtil.findEjbRef(JBossEjbRefSection.this.holder, item);
                if (!StringUtil.isEmpty((String)value)) {
                    if (target == null) {
                        target = JBossEjbRefSection.this.holder.addEjbRef();
                        target.getEjbRefName().setValue((Object)item);
                    }
                    target.getJndiName().setValue((Object)value);
                } else if (target != null) {
                    target.undefine();
                }
            }
        };
    }
}

