/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.view;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ws.model.jam.WSJamModel;
import com.intellij.ws.model.jam.WSJamWebService;
import com.intellij.ws.view.WSJamWebMethodFinderRecursivePanel;
import icons.WSIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSViewFinderRecursivePanel
extends FinderRecursivePanel<WSJamWebService> {
    private final Module myModule;

    public WSViewFinderRecursivePanel(@NotNull FinderRecursivePanel parent, @NotNull Module module) {
        if (parent == null) {
            WSViewFinderRecursivePanel.$$$reportNull$$$0(0);
        }
        if (module == null) {
            WSViewFinderRecursivePanel.$$$reportNull$$$0(1);
        }
        super(parent);
        this.myModule = module;
    }

    @Nullable
    protected JComponent createRightComponent(WSJamWebService path) {
        return this.hasChildren(path) ? new WSJamWebMethodFinderRecursivePanel(this, path, this.myModule) : this.createDescriptionPanel(path);
    }

    private JComponent createDescriptionPanel(WSJamWebService path) {
        FinderRecursivePanel.DisposablePanel panel = new FinderRecursivePanel.DisposablePanel((LayoutManager)new BorderLayout(), (Disposable)this);
        PsiClass psiClass = path.getPsiElement();
        DocumentationManager manager = DocumentationManager.getInstance((Project)this.myModule.getProject());
        DocumentationComponent component = new DocumentationComponent(manager);
        Disposer.register((Disposable)panel, (Disposable)component);
        manager.fetchDocInfo((PsiElement)psiClass, component);
        panel.add((Component)component, (Object)"Center");
        return panel;
    }

    private static String getDescriptionText(WSJamWebService path) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html><table>");
        WSViewFinderRecursivePanel.addParameter(sb, "Class", path.getPsiElement().getQualifiedName());
        WSViewFinderRecursivePanel.addParameter(sb, "Service Name", path.getServiceName());
        WSViewFinderRecursivePanel.addParameter(sb, "Port Name", path.getPortName());
        WSViewFinderRecursivePanel.addParameter(sb, "Endpoint Interface", path.getEndpointInterface());
        WSViewFinderRecursivePanel.addParameter(sb, "Wsdl Location", path.getWsdlLocation());
        sb.append("</table></html>");
        return sb.toString();
    }

    private static void addParameter(@NotNull StringBuffer sb, @NotNull String name, @Nullable String value) {
        if (sb == null) {
            WSViewFinderRecursivePanel.$$$reportNull$$$0(2);
        }
        if (name == null) {
            WSViewFinderRecursivePanel.$$$reportNull$$$0(3);
        }
        if (value != null) {
            sb.append("<tr><td><b>");
            sb.append(name);
            sb.append(":</b></td><td>");
            sb.append(value);
            sb.append("</td></tr>");
        }
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        WSJamWebService path = (WSJamWebService)this.getSelectedValue();
        if (CommonDataKeys.NAVIGATABLE.is(dataId) && path != null) {
            return path.getPsiElement();
        }
        return super.getData(dataId);
    }

    @NotNull
    protected String getItemText(WSJamWebService webService) {
        String className = StringUtil.getShortName((String)webService.getPsiElement().getQualifiedName());
        String serviceName = webService.getServiceName();
        String string = className + (serviceName == null ? "" : "(" + serviceName + ")");
        if (string == null) {
            WSViewFinderRecursivePanel.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    protected Icon getItemIcon(WSJamWebService path) {
        return WSIcons.WebServicesClass;
    }

    @NotNull
    protected List<WSJamWebService> getListItems() {
        ArrayList<WSJamWebService> arrayList = new ArrayList<WSJamWebService>(WSJamModel.getModel(this.myModule).getWebServices());
        if (arrayList == null) {
            WSViewFinderRecursivePanel.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    protected boolean hasChildren(WSJamWebService path) {
        return path.getWebMethods().size() > 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/view/WSViewFinderRecursivePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/view/WSViewFinderRecursivePanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getListItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addParameter";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

