/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.utils.ui;

import com.intellij.ide.DataManager;
import com.intellij.javaee.UriUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.EditorComboBox;
import com.intellij.util.ArrayUtil;
import com.intellij.ws.WSBundle;
import com.intellij.ws.WebServicesPlugin;
import com.intellij.ws.WebServicesPluginSettings;
import com.intellij.ws.utils.ui.MyDialogWrapper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.Nullable;

public abstract class GenerateJavaCodeDialogBase
extends MyDialogWrapper {
    public static final String SEPARATOR_CHAR = "\u0000";
    private boolean multipleFileSelection = false;

    public GenerateJavaCodeDialogBase(Project _project) {
        super(_project);
    }

    protected void restoreCommonFieldsFromPreviousSession(GenerateJavaCodeDialogBase previousDialog) {
        JComboBox pathes;
        if (previousDialog != null && (pathes = this.getOutputPaths()) != null) {
            pathes.setSelectedItem(previousDialog.getOutputPaths().getSelectedItem());
        }
    }

    @Override
    protected void init() {
        JCheckBox addLibs;
        JComboBox outputPathes;
        VirtualFile virtualFile;
        super.init();
        DataContext dataContext = this.getDataContext();
        PsiFile file = dataContext != null ? (PsiFile)dataContext.getData("psi.File") : null;
        VirtualFile virtualFile2 = virtualFile = file != null ? file.getVirtualFile() : null;
        if (file != null && this.isAcceptableFile(virtualFile)) {
            this.initVirtualFile(virtualFile);
        }
        if ((outputPathes = this.getOutputPaths()) != null) {
            Module selectedModule = this.getForcedModule();
            if (selectedModule == null) {
                selectedModule = (Module)(dataContext != null ? dataContext.getData("module") : null);
            }
            String selectedPath = null;
            Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
            LinkedList<String> outputPathesList = new LinkedList<String>();
            for (Module module : modules) {
                VirtualFile[] roots;
                for (VirtualFile root : roots = OrderEnumerator.orderEntries((Module)module).getAllSourceRoots()) {
                    if (root.getExtension() != null || !root.isWritable()) continue;
                    String presentableUrl = root.getPresentableUrl();
                    if (!outputPathesList.contains(presentableUrl)) {
                        outputPathesList.add(presentableUrl);
                    }
                    if (selectedModule != module || selectedPath != null) continue;
                    selectedPath = presentableUrl;
                }
            }
            Collections.sort(outputPathesList);
            outputPathes.setModel(new DefaultComboBoxModel<String>(ArrayUtil.toStringArray(outputPathesList)));
            if (outputPathesList.size() > 0) {
                outputPathes.setSelectedIndex(selectedPath == null ? 0 : outputPathesList.indexOf(selectedPath));
            }
            this.doInitFor(this.getOutputPathsText(), outputPathes, 'o');
        }
        WebServicesPluginSettings instance = WebServicesPluginSettings.getInstance();
        EditorComboBox packagePrefix = this.getPackagePrefix();
        if (packagePrefix != null) {
            this.configureComboBox((JComboBox)packagePrefix, instance.getLastPackagePrefixes());
            String selection = GenerateJavaCodeDialogBase.getDefaultSelection(dataContext);
            if (selection != null) {
                packagePrefix.setSelectedItem(selection);
            } else if (packagePrefix.getItemCount() == 0) {
                packagePrefix.setSelectedItem("mypackage");
            }
            this.doInitFor(this.getPackagePrefixText(), (JComponent)packagePrefix, 'a');
        }
        if ((addLibs = this.getAddLibs()) != null) {
            addLibs.setMnemonic('r');
            addLibs.setSelected(WebServicesPlugin.getInstance(this.myProject).isToAddRequiredLibraries());
        }
    }

    protected DataContext getDataContext() {
        return DataManager.getInstance().getDataContext();
    }

    protected JavaCodeFragment setupFragment() {
        PsiPackage defaultPackage = JavaPsiFacade.getInstance((Project)this.myProject).findPackage("");
        PsiJavaCodeReferenceCodeFragment fragment = JavaCodeFragmentFactory.getInstance((Project)this.myProject).createReferenceCodeFragment("", (PsiElement)defaultPackage, true, false);
        fragment.setVisibilityChecker(JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE);
        return fragment;
    }

    @Nullable
    private static String getDefaultSelection(DataContext dataContext) {
        if (dataContext != null) {
            PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            if (psiElement instanceof PsiPackage) {
                return ((PsiPackage)psiElement).getQualifiedName();
            }
            if (psiElement instanceof PsiDirectory) {
                PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)psiElement);
                return aPackage != null ? aPackage.getQualifiedName() : null;
            }
        }
        return null;
    }

    protected Module getForcedModule() {
        return null;
    }

    protected void initVirtualFile(VirtualFile virtualFile) {
        this.getUrl().getComboBox().setSelectedItem(VfsUtilCore.fixIDEAUrl((String)virtualFile.getUrl()));
    }

    @Override
    protected ValidationInfo doValidate(MyDialogWrapper.ValidationData _data) {
        return this.doValidateWithData((MyValidationData)_data);
    }

    @Nullable
    protected ValidationInfo doValidateWithData(MyValidationData data) {
        Object selectedItem = data.currentPackagePrefix;
        if (selectedItem != null) {
            String prefix = (String)selectedItem;
            for (String name : StringUtil.split((String)prefix, (String)".", (boolean)true, (boolean)false)) {
                if (PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(name)) continue;
                return new ValidationInfo(WSBundle.message("package.prefix.is.not.valid.validation.message", new Object[0]), (JComponent)this.getPackagePrefix());
            }
        }
        if (GenerateJavaCodeDialogBase.isNotValidUrl(selectedItem = data.currentUrl)) {
            return new ValidationInfo(WSBundle.message("url.is.empty.validation.problem", new Object[0]), (JComponent)this.getUrl());
        }
        return this.doValidUrlCheck(data);
    }

    protected static boolean isNotValidUrl(Object selectedItem) {
        return selectedItem == null || selectedItem.toString().length() == 0;
    }

    protected ValidationInfo doValidUrlCheck(MyValidationData data) {
        if (this.isMultipleFileSelection()) {
            StringTokenizer tokenizer = new StringTokenizer((String)data.currentUrl, SEPARATOR_CHAR);
            while (tokenizer.hasMoreTokens()) {
                ValidationInfo result = this.checkOneUrl(tokenizer.nextToken(), this.getUrl().getComboBox());
                if (result == null) continue;
                return result;
            }
            return null;
        }
        return this.checkOneUrl((String)data.currentUrl, this.getUrl().getComboBox());
    }

    protected VirtualFile findFileByUrl(String s) {
        if (s == null) {
            s = "";
        }
        String s1 = s = StringUtil.trimStart((String)s, (String)"file:");
        return (VirtualFile)ReadAction.compute(() -> UriUtil.findRelativeFile((String)s1, null));
    }

    @Nullable
    protected ValidationInfo checkOneUrl(String s, JComponent from) {
        VirtualFile relativeFile = this.findFileByUrl(s);
        if (relativeFile == null) {
            return new ValidationInfo(WSBundle.message("file.doesn.t.exist.validation.message", s), from);
        }
        if (!this.isAcceptableFile(relativeFile)) {
            return new ValidationInfo(WSBundle.message("file.0.has.inappropriate.file.type.validation.message", s), from);
        }
        return null;
    }

    @Override
    protected boolean hasClassNameInUI() {
        return false;
    }

    @Override
    public void setCurrentFile(PsiFile aFile) {
        this.getUrl().getComboBox().setSelectedItem(aFile != null ? VfsUtilCore.fixIDEAUrl((String)aFile.getVirtualFile().getUrl()) : null);
        super.setCurrentFile(aFile);
    }

    protected boolean isMultipleFileSelection() {
        return this.multipleFileSelection;
    }

    protected void configureBrowseButton(final Project myProject, final ComboboxWithBrowseButton wsdlUrl, String[] _extensions, final String selectFileDialogTitle, boolean multipleFileSelection) {
        this.multipleFileSelection = multipleFileSelection;
        wsdlUrl.getComboBox().setEditable(true);
        wsdlUrl.getButton().setToolTipText(WebServicesPlugin.message("webservice.browse.tooltip"));
        final List<String> extensions = Arrays.asList(_extensions);
        final boolean useJars = extensions.contains("jar");
        wsdlUrl.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VirtualFile[] virtualFiles;
                VirtualFile fileByPath;
                FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, false, useJars, useJars, false, GenerateJavaCodeDialogBase.this.isMultipleFileSelection()){

                    public boolean isFileSelectable(VirtualFile virtualFile) {
                        return extensions.indexOf(virtualFile.getExtension()) != -1;
                    }
                };
                fileChooserDescriptor.setTitle(selectFileDialogTitle);
                VirtualFile initialFile = myProject.getBaseDir();
                Object selectedItem = wsdlUrl.getComboBox().getSelectedItem();
                if (selectedItem != null && selectedItem.toString().startsWith("file:") && (fileByPath = UriUtil.findRelativeFile((String)VfsUtil.fixURLforIDEA((String)selectedItem.toString()), null)) != null) {
                    initialFile = fileByPath;
                }
                if ((virtualFiles = FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor, (Project)myProject, (VirtualFile)initialFile)).length >= 1) {
                    String url = VfsUtilCore.fixIDEAUrl((String)virtualFiles[0].getUrl());
                    for (int i = 1; i < virtualFiles.length; ++i) {
                        url = url + GenerateJavaCodeDialogBase.SEPARATOR_CHAR + VfsUtilCore.fixIDEAUrl((String)virtualFiles[i].getUrl());
                    }
                    wsdlUrl.getComboBox().setSelectedItem(url);
                }
            }
        });
    }

    protected void configureBrowseButton(Project myProject, ComboboxWithBrowseButton wsdlUrl, String[] _extensions, String selectFileDialogTitle) {
        this.configureBrowseButton(myProject, wsdlUrl, _extensions, selectFileDialogTitle, false);
    }

    @Override
    protected MyValidationData createValidationData() {
        return new MyValidationData();
    }

    protected void doOKAction() {
        JCheckBox addLib = this.getAddLibs();
        if (addLib != null) {
            WebServicesPlugin.getInstance(this.myProject).setToAddRequiredLibraries(addLib.isSelected());
        }
        super.doOKAction();
    }

    @Nullable
    protected abstract JCheckBox getAddLibs();

    @Nullable
    protected abstract EditorComboBox getPackagePrefix();

    @Nullable
    protected abstract JComboBox getOutputPaths();

    @Nullable
    protected abstract JLabel getOutputPathsText();

    @Nullable
    protected abstract JLabel getPackagePrefixText();

    protected abstract ComboboxWithBrowseButton getUrl();

    protected class MyValidationData
    extends MyDialogWrapper.ValidationData {
        Object currentPackagePrefix;
        public Object currentUrl;

        protected MyValidationData() {
        }

        @Override
        protected void doAcquire() {
            EditorComboBox packagePrefix = GenerateJavaCodeDialogBase.this.getPackagePrefix();
            this.currentPackagePrefix = packagePrefix != null ? packagePrefix.getText() : null;
            this.currentUrl = GenerateJavaCodeDialogBase.this.getUrl().getComboBox().getEditor().getItem();
        }
    }
}

