/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.utils.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ws.WSBundle;
import com.intellij.ws.WebServicesPluginSettings;
import com.intellij.ws.engines.axis.AxisUtil;
import com.intellij.ws.utils.ui.MyDialogWrapper;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public abstract class DialogWithServerContext
extends MyDialogWrapper {
    protected DialogWithServerContext(Project project) {
        super(project);
    }

    @Override
    protected ValidationInfo doValidate(MyDialogWrapper.ValidationData _data) {
        if (!AxisUtil.simpleCheckThatServerOnLocalHostIsRunning()) {
            WebServicesPluginSettings instance = WebServicesPluginSettings.getInstance();
            return new ValidationInfo(WSBundle.message("the.web.server.0.1.is.not.running.launch.the.webservices.web.module.in.local.tomcat.run.debug.session.or.change.server.port.in.plugin.settings.validation.message", instance.getHostName(), instance.getHostPort()), null);
        }
        MyValidationData validationData = (MyValidationData)_data;
        return this.doValidateWithData(validationData);
    }

    protected ValidationInfo doValidateWithData(MyValidationData validationData) {
        String contextName = validationData.contextName;
        for (int i = 0; i < contextName.length(); ++i) {
            char ch = contextName.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '_') continue;
            return new ValidationInfo(WSBundle.message("context.name.should.consist.of.alphanumeric.and.letters.only.validation.message", new Object[0]), (JComponent)this.getContextNamesCombo());
        }
        return this.doCheckServlet(contextName);
    }

    protected ValidationInfo doCheckServlet(String contextName) {
        if (!AxisUtil.simpleHappyServlet(contextName, "AxisServlet")) {
            return new ValidationInfo(WSBundle.message("nonvalid.context.or.axisservlet.is.not.present.web.service.support.not.enabled.for.module.validation.message", new Object[0]), (JComponent)this.getContextNamesCombo());
        }
        return null;
    }

    @Override
    protected MyValidationData createValidationData() {
        return new MyValidationData();
    }

    protected String getCurrentValueOf(JComponent comp) {
        if (comp instanceof JComboBox) {
            JComboBox comboBox = (JComboBox)comp;
            if (comboBox.isEditable()) {
                return comboBox.getEditor().getItem().toString();
            }
            Object selectedItem = comboBox.getSelectedItem();
            return selectedItem != null ? selectedItem.toString() : null;
        }
        if (comp instanceof JTextField) {
            return ((JTextField)comp).getText();
        }
        return "";
    }

    protected abstract JComboBox getContextNamesCombo();

    protected class MyValidationData
    extends MyDialogWrapper.ValidationData {
        public String contextName;

        protected MyValidationData() {
        }

        @Override
        protected void doAcquire() {
            this.contextName = DialogWithServerContext.this.getCurrentValueOf(DialogWithServerContext.this.getContextNamesCombo());
        }
    }
}

