/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.ws.index.FileBasedWSIndex;
import com.intellij.ws.index.WSTextRange;
import com.intellij.ws.references.ClassReferenceThatReferencesAnyMethod;
import com.intellij.ws.references.MemberReferenceThatKnowsAboutParentClassName;
import com.intellij.ws.references.WSDDReferenceProvider;
import com.intellij.ws.references.WSDLReferenceProvider;
import com.intellij.ws.utils.XmlRecursiveElementVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSIndexEntry {
    public static final WSIndexEntry[] EMPTY = new WSIndexEntry[0];
    private final Object lock = new Object();
    private String myFileUrl;
    private String myLastClassQName;
    private boolean resolved = false;
    final Set<String> myCandidates = new HashSet<String>();
    final Set<String> mySymbols = new HashSet<String>(5);
    final Map<String, String> myLinkTypes = new HashMap<String, String>(5);
    final Map<String, WSTextRange> myLinks = new HashMap<String, WSTextRange>(5);
    private int hashCode;
    private VirtualFile file;
    private long myJavaModCounter = -1L;

    WSIndexEntry(FileContent content) throws IOException {
        this.hashCode = StringUtil.stringHashCode((CharSequence)content.getContentAsText());
        this.myFileUrl = content.getFile().getUrl();
        NanoXmlUtil.parse((Reader)CharArrayUtil.readerFromCharSequence((CharSequence)content.getContentAsText()), (IXMLBuilder)new NanoXmlUtil.BaseXmlBuilder(){
            final char[] pcdata = new char[96];

            public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
                if (WSIndexEntry.isFQNLike(value)) {
                    WSIndexEntry.this.myCandidates.add(WSIndexEntry.getClassName(value));
                }
            }

            public void addPCData(Reader reader, String systemID, int lineNr) throws Exception {
                int read = reader.read(this.pcdata);
                String candidate = new StringBuilder().append(this.pcdata, 0, read).toString();
                if (WSIndexEntry.isFQNLike(candidate)) {
                    WSIndexEntry.this.myCandidates.add(WSIndexEntry.getClassName(candidate));
                }
            }
        });
    }

    private static String getClassName(@NotNull String value) {
        if (value == null) {
            WSIndexEntry.$$$reportNull$$$0(0);
        }
        List tokens = StringUtil.split((String)value, (String)".");
        return (String)tokens.get(tokens.size() - 1);
    }

    private static boolean isFQNLike(String value) {
        if (value == null || value.length() == 0 || value.charAt(0) == '.' || value.charAt(value.length() - 1) == '.') {
            return false;
        }
        for (String clazz : StringUtil.split((String)value, (String)".")) {
            if (WSIndexEntry.isClassName(clazz)) continue;
            return false;
        }
        return true;
    }

    private static boolean isClassName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isResolved(Project project) {
        long count = PsiManager.getInstance((Project)project).getModificationTracker().getJavaStructureModificationCount();
        return this.myJavaModCounter == count;
    }

    public void resolve(Project project) {
        VirtualFile vf = this.getFile();
        if (vf == null) {
            return;
        }
        PsiFile psifile = PsiManager.getInstance((Project)project).findFile(vf);
        if (!(psifile instanceof XmlFile)) {
            return;
        }
        this.file = psifile.getVirtualFile();
        final XmlFile xml = (XmlFile)psifile;
        XmlDocument doc = xml.getDocument();
        if (doc == null) {
            return;
        }
        XmlTag rootTag = doc.getRootTag();
        if (rootTag == null) {
            return;
        }
        VirtualFile virtualFile = this.file;
        final boolean wsddFile = "wsdd".equals(virtualFile.getExtension());
        final boolean servicesXmlFile = FileBasedWSIndex.isXFireWs(virtualFile);
        final boolean sunJaxWsXmlFile = FileBasedWSIndex.isSunJaxWs(virtualFile);
        final boolean jaxRpcXmlFile = FileBasedWSIndex.isJaxRpc(virtualFile);
        final boolean jaxRpcXmlFile2 = FileBasedWSIndex.isJaxRpc2(virtualFile);
        final boolean cxf = FileBasedWSIndex.isCxf(virtualFile);
        final boolean wsdl = "wsdl".equals(virtualFile.getExtension());
        if (servicesXmlFile && !"serviceGroup".equals(rootTag.getLocalName())) {
            return;
        }
        rootTag.acceptChildren((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            @Override
            public void visitXmlAttributeValue(XmlAttributeValue value) {
                PsiReference[] references;
                for (PsiReference r : references = value.getReferences()) {
                    if (r instanceof WSDLReferenceProvider.WsdlClassReference) {
                        WSIndexEntry.this.addClass(r, (PsiFile)xml);
                        continue;
                    }
                    if (r instanceof WSDLReferenceProvider.WsdlMethodReference || r instanceof WSDLReferenceProvider.WsdlPropertyReference || r instanceof WSDDReferenceProvider.WSMethodReference) {
                        WSIndexEntry.this.addMethodOrField(r, value, (PsiFile)xml);
                        continue;
                    }
                    if (wsddFile || sunJaxWsXmlFile || jaxRpcXmlFile2 || cxf) {
                        WSIndexEntry.this.addClass(r, (PsiFile)xml);
                        continue;
                    }
                    if (!servicesXmlFile) continue;
                    WSIndexEntry.this.addMethodOrField(r, value, (PsiFile)xml);
                }
            }

            @Override
            public void visitXmlTag(XmlTag xmlTag) {
                if (servicesXmlFile || jaxRpcXmlFile) {
                    PsiReference[] references = xmlTag.getReferences();
                    for (int i = 2; i < references.length; ++i) {
                        WSIndexEntry.this.addClass(references[i], (PsiFile)xml);
                    }
                    super.visitXmlTag(xmlTag);
                } else if (sunJaxWsXmlFile || jaxRpcXmlFile2 || wsdl || cxf || wsddFile) {
                    super.visitXmlTag(xmlTag);
                }
            }
        });
        this.setJavaModificationCounter(project);
        this.resolved = false;
    }

    private void setJavaModificationCounter(Project project) {
        this.myJavaModCounter = PsiManager.getInstance((Project)project).getModificationTracker().getJavaStructureModificationCount();
    }

    private void addMethodOrField(PsiReference r, XmlAttributeValue value, PsiFile file) {
        PsiElement psiElement = r.resolve();
        if (psiElement == r.getElement()) {
            String className = r instanceof MemberReferenceThatKnowsAboutParentClassName ? ((MemberReferenceThatKnowsAboutParentClassName)r).getParentClassName() : this.myLastClassQName;
            this.addMemberLink(className + "." + "*", (PsiElement)value, r, file);
            return;
        }
        if (!(psiElement instanceof PsiMember)) {
            return;
        }
        if (psiElement instanceof PsiClass) {
            return;
        }
        PsiMember psiMember = (PsiMember)psiElement;
        this.addMemberLink(FileBasedWSIndex.getKey(psiMember), (PsiElement)value, r, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMemberLink(String name, PsiElement value, PsiReference r, PsiFile file) {
        String type = r instanceof WSDLReferenceProvider.WsdlPropertyReference ? (WSIndexEntry.isWsdlFile(file) ? "Web service parameter property" : "JAXB mapped property") : "Web service method";
        Object object = this.lock;
        synchronized (object) {
            this.myLinks.put(name, new WSTextRange(value.getTextRange()));
            this.mySymbols.add(name);
            this.myLinkTypes.put(name, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClass(PsiReference r, PsiFile file) {
        PsiElement psiElement = r.resolve();
        this.myLastClassQName = "";
        if (!(psiElement instanceof PsiClass)) {
            return;
        }
        PsiClass psiMember = (PsiClass)psiElement;
        String qualifiedName = psiMember.getQualifiedName();
        PsiElement element = r.getElement();
        String linkType = WSIndexEntry.getLinkType(element, file);
        this.myLastClassQName = qualifiedName;
        Object object = this.lock;
        synchronized (object) {
            this.myLinks.put(qualifiedName, new WSTextRange(element.getTextRange()));
            this.mySymbols.add(psiMember.getQualifiedName());
            this.myLinkTypes.put(qualifiedName, linkType);
        }
        if (r instanceof ClassReferenceThatReferencesAnyMethod) {
            this.addMemberLink(qualifiedName + "." + "*", element, r, file);
        }
    }

    private static String getLinkType(PsiElement value, PsiFile file) {
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)value, XmlTag.class, (boolean)false);
        if (xmlTag == null) {
            return "";
        }
        String localName = xmlTag.getLocalName();
        if (localName.equals("parameter")) {
            if ("className".equals(xmlTag.getAttributeValue("name"))) {
                return "Web service";
            }
        } else if (localName.equals("beanMapping")) {
            return "Web service parameter type";
        }
        return "complexType".equals(localName) || "part".equals(localName) ? (WSIndexEntry.isWsdlFile(file) ? "Web service parameter type" : "JAXB mapped type") : "Web service";
    }

    private static boolean isWsdlFile(PsiFile containingFile) {
        VirtualFile file = containingFile != null ? containingFile.getOriginalFile().getVirtualFile() : null;
        return file != null && "wsdl".equals(file.getExtension());
    }

    @Nullable
    public String getWsStatus(PsiMember c) {
        String qname = FileBasedWSIndex.getKey(c);
        String s = this.myLinkTypes.get(qname);
        if (s == null && (qname = FileBasedWSIndex.getAnyKey(c)) != null) {
            s = this.myLinkTypes.get(qname);
        }
        return s;
    }

    public boolean hasNonImplicitRef(PsiMember c) {
        return this.myLinkTypes.get(FileBasedWSIndex.getKey(c)) != null;
    }

    @Nullable
    public VirtualFile getFile() {
        if (this.file != null) {
            return this.file;
        }
        try {
            return VfsUtilCore.findRelativeFile((String)this.myFileUrl, null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public TextRange getWsRange(PsiMember c) {
        TextRange textRange;
        String qname = FileBasedWSIndex.getKey(c);
        TextRange textRange2 = textRange = this.myLinks.get(qname) != null ? this.myLinks.get(qname).getTextRange() : null;
        if (textRange == null && (qname = FileBasedWSIndex.getAnyKey(c)) != null) {
            textRange = this.myLinks.get(qname) != null ? this.myLinks.get(qname).getTextRange() : null;
        }
        return textRange;
    }

    WSIndexEntry(DataInput in) throws IOException {
        this.myFileUrl = WSIndexEntry.readString(in);
        this.myLastClassQName = WSIndexEntry.readString(in);
        this.resolved = in.readBoolean();
        this.hashCode = in.readInt();
        WSIndexEntry.readStringSet(this.myCandidates, in);
        WSIndexEntry.readStringSet(this.mySymbols, in);
        WSIndexEntry.readStringMap(this.myLinkTypes, in);
        WSIndexEntry.readTextRangeMap(this.myLinks, in);
    }

    void write(DataOutput out) throws IOException {
        WSIndexEntry.writeString(this.myFileUrl, out);
        WSIndexEntry.writeString(this.myLastClassQName, out);
        out.writeBoolean(this.resolved);
        out.writeInt(this.hashCode);
        WSIndexEntry.writeStringSet(this.myCandidates, out);
        WSIndexEntry.writeStringSet(this.mySymbols, out);
        WSIndexEntry.writeStringMap(this.myLinkTypes, out);
        WSIndexEntry.writeTextRangeMap(this.myLinks, out);
    }

    private static void readStringSet(Set<String> set, DataInput in) throws IOException {
        int length = DataInputOutputUtil.readINT((DataInput)in);
        while (length-- > 0) {
            set.add(WSIndexEntry.readString(in));
        }
    }

    private static void writeStringSet(Set<String> set, DataOutput out) throws IOException {
        DataInputOutputUtil.writeINT((DataOutput)out, (int)set.size());
        for (String s : set) {
            WSIndexEntry.writeString(s, out);
        }
    }

    private static void readStringMap(Map<String, String> map, DataInput in) throws IOException {
        int length = DataInputOutputUtil.readINT((DataInput)in);
        while (length-- > 0) {
            map.put(IOUtil.readUTF((DataInput)in), IOUtil.readUTF((DataInput)in));
        }
    }

    private static void writeStringMap(Map<String, String> map, DataOutput out) throws IOException {
        DataInputOutputUtil.writeINT((DataOutput)out, (int)map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            IOUtil.writeUTF((DataOutput)out, (String)entry.getKey());
            IOUtil.writeUTF((DataOutput)out, (String)entry.getValue());
        }
    }

    private static void readTextRangeMap(Map<String, WSTextRange> map, DataInput in) throws IOException {
        int length = DataInputOutputUtil.readINT((DataInput)in);
        while (length-- > 0) {
            map.put(IOUtil.readUTF((DataInput)in), new WSTextRange(DataInputOutputUtil.readINT((DataInput)in), DataInputOutputUtil.readINT((DataInput)in)));
        }
    }

    private static void writeTextRangeMap(Map<String, WSTextRange> map, DataOutput out) throws IOException {
        DataInputOutputUtil.writeINT((DataOutput)out, (int)map.size());
        for (Map.Entry<String, WSTextRange> entry : map.entrySet()) {
            IOUtil.writeUTF((DataOutput)out, (String)entry.getKey());
            WSTextRange range = entry.getValue();
            DataInputOutputUtil.writeINT((DataOutput)out, (int)range.getStartOffset());
            DataInputOutputUtil.writeINT((DataOutput)out, (int)range.getEndOffset());
        }
    }

    @Nullable
    private static String readString(DataInput in) throws IOException {
        return in.readBoolean() ? IOUtil.readUTF((DataInput)in) : null;
    }

    private static void writeString(String s, DataOutput out) throws IOException {
        if (s == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            IOUtil.writeUTF((DataOutput)out, (String)s);
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof WSIndexEntry && this.hashCode == obj.hashCode() && WSIndexEntry.equals(this.myFileUrl, ((WSIndexEntry)obj).myFileUrl);
    }

    private static boolean equals(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ws/index/WSIndexEntry", "getClassName"));
    }
}

