/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.facet.client;

import com.intellij.facet.frameworks.LibrariesDownloadAssistant;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.engines.jwsdp.JWSDPWSEngine;
import java.net.URL;
import java.util.HashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class WebServicesClientLibraries {
    public static final String JAXWS = JWSDPWSEngine.JWSDP_PLATFORM;
    public static final String AXIS = "Apache Axis";
    public static final String[] SUPPORTED_PLATFORM = new String[]{JAXWS, "Apache Axis"};
    @NonNls
    public static final HashMap<String, String> PLATFORM_NAMES = new HashMap();
    public static final HashMap<String, String> DEFAULT_VERSIONS;

    private WebServicesClientLibraries() {
    }

    public static boolean isSupported(String platformName) {
        for (String platform : SUPPORTED_PLATFORM) {
            if (!platform.equals(platformName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static URL createUrl(@NotNull String platform) {
        if (platform == null) {
            WebServicesClientLibraries.$$$reportNull$$$0(0);
        }
        String shortName = PLATFORM_NAMES.get(platform);
        URL uRL = WebServicesClientLibraries.class.getResource("/versions/" + shortName + ".xml");
        if (uRL == null) {
            WebServicesClientLibraries.$$$reportNull$$$0(1);
        }
        return uRL;
    }

    @NotNull
    public static LibraryInfo[] getRequiredLibraries(@NotNull String platform, @NotNull String versionId) {
        if (platform == null) {
            WebServicesClientLibraries.$$$reportNull$$$0(2);
        }
        if (versionId == null) {
            WebServicesClientLibraries.$$$reportNull$$$0(3);
        }
        LibraryInfo[] libraryInfoArray = LibrariesDownloadAssistant.getLibraryInfos((URL)WebServicesClientLibraries.createUrl(platform), (String)versionId);
        if (libraryInfoArray == null) {
            WebServicesClientLibraries.$$$reportNull$$$0(4);
        }
        return libraryInfoArray;
    }

    @NotNull
    public static LibraryInfo[] getRequiredLibraries(@NotNull String platform) {
        if (platform == null) {
            WebServicesClientLibraries.$$$reportNull$$$0(5);
        }
        LibraryInfo[] libraryInfoArray = WebServicesClientLibraries.getRequiredLibraries(platform, DEFAULT_VERSIONS.get(platform));
        if (libraryInfoArray == null) {
            WebServicesClientLibraries.$$$reportNull$$$0(6);
        }
        return libraryInfoArray;
    }

    public static String[] getRequiredJarNames(@NotNull String platform) {
        if (platform == null) {
            WebServicesClientLibraries.$$$reportNull$$$0(7);
        }
        return (String[])ContainerUtil.map2Array((Object[])WebServicesClientLibraries.getRequiredLibraries(platform), String.class, libraryInfo -> libraryInfo.getName());
    }

    static {
        PLATFORM_NAMES.put(JAXWS, "jaxws");
        PLATFORM_NAMES.put(AXIS, "axis");
        DEFAULT_VERSIONS = new HashMap();
        DEFAULT_VERSIONS.put(JAXWS, JAXWS);
        DEFAULT_VERSIONS.put(AXIS, "1.4");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platform";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/facet/client/WebServicesClientLibraries";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/facet/client/WebServicesClientLibraries";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createUrl";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredLibraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUrl";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredLibraries";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredJarNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

