/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.workbench.AttachedToolWindow;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class FloatingToolWindow<T>
implements Disposable {
    private final ToolContent<T> myContent;
    private final ToolWindowEx myToolWindow;
    private AttachedToolWindow<T> myCorrespondingToolWindow;

    public FloatingToolWindow(@NotNull Project project, @NotNull ToolWindowDefinition<T> definition) {
        if (project == null) {
            FloatingToolWindow.$$$reportNull$$$0(0);
        }
        if (definition == null) {
            FloatingToolWindow.$$$reportNull$$$0(1);
        }
        this(definition, ToolWindowManager.getInstance((Project)project));
    }

    public FloatingToolWindow(@NotNull ToolWindowDefinition<T> definition, @NotNull ToolWindowManager toolWindowManager) {
        if (definition == null) {
            FloatingToolWindow.$$$reportNull$$$0(2);
        }
        if (toolWindowManager == null) {
            FloatingToolWindow.$$$reportNull$$$0(3);
        }
        this.myContent = (ToolContent)definition.getFactory().create();
        this.myToolWindow = this.createToolWindow(toolWindowManager, definition);
        Disposer.register((Disposable)this, this.myContent);
    }

    public void show(@NotNull AttachedToolWindow<T> correspondingWindow) {
        if (correspondingWindow == null) {
            FloatingToolWindow.$$$reportNull$$$0(4);
        }
        this.updateState(correspondingWindow);
        this.myContent.setToolContext(correspondingWindow.getContext());
        this.myToolWindow.setAvailable(true, null);
        this.myToolWindow.show(null);
    }

    public void hide() {
        this.myContent.setToolContext(null);
        this.myToolWindow.setAvailable(false, null);
    }

    private void updateState(@NotNull AttachedToolWindow<T> correspondingWindow) {
        if (correspondingWindow == null) {
            FloatingToolWindow.$$$reportNull$$$0(5);
        }
        this.myCorrespondingToolWindow = correspondingWindow;
        ToolWindowAnchor anchor = correspondingWindow.isLeft() ? ToolWindowAnchor.LEFT : ToolWindowAnchor.RIGHT;
        this.myToolWindow.setAnchor(anchor, null);
    }

    private ToolWindowEx createToolWindow(@NotNull ToolWindowManager toolWindowManager, @NotNull ToolWindowDefinition<T> definition) {
        String id;
        ToolWindowEx window;
        if (toolWindowManager == null) {
            FloatingToolWindow.$$$reportNull$$$0(6);
        }
        if (definition == null) {
            FloatingToolWindow.$$$reportNull$$$0(7);
        }
        if ((window = (ToolWindowEx)toolWindowManager.getToolWindow(id = definition.getTitle())) == null) {
            ToolWindowAnchor anchor = definition.getSide().isLeft() ? ToolWindowAnchor.LEFT : ToolWindowAnchor.RIGHT;
            window = (ToolWindowEx)toolWindowManager.registerToolWindow(id, false, anchor, (Disposable)this, true);
            window.setIcon(definition.getIcon());
            window.setType(ToolWindowType.FLOATING, null);
            window.setAutoHide(false);
            this.setToolWindowContent(window);
            this.setAdditionalGearPopupActions(window);
            this.setAdditionalActions(window);
        }
        return window;
    }

    private void setToolWindowContent(@NotNull ToolWindowEx toolWindow) {
        ContentManager contentManager;
        Content content;
        if (toolWindow == null) {
            FloatingToolWindow.$$$reportNull$$$0(8);
        }
        if ((content = (contentManager = toolWindow.getContentManager()).getSelectedContent()) == null) {
            content = contentManager.getFactory().createContent(this.myContent.getComponent(), null, false);
            content.setCloseable(false);
            content.setComponent(this.myContent.getComponent());
            content.setPreferredFocusableComponent(this.myContent.getFocusedComponent());
            content.setShouldDisposeContent(true);
            contentManager.addContent(content);
            contentManager.setSelectedContent(content, true);
        }
    }

    private void setAdditionalActions(@NotNull ToolWindowEx toolWindow) {
        List<AnAction> actionList;
        if (toolWindow == null) {
            FloatingToolWindow.$$$reportNull$$$0(9);
        }
        if (!(actionList = this.myContent.getAdditionalActions()).isEmpty()) {
            AnAction[] actions = new AnAction[actionList.size()];
            actionList.toArray(actions);
            toolWindow.setTitleActions(actions);
        }
    }

    private void setAdditionalGearPopupActions(@NotNull ToolWindowEx toolWindow) {
        if (toolWindow == null) {
            FloatingToolWindow.$$$reportNull$$$0(10);
        }
        DefaultActionGroup attachedSide = new DefaultActionGroup("Attached Side", true);
        attachedSide.add((AnAction)new AttachToSideAction(Side.LEFT));
        attachedSide.add((AnAction)new AttachToSideAction(Side.RIGHT));
        toolWindow.setAdditionalGearActions((ActionGroup)new DefaultActionGroup(new AnAction[]{attachedSide}));
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowManager";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "correspondingWindow";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/adtui/workbench/FloatingToolWindow";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "show";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateState";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createToolWindow";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "setToolWindowContent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "setAdditionalActions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "setAdditionalGearPopupActions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class AttachToSideAction
    extends AnAction {
        private final Side mySide;

        public AttachToSideAction(Side side) {
            if (side == null) {
                AttachToSideAction.$$$reportNull$$$0(0);
            }
            super(side.isLeft() ? "Left" : "Right");
            this.mySide = side;
        }

        public void update(@NotNull AnActionEvent event) {
            if (event == null) {
                AttachToSideAction.$$$reportNull$$$0(1);
            }
            event.getPresentation().setEnabledAndVisible(FloatingToolWindow.this.myCorrespondingToolWindow != null);
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                AttachToSideAction.$$$reportNull$$$0(2);
            }
            if (FloatingToolWindow.this.myCorrespondingToolWindow != null) {
                FloatingToolWindow.this.myToolWindow.setAvailable(false, null);
                FloatingToolWindow.this.myCorrespondingToolWindow.setLeft(this.mySide.isLeft());
                FloatingToolWindow.this.myCorrespondingToolWindow.setPropertyAndUpdate(AttachedToolWindow.PropertyType.FLOATING, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/adtui/workbench/FloatingToolWindow$AttachToSideAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

