/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.treegrid;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.speedSearch.FilteringListModel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeGrid<T>
extends Box {
    private final Map<Object, JComponent> mySectionToComponent;
    private final List<JList<T>> myLists;
    private final List<HideableDecorator> myHideables;
    private final KeyListener myKeyListener;
    private boolean myFiltered;

    public TreeGrid(@NotNull AbstractTreeStructure model) {
        if (model == null) {
            TreeGrid.$$$reportNull$$$0(0);
        }
        this();
        this.setModelWithSectionHeaders(model);
    }

    public TreeGrid() {
        super(1);
        this.mySectionToComponent = new IdentityHashMap<Object, JComponent>();
        this.myLists = new ArrayList<JList<T>>();
        this.myHideables = new ArrayList<HideableDecorator>();
        this.myKeyListener = new MyKeyListener();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.setBackground(UIUtil.getListBackground());
        this.setOpaque(true);
    }

    public void setModel(@NotNull AbstractTreeStructure model) {
        if (model == null) {
            TreeGrid.$$$reportNull$$$0(1);
        }
        this.setModel(model, false);
    }

    public void setModelWithSectionHeaders(@NotNull AbstractTreeStructure model) {
        if (model == null) {
            TreeGrid.$$$reportNull$$$0(2);
        }
        this.setModel(model, true);
    }

    private void setModel(final @NotNull AbstractTreeStructure model, boolean showSectionHeaders) {
        if (model == null) {
            TreeGrid.$$$reportNull$$$0(3);
        }
        Object root = model.getRootElement();
        Object[] sections = model.getChildElements(root);
        this.mySectionToComponent.clear();
        this.myLists.clear();
        this.myHideables.clear();
        this.removeAll();
        this.setAutoscrolls(false);
        ListSelectionListener listSelectionListener = e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel sourceSelectionModel = (ListSelectionModel)e.getSource();
            if (!sourceSelectionModel.isSelectionEmpty()) {
                for (JList<T> aList : this.myLists) {
                    if (sourceSelectionModel == aList.getSelectionModel()) continue;
                    aList.clearSelection();
                }
            }
        };
        for (final Object section : sections) {
            String name = section.toString();
            FilteringListModel listModel = new FilteringListModel((ListModel)new AbstractListModel(){

                @Override
                public int getSize() {
                    return model.getChildElements(section).length;
                }

                @Override
                public Object getElementAt(int index) {
                    return model.getChildElements(section)[index];
                }
            });
            listModel.refilter();
            JList list = new JList(listModel);
            list.setAutoscrolls(false);
            list.setSelectionMode(0);
            list.setVisibleRowCount(-1);
            list.getSelectionModel().addListSelectionListener(listSelectionListener);
            list.setName(name);
            list.addKeyListener(this.myKeyListener);
            new ListSpeedSearch(list);
            this.myLists.add(list);
            if (showSectionHeaders) {
                JPanel panel = new JPanel(new BorderLayout()){

                    @Override
                    public Dimension getMaximumSize() {
                        return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
                    }
                };
                HideableDecorator hidyPanel = new HideableDecorator(panel, name, false);
                this.myHideables.add(hidyPanel);
                hidyPanel.setContentComponent(list);
                this.add(panel);
                this.mySectionToComponent.put(section, panel);
                continue;
            }
            if (this.getComponentCount() > 0) {
                this.add(new JSeparator());
            }
            list.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.add(list);
            this.mySectionToComponent.put(section, list);
        }
    }

    public void setVisibleSection(@Nullable Object section) {
        JComponent visible = section != null ? this.mySectionToComponent.get(section) : null;
        for (Component component : this.getComponents()) {
            component.setVisible(visible == null);
        }
        if (visible != null) {
            visible.setVisible(true);
        }
    }

    @Override
    public void setTransferHandler(@Nullable TransferHandler handler) {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        for (JList<T> list : this.myLists) {
            list.setTransferHandler(handler);
            list.setDragEnabled(handler != null);
        }
    }

    public void addListSelectionListener(@NotNull ListSelectionListener lsl) {
        if (lsl == null) {
            TreeGrid.$$$reportNull$$$0(4);
        }
        for (JList<T> list : this.myLists) {
            list.getSelectionModel().addListSelectionListener(lsl);
        }
    }

    public void setCellRenderer(@NotNull ListCellRenderer<T> cellRenderer) {
        if (cellRenderer == null) {
            TreeGrid.$$$reportNull$$$0(5);
        }
        for (JList<T> list : this.myLists) {
            list.setCellRenderer(cellRenderer);
        }
    }

    public void setFixedCellWidth(int width) {
        for (JList<T> list : this.myLists) {
            list.setFixedCellWidth(width);
        }
    }

    public void setFixedCellHeight(int height) {
        for (JList<T> list : this.myLists) {
            list.setFixedCellHeight(height);
        }
    }

    public void expandAll() {
        for (HideableDecorator hidyPanel : this.myHideables) {
            hidyPanel.setOn(true);
        }
    }

    @Nullable
    private JList<T> getSelectedList() {
        for (JList<T> list : this.myLists) {
            if (list.getSelectedIndex() <= -1) continue;
            return list;
        }
        return null;
    }

    @Override
    public void requestFocus() {
        JComponent component = this.getFocusRecipient();
        if (component != null) {
            component.requestFocus();
        }
    }

    @Nullable
    public JComponent getFocusRecipient() {
        JList<T> firstVisible = null;
        for (JList<T> list : this.myLists) {
            if (!list.isVisible()) continue;
            if (list.getSelectedIndex() != -1) {
                return list;
            }
            if (firstVisible != null || list.getModel().getSize() <= 0) continue;
            firstVisible = list;
        }
        if (firstVisible != null) {
            this.setSelectedElement(firstVisible.getModel().getElementAt(0));
        }
        return firstVisible;
    }

    @Nullable
    public T getSelectedElement() {
        JList<T> list = this.getSelectedList();
        return list != null ? (T)list.getSelectedValue() : null;
    }

    public void setSelectedElement(@Nullable T selectedElement) {
        for (JList<T> list : this.myLists) {
            if (selectedElement == null) {
                list.clearSelection();
                continue;
            }
            for (int i = 0; i < list.getModel().getSize(); ++i) {
                if (list.getModel().getElementAt(i) != selectedElement) continue;
                list.setSelectedIndex(i);
                this.ensureIndexVisible(list, i);
                return;
            }
        }
    }

    private void ensureIndexVisible(@NotNull JList<T> list, int index) {
        if (list == null) {
            TreeGrid.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Rectangle cellBounds;
            if (list == null) {
                TreeGrid.$$$reportNull$$$0(10);
            }
            if ((cellBounds = list.getCellBounds(index, index)) != null) {
                list.getBounds();
                Rectangle rectangle = SwingUtilities.convertRectangle(list, cellBounds, this);
                this.scrollRectToVisible(rectangle);
            }
        }, ModalityState.any());
    }

    @Override
    public void addMouseListener(@NotNull MouseListener l) {
        if (l == null) {
            TreeGrid.$$$reportNull$$$0(7);
        }
        for (JList<T> list : this.myLists) {
            list.addMouseListener(l);
        }
    }

    @Override
    public void removeMouseListener(@NotNull MouseListener l) {
        if (l == null) {
            TreeGrid.$$$reportNull$$$0(8);
        }
        for (JList<T> list : this.myLists) {
            list.removeMouseListener(l);
        }
    }

    public void setLayoutOrientation(int mode) {
        for (JList<T> list : this.myLists) {
            list.setLayoutOrientation(mode);
        }
    }

    public void setFilter(@Nullable Condition<T> condition) {
        this.myFiltered = condition != null;
        for (JList<T> list : this.myLists) {
            ((FilteringListModel)list.getModel()).setFilter(condition);
        }
    }

    public boolean isFiltered() {
        return this.myFiltered;
    }

    public void selectIfUnique() {
        T single = this.findSingleItem();
        if (single != null) {
            this.setSelectedElement(single);
        }
    }

    @Nullable
    private T findSingleItem() {
        T singleMatch = null;
        boolean found = false;
        for (JList<T> list : this.myLists) {
            ListModel<T> model = list.getModel();
            int size = model.getSize();
            if (size == 1) {
                if (found) {
                    return null;
                }
                found = true;
                singleMatch = model.getElementAt(0);
                continue;
            }
            if (size <= 1) continue;
            return null;
        }
        return singleMatch;
    }

    public void selectFirst() {
        for (JList<T> list : this.myLists) {
            ListModel<T> model = list.getModel();
            int size = model.getSize();
            if (size <= 0) continue;
            T item = model.getElementAt(0);
            this.setSelectedElement(item);
            list.requestFocus();
            this.ensureIndexVisible(list, 0);
            return;
        }
    }

    @Nullable
    JList<T> getSelectedComponent() {
        return this.getSelectedList();
    }

    @NotNull
    public List<JList<T>> getLists() {
        List<JList<T>> list = this.myLists;
        if (list == null) {
            TreeGrid.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lsl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellRenderer";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/treegrid/TreeGrid";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/treegrid/TreeGrid";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLists";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setModelWithSectionHeaders";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addListSelectionListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setCellRenderer";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "ensureIndexVisible";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addMouseListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeMouseListener";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$ensureIndexVisible$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyKeyListener
    extends KeyAdapter {
        private int myLastMidX = -1;

        private MyKeyListener() {
        }

        @Override
        public void keyPressed(@NotNull KeyEvent event) {
            Object source;
            if (event == null) {
                MyKeyListener.$$$reportNull$$$0(0);
            }
            if (!((source = event.getSource()) instanceof JList)) {
                return;
            }
            JList list = (JList)source;
            boolean consumed = false;
            switch (event.getKeyCode()) {
                case 40: {
                    consumed = this.handleKeyDown(list);
                    break;
                }
                case 38: {
                    consumed = this.handleKeyUp(list);
                    break;
                }
                case 37: {
                    this.myLastMidX = -1;
                    consumed = this.handleKeyLeft(list);
                    break;
                }
                case 39: {
                    this.myLastMidX = -1;
                    consumed = this.handleKeyRight(list);
                }
            }
            if (consumed) {
                event.consume();
            }
        }

        private boolean handleKeyDown(@NotNull JList<T> list) {
            int selectedIndex;
            if (list == null) {
                MyKeyListener.$$$reportNull$$$0(1);
            }
            if ((selectedIndex = list.getSelectedIndex()) < 0) {
                return false;
            }
            if (this.myLastMidX < 0) {
                this.myLastMidX = this.midX(list, selectedIndex);
            }
            if (!this.isLastRow(list, selectedIndex)) {
                int nextLineStart = this.findNextListStart(list, selectedIndex);
                int newSelectedItem = this.findBestMatchFromLeft(list, this.myLastMidX, nextLineStart);
                this.selectNewItem(list, newSelectedItem, list);
                return true;
            }
            for (int listIndex = ContainerUtil.indexOf((List)TreeGrid.this.myLists, list) + 1; listIndex != 0 && listIndex < TreeGrid.this.myLists.size(); ++listIndex) {
                JList nextList = (JList)TreeGrid.this.myLists.get(listIndex);
                int itemCount = nextList.getModel().getSize();
                if (itemCount <= 0 || !nextList.isVisible()) continue;
                int newSelectedItem = this.findBestMatchFromLeft(nextList, this.myLastMidX, 0);
                this.selectNewItem(nextList, newSelectedItem, list);
                return true;
            }
            return false;
        }

        private boolean handleKeyUp(@NotNull JList<T> list) {
            int selectedIndex;
            if (list == null) {
                MyKeyListener.$$$reportNull$$$0(2);
            }
            if ((selectedIndex = list.getSelectedIndex()) < 0) {
                return false;
            }
            if (this.myLastMidX < 0) {
                this.myLastMidX = this.midX(list, selectedIndex);
            }
            if (!this.isFirstRow(list, selectedIndex)) {
                int prevLineEnd = this.findPrevListEnd(list, selectedIndex);
                int newSelectedItem = this.findBestMatchFromRight(list, this.myLastMidX, prevLineEnd);
                this.selectNewItem(list, newSelectedItem, list);
                return true;
            }
            for (int listIndex = ContainerUtil.indexOf((List)TreeGrid.this.myLists, list) - 1; listIndex >= 0; --listIndex) {
                JList prevList = (JList)TreeGrid.this.myLists.get(listIndex);
                int itemCount = prevList.getModel().getSize();
                if (itemCount <= 0 || !prevList.isVisible()) continue;
                int newSelectedItem = this.findBestMatchFromRight(prevList, this.myLastMidX, itemCount - 1);
                this.selectNewItem(prevList, newSelectedItem, list);
                return true;
            }
            return false;
        }

        private boolean handleKeyRight(@NotNull JList<T> list) {
            int selectedIndex;
            if (list == null) {
                MyKeyListener.$$$reportNull$$$0(3);
            }
            if ((selectedIndex = list.getSelectedIndex()) < 0) {
                return false;
            }
            if (selectedIndex < list.getModel().getSize() - 1) {
                this.selectNewItem(list, selectedIndex + 1, list);
                return true;
            }
            for (int listIndex = ContainerUtil.indexOf((List)TreeGrid.this.myLists, list) + 1; listIndex != 0 && listIndex < TreeGrid.this.myLists.size(); ++listIndex) {
                JList nextList = (JList)TreeGrid.this.myLists.get(listIndex);
                int itemCount = nextList.getModel().getSize();
                if (itemCount <= 0 || !nextList.isVisible()) continue;
                this.selectNewItem(nextList, 0, list);
                return true;
            }
            return false;
        }

        private boolean handleKeyLeft(@NotNull JList<T> list) {
            int selectedIndex;
            if (list == null) {
                MyKeyListener.$$$reportNull$$$0(4);
            }
            if ((selectedIndex = list.getSelectedIndex()) < 0) {
                return false;
            }
            if (selectedIndex > 0) {
                this.selectNewItem(list, selectedIndex - 1, list);
                return true;
            }
            for (int listIndex = ContainerUtil.indexOf((List)TreeGrid.this.myLists, list) - 1; listIndex >= 0; --listIndex) {
                JList prevList = (JList)TreeGrid.this.myLists.get(listIndex);
                int itemCount = prevList.getModel().getSize();
                if (itemCount <= 0 || !prevList.isVisible()) continue;
                this.selectNewItem(prevList, itemCount - 1, list);
                return true;
            }
            return false;
        }

        private int midX(@NotNull JList<T> list, int index) {
            if (list == null) {
                MyKeyListener.$$$reportNull$$$0(5);
            }
            Rectangle bounds = list.getCellBounds(index, index);
            return bounds.x + bounds.width / 2;
        }

        private boolean isFirstRow(@NotNull JList<T> list, int index) {
            if (list == null) {
                MyKeyListener.$$$reportNull$$$0(6);
            }
            Rectangle bounds = list.getCellBounds(index, index);
            Rectangle firstBounds = list.getCellBounds(0, 0);
            return this.verticalOverlap(bounds, firstBounds);
        }

        private boolean isLastRow(@NotNull JList<T> list, int index) {
            if (list == null) {
                MyKeyListener.$$$reportNull$$$0(7);
            }
            int last = list.getModel().getSize() - 1;
            Rectangle bounds = list.getCellBounds(index, index);
            Rectangle lastBounds = list.getCellBounds(last, last);
            return this.verticalOverlap(bounds, lastBounds);
        }

        private boolean verticalOverlap(@NotNull Rectangle bounds1, @NotNull Rectangle bounds2) {
            if (bounds1 == null) {
                MyKeyListener.$$$reportNull$$$0(8);
            }
            if (bounds2 == null) {
                MyKeyListener.$$$reportNull$$$0(9);
            }
            return bounds1.y < bounds2.y + bounds2.height && bounds1.y + bounds1.height > bounds2.y;
        }

        private int findPrevListEnd(@NotNull JList<T> list, int index) {
            if (list == null) {
                MyKeyListener.$$$reportNull$$$0(10);
            }
            Rectangle bounds = list.getCellBounds(index, index);
            int prevIndex = index;
            Rectangle prevBounds = bounds;
            while (index > 0 && this.verticalOverlap(bounds, prevBounds)) {
                prevBounds = list.getCellBounds(--prevIndex, prevIndex);
            }
            return prevIndex;
        }

        private int findNextListStart(@NotNull JList<T> list, int index) {
            if (list == null) {
                MyKeyListener.$$$reportNull$$$0(11);
            }
            int count = list.getModel().getSize();
            Rectangle bounds = list.getCellBounds(index, index);
            int nextIndex = index;
            Rectangle nextBounds = bounds;
            while (index < count && this.verticalOverlap(bounds, nextBounds)) {
                nextBounds = list.getCellBounds(++nextIndex, nextIndex);
            }
            return nextIndex;
        }

        private int findBestMatchFromLeft(@NotNull JList<T> list, int x, int startIndex) {
            if (list == null) {
                MyKeyListener.$$$reportNull$$$0(12);
            }
            int bestIndex = startIndex;
            int count = list.getModel().getSize();
            Rectangle bounds = list.getCellBounds(startIndex, startIndex);
            int y = bounds.y + bounds.height / 2;
            while (bestIndex < count && bounds.y < y && bounds.x + bounds.width < x) {
                bounds = list.getCellBounds(++bestIndex, bestIndex);
            }
            return bestIndex < count ? bestIndex : count - 1;
        }

        private int findBestMatchFromRight(@NotNull JList<T> list, int x, int startIndex) {
            if (list == null) {
                MyKeyListener.$$$reportNull$$$0(13);
            }
            int bestIndex = startIndex;
            Rectangle bounds = list.getCellBounds(bestIndex, bestIndex);
            int y = bounds.y + bounds.height / 2;
            while (bestIndex > 0 && bounds.y + bounds.height > y && bounds.x > x) {
                bounds = list.getCellBounds(--bestIndex, bestIndex);
            }
            return bestIndex;
        }

        private void selectNewItem(@NotNull JList<T> list, int index, @NotNull JList<T> prevList) {
            if (list == null) {
                MyKeyListener.$$$reportNull$$$0(14);
            }
            if (prevList == null) {
                MyKeyListener.$$$reportNull$$$0(15);
            }
            prevList.clearSelection();
            list.setSelectedIndex(index);
            TreeGrid.this.ensureIndexVisible(list, index);
            list.requestFocus();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bounds1";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bounds2";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prevList";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/adtui/treegrid/TreeGrid$MyKeyListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "keyPressed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleKeyDown";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleKeyUp";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleKeyRight";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleKeyLeft";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "midX";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isFirstRow";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isLastRow";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "verticalOverlap";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findPrevListEnd";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findNextListStart";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findBestMatchFromLeft";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findBestMatchFromRight";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectNewItem";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

