/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.flamegraph;

import com.android.tools.adtui.chart.hchart.HRenderer;
import com.android.tools.adtui.flamegraph.SampledMethodUsage;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.geom.Rectangle2D;
import java.util.regex.Pattern;

public class SampledMethodUsageHRenderer
extends HRenderer<SampledMethodUsage> {
    private static final Color END_COLOR = new JBColor(new Color(0xFF9F00), new Color(0xFF9F00));
    private static final Color START_COLOR = new JBColor(new Color(15780661), new Color(15780661));
    private static final Pattern dotPattern = Pattern.compile("\\.");
    private final int mRedDelta = END_COLOR.getRed() - START_COLOR.getRed();
    private final int mGreenDelta = END_COLOR.getGreen() - START_COLOR.getGreen();
    private final int mBlueDelta = END_COLOR.getBlue() - START_COLOR.getBlue();

    @Override
    protected Color getBordColor(SampledMethodUsage method) {
        return Color.GRAY;
    }

    @Override
    protected Color getFillColor(SampledMethodUsage method) {
        return new Color((int)((float)START_COLOR.getRed() + method.getPercentage() * (float)this.mRedDelta), (int)((float)START_COLOR.getGreen() + method.getPercentage() * (float)this.mGreenDelta), (int)((float)START_COLOR.getBlue() + method.getPercentage() * (float)this.mBlueDelta));
    }

    @Override
    protected String generateFittingText(SampledMethodUsage method, Rectangle2D rect, FontMetrics fontMetrics) {
        if (rect.getWidth() < (double)fontMetrics.stringWidth("...")) {
            return "";
        }
        String fullyQualified = method.getNameSpace() + "." + method.getName();
        if ((double)fontMetrics.stringWidth(fullyQualified) < rect.getWidth()) {
            return fullyQualified;
        }
        String abbrevPackage = this.getShortPackageName(method.getNameSpace()) + "." + method.getName();
        if ((double)fontMetrics.stringWidth(abbrevPackage) < rect.getWidth()) {
            return abbrevPackage;
        }
        if ((double)fontMetrics.stringWidth(method.getName()) < rect.getWidth()) {
            return method.getName();
        }
        return "";
    }

    private String getShortPackageName(String nameSpace) {
        StringBuilder b = new StringBuilder();
        String[] elements = dotPattern.split(nameSpace);
        String separator = "";
        for (int i = 0; i < elements.length; ++i) {
            b.append(separator);
            b.append(elements[i].charAt(0));
            separator = ".";
        }
        return b.toString();
    }
}

