/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.common;

import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBFont;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class AdtUiUtils {
    public static final JBFont DEFAULT_FONT = JBFont.create((Font)new Font(null, 0, 10));
    public static final Color DEFAULT_FONT_COLOR = JBColor.foreground();
    public static final Color DEFAULT_BACKGROUND_COLOR = JBColor.background();
    public static final Color DEFAULT_BORDER_COLOR = new JBColor((Color)Gray._96, (Color)Gray._192);
    public static final Color GRID_COLOR = new JBColor((Color)Gray._192, (Color)Gray._96);
    public static final GridBagConstraints GBC_FULL = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 256, 1, new Insets(0, 0, 0, 0), 0, 0);

    private AdtUiUtils() {
    }

    public static String getFittedString(FontMetrics metrics, String text, float availableSpace, int characterToShrink) {
        int textWidth = metrics.stringWidth(text);
        int ellipsysWidth = metrics.stringWidth("...");
        if ((float)textWidth <= availableSpace) {
            return text;
        }
        if (availableSpace < (float)ellipsysWidth) {
            return "";
        }
        while ((float)textWidth > availableSpace) {
            text = text.substring(0, Math.max(0, text.length() - characterToShrink));
            textWidth = metrics.stringWidth(text) + ellipsysWidth;
        }
        return text + "...";
    }

    public static Icon buildStaticImage(Color color, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 6);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                image.setRGB(x, y, color.getRGB());
            }
        }
        return new ImageIcon(image);
    }
}

