/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.hchart;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.chart.hchart.HRenderer;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.HNode;
import com.android.tools.adtui.model.Range;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HTreeChart<T>
extends AnimatedComponent
implements MouseWheelListener,
MouseListener {
    private static final String NO_HTREE = "No data available.";
    private static final String NO_RANGE = "X range width is zero: Please use a wider range.";
    private static final int BORDER_PLUS_PADDING = 2;
    private static final int ZOOM_FACTOR = 20;
    private static final String ACTION_ZOOM_IN = "zoom in";
    private static final String ACTION_ZOOM_OUT = "zoom out";
    private static final String ACTION_MOVE_LEFT = "move left";
    private static final String ACTION_MOVE_RIGHT = "move right";
    private static final int ACTION_MOVEMENT_FACTOR = 5;
    private Orientation mOrientation;
    @Nullable
    private HRenderer<T> mHRenderer;
    @Nullable
    private HNode<T> mRoot = new HNode();
    @Nullable
    private Range mXRange;
    @NotNull
    private Range mYRange;
    @NotNull
    private Rectangle2D.Float mRect = new Rectangle2D.Float();

    public HTreeChart() {
        this.mYRange = new Range(0.0, 0.0);
        this.addMouseWheelListener(this);
        this.mOrientation = Orientation.TOP_DOWN;
        this.setFocusable(true);
        this.addMouseListener(this);
    }

    public HTreeChart(Orientation orientation) {
        this();
        this.mOrientation = orientation;
    }

    @Override
    protected void updateData() {
    }

    @Override
    protected void draw(Graphics2D g, Dimension dim) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.mRoot == null || this.mRoot.getChildren().size() == 0) {
            g.drawString(NO_HTREE, dim.width / 2 - this.mDefaultFontMetrics.stringWidth(NO_HTREE), dim.height / 2);
            return;
        }
        if (this.mXRange == null || this.mXRange.getLength() == 0.0) {
            g.drawString(NO_RANGE, dim.width / 2 - this.mDefaultFontMetrics.stringWidth(NO_RANGE), dim.height / 2);
            return;
        }
        Stack stack = new Stack();
        stack.addAll(this.mRoot.getChildren());
        while (!stack.isEmpty()) {
            HNode n = (HNode)stack.pop();
            this.renderHNode(g, n);
            stack.addAll(n.getChildren());
        }
    }

    private void renderHNode(Graphics2D g, HNode<T> n) {
        double rightEdge;
        if ((double)n.getStart() > this.getXRange().getMax() || (double)n.getEnd() < this.getXRange().getMin()) {
            return;
        }
        double leftEdge = this.rangeToPosition(n.getStart());
        if (leftEdge < 0.0) {
            leftEdge = 0.0;
        }
        if ((rightEdge = this.rangeToPosition(n.getEnd())) > (double)this.getWidth()) {
            rightEdge = this.getWidth();
        }
        double width = rightEdge - leftEdge;
        this.mRect.x = (float)leftEdge;
        this.mRect.y = (float)((double)((this.mDefaultFontMetrics.getHeight() + 2) * n.getDepth()) - this.getYRange().getMin());
        this.mRect.width = (float)width - 2.0f;
        this.mRect.height = this.mDefaultFontMetrics.getHeight();
        if (this.mOrientation == Orientation.BOTTOM_UP) {
            this.mRect.y = (float)((double)((float)this.getHeight() - this.mRect.y) - this.mRect.getHeight());
        }
        this.mHRenderer.render(g, n.getData(), this.mRect);
    }

    private double rangeToPosition(double v) {
        double translate = -this.getXRange().getMin();
        double scale = (double)this.getWidth() / (this.getXRange().getMax() - this.getXRange().getMin());
        return (v + translate) * scale;
    }

    private double positionToRange(double x) {
        return x / (double)this.getWidth() * this.getXRange().getLength() + this.getXRange().getMin();
    }

    public void setHRenderer(HRenderer<T> r) {
        this.mHRenderer = r;
        this.mHRenderer.setFont((Font)AdtUiUtils.DEFAULT_FONT);
    }

    public void setHTree(@Nullable HNode<T> root) {
        this.mRoot = root;
    }

    public Range getXRange() {
        return this.mXRange;
    }

    public void setXRange(Range XRange) {
        this.mXRange = XRange;
        this.getInputMap().put(KeyStroke.getKeyStroke(38, 0), ACTION_ZOOM_IN);
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 0), ACTION_ZOOM_OUT);
        this.getInputMap().put(KeyStroke.getKeyStroke(37, 0), ACTION_MOVE_LEFT);
        this.getInputMap().put(KeyStroke.getKeyStroke(39, 0), ACTION_MOVE_RIGHT);
        this.getActionMap().put(ACTION_ZOOM_IN, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double delta = HTreeChart.this.mXRange.getLength() / 5.0;
                HTreeChart.this.mXRange.set(HTreeChart.this.mXRange.getMin() + delta, HTreeChart.this.mXRange.getMax() - delta);
            }
        });
        this.getActionMap().put(ACTION_ZOOM_OUT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double delta = HTreeChart.this.mXRange.getLength() / 5.0;
                HTreeChart.this.mXRange.set(HTreeChart.this.mXRange.getMin() - delta, HTreeChart.this.mXRange.getMax() + delta);
            }
        });
        this.getActionMap().put(ACTION_MOVE_LEFT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double delta = HTreeChart.this.mXRange.getLength() / 5.0;
                HTreeChart.this.mXRange.set(HTreeChart.this.mXRange.getMin() - delta, HTreeChart.this.mXRange.getMax() - delta);
            }
        });
        this.getActionMap().put(ACTION_MOVE_RIGHT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double delta = HTreeChart.this.mXRange.getLength() / 5.0;
                HTreeChart.this.mXRange.set(HTreeChart.this.mXRange.getMin() + delta, HTreeChart.this.mXRange.getMax() + delta);
            }
        });
    }

    public Range getYRange() {
        return this.mYRange;
    }

    public int getMaximumHeight() {
        if (this.mRoot == null) {
            return 0;
        }
        int maxDepth = -1;
        Stack stack = new Stack();
        stack.addAll(this.mRoot.getChildren());
        while (!stack.isEmpty()) {
            HNode n = (HNode)stack.pop();
            if (n.getDepth() > maxDepth) {
                maxDepth = n.getDepth();
            }
            stack.addAll(n.getChildren());
        }
        return (this.mDefaultFontMetrics.getHeight() + 2) * ++maxDepth;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        double cursorRange = this.positionToRange(e.getX());
        double leftDelta = (cursorRange - this.getXRange().getMin()) / 20.0 * (double)e.getWheelRotation();
        double rightDelta = (this.getXRange().getMax() - cursorRange) / 20.0 * (double)e.getWheelRotation();
        this.getXRange().setMin(this.getXRange().getMin() - leftDelta);
        this.getXRange().setMax(this.getXRange().getMax() + rightDelta);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.hasFocus()) {
            this.requestFocusInWindow();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public static enum Orientation {
        TOP_DOWN,
        BOTTOM_UP;

    }
}

