/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.datareducer.StateChartReducer;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.intellij.util.containers.ImmutableList;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class StateChart<E extends Enum<E>>
extends AnimatedComponent {
    private static final int TEXT_PADDING = 3;
    @NotNull
    private final List<RangedSeries<E>> mSeriesList;
    @NotNull
    private final Map<E, Color> mColors;
    private float mArcWidth;
    private float mArcHeight;
    private float mHeightGap;
    @NotNull
    private final ArrayList<RoundRectangle2D.Float> mRectangles;
    @NotNull
    private final List<E> mValues;
    @NotNull
    private RenderMode mRenderMode;
    @NotNull
    private StateChartReducer<E> myReducer;

    public StateChart(@NotNull Map<E, Color> colors) {
        if (colors == null) {
            StateChart.$$$reportNull$$$0(0);
        }
        this(colors, (rectangles, values) -> {});
    }

    public StateChart(@NotNull Map<E, Color> colors, @NotNull StateChartReducer<E> reducer) {
        if (colors == null) {
            StateChart.$$$reportNull$$$0(1);
        }
        if (reducer == null) {
            StateChart.$$$reportNull$$$0(2);
        }
        this.mColors = colors;
        this.mRectangles = new ArrayList();
        this.mValues = new ArrayList();
        this.mSeriesList = new ArrayList<RangedSeries<E>>();
        this.mRenderMode = RenderMode.BAR;
        this.myReducer = reducer;
        this.setFont((Font)AdtUiUtils.DEFAULT_FONT);
    }

    public void setRenderMode(RenderMode mode) {
        this.mRenderMode = mode;
    }

    public void addSeries(@NotNull RangedSeries<E> series) {
        if (series == null) {
            StateChart.$$$reportNull$$$0(3);
        }
        this.mSeriesList.add(series);
    }

    public void setArcWidth(float arcWidth) {
        this.mArcWidth = arcWidth;
    }

    public void setArcHeight(float arcHeight) {
        this.mArcHeight = arcHeight;
    }

    public void setHeightGap(float gap) {
        this.mHeightGap = gap;
    }

    @Override
    protected void updateData() {
        int seriesSize = this.mSeriesList.size();
        if (seriesSize == 0) {
            return;
        }
        float height = 1.0f / (float)seriesSize;
        float gap = height * this.mHeightGap;
        this.mValues.clear();
        int seriesIndex = 0;
        int rectCount = 0;
        for (RangedSeries<E> data : this.mSeriesList) {
            double min = data.getXRange().getMin();
            double max = data.getXRange().getMax();
            ImmutableList<SeriesData<E>> seriesDataList = data.getSeries();
            int size = seriesDataList.size();
            long previousX = -1L;
            Enum previousValue = null;
            for (int i = 0; i < size; ++i) {
                SeriesData seriesData = (SeriesData)seriesDataList.get(i);
                long x = seriesData.x;
                Enum value = (Enum)seriesData.value;
                float startHeight = 1.0f - height * (float)(seriesIndex + 1);
                if (i > 0 && (double)x >= min) {
                    this.setRectangleAndValueData(rectCount, Math.max(min, (double)previousX), Math.min(max, (double)x), min, max, previousValue, startHeight + gap * 0.5f, height - gap);
                    ++rectCount;
                }
                previousValue = value;
                previousX = x;
                if ((double)x >= max) break;
                if (i != size - 1) continue;
                this.setRectangleAndValueData(rectCount, Math.max(min, (double)previousX), max, min, max, previousValue, startHeight + gap * 0.5f, height - gap);
                ++rectCount;
            }
            ++seriesIndex;
        }
        if (rectCount < this.mRectangles.size()) {
            this.mRectangles.subList(rectCount, this.mRectangles.size()).clear();
        }
    }

    @Override
    protected void draw(Graphics2D g2d, Dimension dim) {
        int i;
        g2d.setFont(this.getFont());
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        assert (this.mRectangles.size() == this.mValues.size());
        ArrayList<Shape> transformedShapes = new ArrayList<Shape>(this.mRectangles.size());
        ArrayList<E> transformedValues = new ArrayList<E>(this.mRectangles.size());
        AffineTransform scale = AffineTransform.getScaleInstance(dim.getWidth(), dim.getHeight());
        for (i = 0; i < this.mRectangles.size(); ++i) {
            transformedShapes.add(scale.createTransformedShape(this.mRectangles.get(i)));
            transformedValues.add(this.mValues.get(i));
        }
        this.myReducer.reduce(transformedShapes, transformedValues);
        assert (transformedShapes.size() == transformedValues.size());
        block5: for (i = 0; i < transformedShapes.size(); ++i) {
            Shape shape = (Shape)transformedShapes.get(i);
            Enum value = (Enum)transformedValues.get(i);
            g2d.setColor(this.mColors.get(value));
            switch (this.mRenderMode) {
                case BAR: {
                    g2d.fill(shape);
                    continue block5;
                }
                case TEXT: {
                    Rectangle2D rect = shape.getBounds2D();
                    g2d.draw(new Line2D.Double(rect.getX(), rect.getY(), rect.getX(), rect.getY() + rect.getHeight()));
                    String text = AdtUiUtils.getFittedString(this.mDefaultFontMetrics, value.toString(), (float)rect.getWidth() - 6.0f, 1);
                    if (text.isEmpty()) continue block5;
                    g2d.setColor(AdtUiUtils.DEFAULT_FONT_COLOR);
                    g2d.drawString(text, (float)(rect.getX() + 3.0), (float)(rect.getY() + rect.getHeight() - 3.0));
                }
            }
        }
        this.addDebugInfo("# of drawn rects: %d", transformedShapes.size());
    }

    private void setRectangleAndValueData(int rectCount, double previousX, double currentX, double minX, double maxX, E previousValue, float rectY, float rectHeight) {
        RoundRectangle2D.Float rect;
        if (rectCount == this.mRectangles.size()) {
            rect = new RoundRectangle2D.Float();
            this.mRectangles.add(rect);
        } else {
            rect = this.mRectangles.get(rectCount);
        }
        this.mValues.add(previousValue);
        rect.setRoundRect((previousX - minX) / (maxX - minX), (double)rectY, (currentX - previousX) / (maxX - minX), (double)rectHeight, (double)this.mArcWidth, (double)this.mArcHeight);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colors";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reducer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "series";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/adtui/chart/StateChart";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addSeries";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum RenderMode {
        BAR,
        TEXT;

    }
}

