/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.SimpleEventRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public class TouchEventRenderer
implements SimpleEventRenderer {
    private static final Color HOLD_COLOR = new Color(214, 196, 228);
    private static final Color TOUCH_COLOR = new Color(156, 110, 189);
    private static final int MIN_LENGTH = 20;
    private int myLineWidth = 12;

    @Override
    public void draw(Component parent, Graphics2D g2d, AffineTransform transform, double length) {
        Color currentColor = g2d.getColor();
        Stroke currentStroke = g2d.getStroke();
        int xPosition = (int)(transform.getTranslateX() - (double)this.myLineWidth / 2.0);
        int yPosition = (int)(transform.getTranslateY() + (double)this.myLineWidth / 2.0);
        if (length >= 20.0) {
            BasicStroke str = new BasicStroke(this.myLineWidth);
            g2d.setStroke(str);
            g2d.setColor(HOLD_COLOR);
            g2d.fillRoundRect(xPosition, yPosition, (int)length, this.myLineWidth, this.myLineWidth, this.myLineWidth);
            g2d.setStroke(currentStroke);
        }
        g2d.setColor(TOUCH_COLOR);
        g2d.fillOval(xPosition, yPosition, this.myLineWidth, this.myLineWidth);
        g2d.setColor(currentColor);
    }
}

