/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.SelectionListener;
import com.android.tools.adtui.model.Range;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import org.jetbrains.annotations.NotNull;

public final class SelectionComponent
extends AnimatedComponent {
    public static final Color DEFAULT_SELECTION_COLOR = new JBColor(new Color(-2133990152, true), new Color(-2133990152, true));
    public static final Color DEFAULT_SELECTION_BORDER = new JBColor(9553135, 9553135);
    private static final Color DEFAULT_HANDLE = new JBColor(0x696868, 0x696868);
    public static final int HANDLE_HEIGHT = 40;
    public static final int HANDLE_WIDTH = 5;
    private final List<SelectionListener> myListeners;
    private int myMousePressed;
    private float myStartX;
    private float myEndX;
    private boolean myEmpty;
    private Mode myMode;
    @NotNull
    private final Range mySelectionRange;
    @NotNull
    private final Range myRange;

    public SelectionComponent(@NotNull Range selectionRange, @NotNull Range globalRange) {
        if (selectionRange == null) {
            SelectionComponent.$$$reportNull$$$0(0);
        }
        if (globalRange == null) {
            SelectionComponent.$$$reportNull$$$0(1);
        }
        this.myListeners = new ArrayList<SelectionListener>();
        this.myRange = globalRange;
        this.mySelectionRange = selectionRange;
        this.myMode = Mode.NONE;
        this.setFocusable(true);
        this.initListeners();
    }

    public void addChangeListener(SelectionListener listener) {
        this.myListeners.add(listener);
    }

    private void fireSelectionEvent() {
        ChangeEvent e = new ChangeEvent(this);
        this.myListeners.forEach(l -> l.selectionStateChanged(e));
    }

    private void initListeners() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SelectionComponent.this.requestFocusInWindow();
                Dimension size = SelectionComponent.this.getSize();
                int x = e.getX();
                double start = size.getWidth() * (double)SelectionComponent.this.myStartX;
                double end = size.getWidth() * (double)SelectionComponent.this.myEndX;
                if (start - 5.0 < (double)x && (double)x < start) {
                    SelectionComponent.this.myMode = Mode.ADJUST_MIN;
                } else if (end < (double)x && (double)x < end + 5.0) {
                    SelectionComponent.this.myMode = Mode.ADJUST_MAX;
                } else if (start <= (double)x && (double)x <= end) {
                    SelectionComponent.this.myMode = Mode.MOVE;
                } else {
                    double value = SelectionComponent.this.xToRange(x);
                    SelectionComponent.this.mySelectionRange.setMin(value);
                    SelectionComponent.this.mySelectionRange.setMax(value);
                    SelectionComponent.this.myMode = Mode.CREATE;
                }
                SelectionComponent.this.myMousePressed = e.getX();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SelectionComponent.this.myMode == Mode.CREATE) {
                    SelectionComponent.this.fireSelectionEvent();
                }
                SelectionComponent.this.myMode = Mode.NONE;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                double pressed = SelectionComponent.this.xToRange(SelectionComponent.this.myMousePressed);
                double current = SelectionComponent.this.xToRange(e.getX());
                switch (SelectionComponent.this.myMode) {
                    case ADJUST_MIN: {
                        if (current > SelectionComponent.this.mySelectionRange.getMax()) {
                            SelectionComponent.this.mySelectionRange.setMax(current);
                            SelectionComponent.this.myMode = Mode.ADJUST_MAX;
                        }
                        SelectionComponent.this.mySelectionRange.setMin(current);
                        SelectionComponent.this.myMousePressed = e.getX();
                        break;
                    }
                    case ADJUST_MAX: {
                        if (current < SelectionComponent.this.mySelectionRange.getMin()) {
                            SelectionComponent.this.mySelectionRange.setMin(current);
                            SelectionComponent.this.myMode = Mode.ADJUST_MIN;
                        }
                        SelectionComponent.this.mySelectionRange.setMax(current);
                        SelectionComponent.this.myMousePressed = e.getX();
                        break;
                    }
                    case MOVE: {
                        double rangeDelta = current - pressed;
                        SelectionComponent.this.mySelectionRange.setMax(SelectionComponent.this.mySelectionRange.getMax() + rangeDelta);
                        SelectionComponent.this.mySelectionRange.setMin(SelectionComponent.this.mySelectionRange.getMin() + rangeDelta);
                        SelectionComponent.this.myMousePressed = e.getX();
                        break;
                    }
                    case CREATE: {
                        SelectionComponent.this.mySelectionRange.setMin(pressed < current ? pressed : current);
                        SelectionComponent.this.mySelectionRange.setMax(pressed < current ? current : pressed);
                        break;
                    }
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getExtendedKeyCode() == 27 && !SelectionComponent.this.mySelectionRange.isEmpty()) {
                    SelectionComponent.this.mySelectionRange.clear();
                    e.consume();
                    SelectionComponent.this.fireSelectionEvent();
                }
            }
        });
    }

    private double xToRange(int x) {
        return (double)x / this.getSize().getWidth() * this.myRange.getLength() + this.myRange.getMin();
    }

    @Override
    protected void updateData() {
        this.myEmpty = this.mySelectionRange.isEmpty();
        this.myStartX = (float)((this.mySelectionRange.getMin() - this.myRange.getMin()) / (this.myRange.getMax() - this.myRange.getMin()));
        this.myEndX = (float)((this.mySelectionRange.getMax() - this.myRange.getMin()) / (this.myRange.getMax() - this.myRange.getMin()));
    }

    @Override
    protected void draw(Graphics2D g, Dimension dim) {
        if (this.myEmpty) {
            return;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float startXPos = (float)((double)this.myStartX * dim.getWidth());
        float endXPos = (float)((double)this.myEndX * dim.getWidth());
        g.setColor(DEFAULT_SELECTION_COLOR);
        Rectangle2D.Float rect = new Rectangle2D.Float(startXPos, 0.0f, endXPos - startXPos, dim.height);
        g.fill(rect);
        g.setColor(DEFAULT_SELECTION_BORDER);
        Path2D.Float path = new Path2D.Float();
        path.moveTo(startXPos, 0.0f);
        path.lineTo(startXPos, dim.height);
        path.moveTo(endXPos, dim.height);
        path.lineTo(endXPos, 0.0f);
        g.draw(path);
        if (this.myMode != Mode.CREATE) {
            this.drawHandle(g, startXPos, dim.height, 1.0f);
            this.drawHandle(g, endXPos, dim.height, -1.0f);
        }
    }

    private void drawHandle(Graphics2D g, float x, float height, float direction) {
        float up = (height - 40.0f) * 0.5f;
        float down = (height + 40.0f) * 0.5f;
        float width = 5.0f * direction;
        g.setColor(DEFAULT_HANDLE);
        Path2D.Float path = new Path2D.Float();
        path.moveTo(x, up);
        path.lineTo(x, down);
        path.quadTo(x - width, down, x - width, down - 5.0f);
        path.lineTo(x - width, up + 5.0f);
        path.quadTo(x - width, up, x, up);
        g.fill(path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "selectionRange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "globalRange";
                break;
            }
        }
        objectArray[1] = "com/android/tools/adtui/SelectionComponent";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum Mode {
        NONE,
        CREATE,
        MOVE,
        ADJUST_MIN,
        ADJUST_MAX;

    }
}

