/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.LegendRenderData;
import com.android.tools.adtui.common.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.SeriesData;
import com.intellij.util.containers.ImmutableList;
import java.awt.Color;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class LineChartLegendRenderData
extends LegendRenderData {
    @NotNull
    private final Range myRange;
    @NotNull
    private final RangedContinuousSeries mySeries;
    @NotNull
    private final BaseAxisFormatter myFormatter;

    public LineChartLegendRenderData(@NotNull LegendRenderData.IconType icon, @NotNull Color color, @NotNull Range range, @NotNull RangedContinuousSeries series, @NotNull BaseAxisFormatter formatter) {
        if (icon == null) {
            LineChartLegendRenderData.$$$reportNull$$$0(0);
        }
        if (color == null) {
            LineChartLegendRenderData.$$$reportNull$$$0(1);
        }
        if (range == null) {
            LineChartLegendRenderData.$$$reportNull$$$0(2);
        }
        if (series == null) {
            LineChartLegendRenderData.$$$reportNull$$$0(3);
        }
        if (formatter == null) {
            LineChartLegendRenderData.$$$reportNull$$$0(4);
        }
        super(icon, color, series.getLabel());
        this.myRange = range;
        this.mySeries = series;
        this.myFormatter = formatter;
    }

    @Override
    public boolean hasData() {
        return true;
    }

    @Override
    public String getFormattedData() {
        double time = this.myRange.getMax();
        ImmutableList data = this.mySeries.getDataSeries().getDataForXRange(new Range(time, time));
        if (data.isEmpty()) {
            return null;
        }
        SeriesData<Long> key = new SeriesData<Long>(TimeUnit.MICROSECONDS.toNanos((long)time), 0L);
        int index = Collections.binarySearch(data, key, (left, right) -> {
            long diff = left.x - right.x;
            return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
        });
        index = index >= 0 ? index : -(index + 1);
        index = Math.max(0, Math.min(data.size() - 1, index));
        return this.myFormatter.getFormattedString(this.mySeries.getYRange().getLength(), ((Long)((SeriesData)data.get((int)index)).value).longValue(), true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "icon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "color";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "range";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "series";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "formatter";
                break;
            }
        }
        objectArray[1] = "com/android/tools/adtui/LineChartLegendRenderData";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

