/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.LegendRenderData;
import com.android.tools.adtui.common.AdtUiUtils;
import com.intellij.ui.components.JBLabel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;

public class LegendComponent
extends AnimatedComponent {
    private static final BasicStroke LINE_STROKE = new BasicStroke(3.0f);
    private static final BasicStroke BORDER_STROKE = new BasicStroke(1.0f);
    private static final int ICON_WIDTH_PX = 10;
    private static final int ICON_MARGIN_PX = 5;
    private static final int LEGEND_VERTICAL_PADDING_PX = 5;
    private int LEGEND_MARGIN_PX = 10;
    private static final int LABEL_MIN_WIDTH_PX = 100;
    private int mFrequencyMillis;
    private List<JLabel> mLabelsToDraw;
    private long mLastUpdate;
    private List<LegendRenderData> mLegendRenderData;
    private Orientation mOrientation;

    public LegendComponent(Orientation orientation, int frequencyMillis) {
        this.mFrequencyMillis = frequencyMillis;
        this.mOrientation = orientation;
        this.mLastUpdate = 0L;
    }

    public void setLegendData(List<LegendRenderData> data) {
        this.mLegendRenderData = new ArrayList<LegendRenderData>(data);
        this.mLabelsToDraw = new ArrayList<JLabel>(this.mLegendRenderData.size());
        for (LegendRenderData initialData : this.mLegendRenderData) {
            JBLabel label = new JBLabel();
            label.setFont((Font)AdtUiUtils.DEFAULT_FONT);
            this.mLabelsToDraw.add((JLabel)label);
        }
    }

    @Override
    protected void updateData() {
        long now = System.currentTimeMillis();
        if (now - this.mLastUpdate > (long)this.mFrequencyMillis) {
            this.mLastUpdate = now;
            for (int i = 0; i < this.mLegendRenderData.size(); ++i) {
                LegendRenderData data = this.mLegendRenderData.get(i);
                JLabel label = this.mLabelsToDraw.get(i);
                if (data.hasData()) {
                    label.setText(String.format("%s: %s", data.getLabel(), data.getFormattedData()));
                } else {
                    label.setText(data.getLabel());
                }
                Dimension preferredSize = label.getPreferredSize();
                if (preferredSize.getWidth() < 100.0) {
                    preferredSize.width = 100;
                    label.setPreferredSize(preferredSize);
                }
                label.setBounds(0, 0, preferredSize.width, preferredSize.height);
            }
            Dimension newSize = this.getLegendPreferredSize();
            if (newSize != this.getPreferredSize()) {
                this.setPreferredSize(newSize);
                this.setMinimumSize(new Dimension(this.getMinimumSize().width, newSize.height));
                this.revalidate();
            }
        }
    }

    @Override
    protected void draw(Graphics2D g2d, Dimension dim) {
        Stroke defaultStroke = g2d.getStroke();
        for (int i = 0; i < this.mLegendRenderData.size(); ++i) {
            LegendRenderData data = this.mLegendRenderData.get(i);
            JLabel label = this.mLabelsToDraw.get(i);
            Dimension labelPreferredSize = label.getPreferredSize();
            int xOffset = 0;
            if (data.getIcon() == LegendRenderData.IconType.BOX) {
                int boxY = 5 + (labelPreferredSize.height - 10) / 2;
                Color fillColor = data.getColor();
                g2d.setColor(fillColor);
                g2d.fillRect(0, boxY, 10, 10);
                int r = (int)((float)fillColor.getRed() * 0.8f);
                int g = (int)((float)fillColor.getGreen() * 0.8f);
                int b = (int)((float)fillColor.getBlue() * 0.8f);
                Color borderColor = new Color(r, g, b);
                g2d.setColor(borderColor);
                g2d.setStroke(BORDER_STROKE);
                g2d.drawRect(0, boxY, 10, 10);
                g2d.setStroke(defaultStroke);
                xOffset = 15;
            } else if (data.getIcon() == LegendRenderData.IconType.LINE) {
                g2d.setColor(data.getColor());
                g2d.setStroke(LINE_STROKE);
                int lineY = 5 + labelPreferredSize.height / 2;
                g2d.drawLine(xOffset, lineY, 10, lineY);
                g2d.setStroke(defaultStroke);
                xOffset = 15;
            }
            g2d.translate(xOffset, 5);
            label.paint(g2d);
            if (this.mOrientation == Orientation.HORIZONTAL) {
                g2d.translate(labelPreferredSize.width + this.LEGEND_MARGIN_PX, -5);
                continue;
            }
            if (this.mOrientation != Orientation.VERTICAL) continue;
            g2d.translate(-xOffset, labelPreferredSize.height + 5);
        }
    }

    private Dimension getLegendPreferredSize() {
        int totalWidth = 0;
        int totalHeight = 0;
        int iconPaddedSize = 15 + this.LEGEND_MARGIN_PX;
        for (JLabel label : this.mLabelsToDraw) {
            Dimension size = label.getPreferredSize();
            if (this.mOrientation == Orientation.HORIZONTAL) {
                totalWidth += iconPaddedSize + size.width;
                if (totalHeight >= size.height) continue;
                totalHeight = size.height;
                continue;
            }
            if (this.mOrientation != Orientation.VERTICAL) continue;
            totalHeight += iconPaddedSize;
            if (totalWidth >= size.width + iconPaddedSize) continue;
            totalWidth = size.width + iconPaddedSize;
        }
        int heightPadding = 10;
        if (this.mOrientation == Orientation.VERTICAL) {
            heightPadding *= this.mLabelsToDraw.size();
        }
        return new Dimension(totalWidth, totalHeight + heightPadding);
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

