/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.common.AdtUiUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class AnimatedComponent
extends JComponent
implements Animatable {
    protected static final float DEFAULT_LERP_FRACTION = 0.99f;
    protected static final float DEFAULT_LERP_THRESHOLD_PERCENTAGE = 0.001f;
    protected float mFrameLength;
    protected long mLastRenderTime;
    protected long mUpdateStartTime;
    protected long mUpdateEndTime;
    protected boolean mDrawDebugInfo;
    protected final FontMetrics mDefaultFontMetrics;
    @NotNull
    private final List<String> mDebugInfo = new LinkedList<String>();
    private int mDrawCount;
    private int mMultiDrawNumFrames;

    public AnimatedComponent() {
        this.mDefaultFontMetrics = this.getFontMetrics((Font)AdtUiUtils.DEFAULT_FONT);
    }

    public final boolean isDrawDebugInfo() {
        return this.mDrawDebugInfo;
    }

    public final void setDrawDebugInfo(boolean drawDebugInfo) {
        this.mDrawDebugInfo = drawDebugInfo;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.mLastRenderTime = System.nanoTime();
        Graphics2D g2d = (Graphics2D)g.create();
        this.draw(g2d, this.getSize());
        ++this.mDrawCount;
        if (this.mDrawDebugInfo) {
            this.doDebugDraw(g2d);
        }
        g2d.dispose();
    }

    protected final void addDebugInfo(String format, Object ... values) {
        if (this.mDrawDebugInfo) {
            this.mDebugInfo.add(String.format(format, values));
        }
    }

    private void doDebugDraw(Graphics2D g) {
        this.debugDraw(g);
        this.addDebugInfo("Multi-draw Frame Count: %d", this.mMultiDrawNumFrames);
        this.addDebugInfo("Draw Count: %d", this.mDrawCount);
        this.addDebugInfo("Update time: %.2fms", Float.valueOf((float)(this.mUpdateEndTime - this.mUpdateStartTime) / 1000000.0f));
        this.addDebugInfo("Render time: %.2fms", Float.valueOf((float)(System.nanoTime() - this.mLastRenderTime) / 1000000.0f));
        this.addDebugInfo("FPS: %.2f", Float.valueOf(1.0f / this.mFrameLength));
        g.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        g.setColor(AdtUiUtils.DEFAULT_FONT_COLOR);
        int i = 0;
        for (String s : this.mDebugInfo) {
            g.drawString(s, this.getSize().width - 150, this.getSize().height - 10 * i++ - 5);
        }
        this.mDebugInfo.clear();
    }

    protected abstract void updateData();

    protected abstract void draw(Graphics2D var1, Dimension var2);

    protected void debugDraw(Graphics2D g) {
    }

    protected static void drawArrow(Graphics2D g, float x, float y, float dx, float dy, float len, Color color) {
        Path2D.Float path = new Path2D.Float();
        path.moveTo(x, y);
        path.lineTo(x + dx * len, y + dy * len);
        path.lineTo(x + dx * (len - 10.0f) + dy * 10.0f, y + dy * (len - 10.0f) - dx * 10.0f);
        path.lineTo(x + dx * (len - 10.0f) - dy * 10.0f, y + dy * (len - 10.0f) + dx * 10.0f);
        g.setColor(color);
        g.draw(path);
    }

    protected static void drawMarker(Graphics2D g, float x, float y, Color color) {
        Path2D.Float path = new Path2D.Float();
        path.moveTo(x - 10.0f, y);
        path.lineTo(x + 10.0f, y);
        path.moveTo(x, y - 10.0f);
        path.lineTo(x, y + 10.0f);
        g.setColor(color);
        g.draw(path);
    }

    @Override
    public void animate(float frameLength) {
        if (this.mDrawCount > 1) {
            ++this.mMultiDrawNumFrames;
        }
        this.mDrawCount = 0;
        this.mFrameLength = frameLength;
        this.mUpdateStartTime = System.nanoTime();
        this.updateData();
        this.mUpdateEndTime = System.nanoTime();
    }

    @Override
    public void reset() {
        this.mMultiDrawNumFrames = 0;
    }
}

