/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm.bytecode;

import com.intellij.zkm.bytecode.Named;
import com.intellij.zkm.bytecode.Signature;
import com.intellij.zkm.bytecode.Type;
import com.intellij.zkm.bytecode.Utilities;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class Invocation {
    private final Type myOwnerType;
    private final Type myReturnType;
    private final String myName;
    private final List<Type> myParameterTypes;

    Invocation(@NotNull Type ownerType, @NotNull Type returnType, @NotNull String name, @NotNull List<Type> parameterTypes) {
        if (ownerType == null) {
            Invocation.$$$reportNull$$$0(0);
        }
        if (returnType == null) {
            Invocation.$$$reportNull$$$0(1);
        }
        if (name == null) {
            Invocation.$$$reportNull$$$0(2);
        }
        if (parameterTypes == null) {
            Invocation.$$$reportNull$$$0(3);
        }
        this.myOwnerType = ownerType;
        this.myReturnType = returnType;
        this.myName = name;
        this.myParameterTypes = parameterTypes;
    }

    boolean conforms(String methodName) {
        return this.myName.equals(methodName);
    }

    boolean conforms(Signature signature) {
        return this.myReturnType.conforms(signature.getReturnType()) && this.myName.equals(signature.getName()) && Type.conforms(this.myParameterTypes, signature.getParameterTypes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Invocation that = (Invocation)o;
        if (!this.myOwnerType.equals(that.myOwnerType)) {
            return false;
        }
        if (!this.myReturnType.equals(that.myReturnType)) {
            return false;
        }
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        return this.myParameterTypes.equals(that.myParameterTypes);
    }

    public int hashCode() {
        int result = this.myOwnerType.hashCode();
        result = 31 * result + this.myReturnType.hashCode();
        result = 31 * result + this.myName.hashCode();
        result = 31 * result + this.myParameterTypes.hashCode();
        return result;
    }

    public String toString() {
        return String.format("%s %s.%s(%s)", this.myReturnType, this.myOwnerType, this.myName, Utilities.join(Named.namesOf(this.myParameterTypes)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "ownerType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "returnType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "parameterTypes";
                break;
            }
        }
        objectArray[1] = "com/intellij/zkm/bytecode/Invocation";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

