/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.zkm.ClassInfo;
import com.intellij.zkm.ZKMLog;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class ZKMLogReader {
    private final ArrayList myClasses = new ArrayList();
    private ClassInfo myCurrentClassInfo;
    private static final String CLASS_PREFIX = "Class: ";
    private static final String SOURCE = "Source: ";
    private static final String NAME_NOT_CHANGED = "NameNotChanged";

    private void proceedString(String s) {
        if ((s = s.trim()).startsWith(CLASS_PREFIX)) {
            this.proceedClassLine(s);
        } else if (s.startsWith(SOURCE)) {
            this.proceedSourceLine(s);
        } else if (s.indexOf(40) == -1) {
            this.proceedLinenumbersLine(s);
        }
    }

    private void proceedClassLine(String s) {
        String scrambledName;
        String originalName;
        this.flushCurrentClassInfo();
        s = s.substring(CLASS_PREFIX.length());
        String[] tokens = ZKMLogReader.getTokens(s);
        if (NAME_NOT_CHANGED.equals(tokens[tokens.length - 1])) {
            originalName = this.cutModifiers(tokens[tokens.length - 2]);
            scrambledName = this.cutModifiers(tokens[tokens.length - 2]);
        } else {
            originalName = this.cutModifiers(tokens[tokens.length - 3]);
            scrambledName = this.cutModifiers(tokens[tokens.length - 1]);
        }
        this.myCurrentClassInfo = new ClassInfo(originalName, scrambledName);
    }

    private void proceedSourceLine(String s) {
        if (this.myCurrentClassInfo == null) {
            return;
        }
        s = s.substring(SOURCE.length());
        s = ZKMLogReader.cutQuotes(s);
        this.myCurrentClassInfo.setSourceFile(s);
    }

    private static String cutQuotes(String s) {
        if (StringUtil.startsWithChar((CharSequence)s, (char)'\"') && StringUtil.endsWithChar((CharSequence)s, (char)'\"')) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    private void proceedLinenumbersLine(String s) {
        int originalLineNumber;
        if (this.myCurrentClassInfo == null) {
            return;
        }
        String[] tokens = ZKMLogReader.getTokens(s);
        if (tokens.length != 3) {
            return;
        }
        if (!"=>".equals(tokens[1])) {
            return;
        }
        try {
            originalLineNumber = Integer.parseInt(tokens[0]);
        }
        catch (NumberFormatException e) {
            return;
        }
        String scrambledNumbers = tokens[2];
        scrambledNumbers = StringUtil.replace((String)scrambledNumbers, (String)" and ", (String)",");
        StringTokenizer tokenizer = new StringTokenizer(scrambledNumbers, ",");
        while (tokenizer.hasMoreElements()) {
            String numberString = (String)tokenizer.nextElement();
            try {
                this.myCurrentClassInfo.putLineNumbers(originalLineNumber, Integer.parseInt(numberString));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private String cutModifiers(String s) {
        s = ZKMLogReader.stripPrefix(s, "public ");
        s = ZKMLogReader.stripPrefix(s, "private ");
        s = ZKMLogReader.stripPrefix(s, "protected ");
        s = ZKMLogReader.stripPrefix(s, "static ");
        s = ZKMLogReader.stripPrefix(s, "abstract ");
        s = ZKMLogReader.stripPrefix(s, "final ");
        return s;
    }

    private static String stripPrefix(String s, String prefix) {
        s = StringUtil.trimStart((String)s, (String)prefix);
        return s;
    }

    private void flushCurrentClassInfo() {
        if (this.myCurrentClassInfo != null) {
            this.myClasses.add(this.myCurrentClassInfo);
            this.myCurrentClassInfo = null;
        }
    }

    private static String[] getTokens(String s) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tokeniger = new StringTokenizer(s, "\t");
        while (tokeniger.hasMoreElements()) {
            String token = (String)tokeniger.nextElement();
            tokens.add(token);
        }
        return ArrayUtil.toStringArray(tokens);
    }

    public static ZKMLog readLog(String logFileName) throws IOException {
        ZKMLogReader reader = new ZKMLogReader();
        reader.readLogImpl(logFileName);
        ArrayList classes = reader.myClasses;
        ClassInfo[] infos = classes.toArray(new ClassInfo[classes.size()]);
        return new ZKMLog(infos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readLogImpl(String logFileName) throws IOException {
        File file = new File(logFileName);
        long length = file.length();
        char[] chars = new char[(int)length];
        try (FileReader reader = new FileReader(file);){
            reader.read(chars);
            StringBuffer buffer = new StringBuffer(512);
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (c == '\n') {
                    String s = buffer.toString();
                    this.proceedString(s);
                    buffer.setLength(0);
                    continue;
                }
                if (c == '\r') continue;
                buffer.append(c);
            }
        }
        this.flushCurrentClassInfo();
    }
}

