/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui.servertree;

import com.intellij.openapi.util.Condition;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Item;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.tfs.ServerInfo;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

public class TfsTreeContext {
    public final ServerInfo myServer;
    private final boolean myFoldersOnly;
    private final Object myProjectOrComponent;
    @Nullable
    private final Condition<String> myFilter;

    public TfsTreeContext(ServerInfo server, boolean foldersOnly, Object projectOrComponent, Condition<String> filter) {
        this.myServer = server;
        this.myFoldersOnly = foldersOnly;
        this.myFilter = filter;
        this.myProjectOrComponent = projectOrComponent;
    }

    public boolean isAccepted(String path) {
        return this.myFilter == null || this.myFilter.value((Object)path);
    }

    public List<Item> getChildItems(String path) throws TfsException {
        return this.myServer.getVCS().getChildItems(path, this.myFoldersOnly, this.myProjectOrComponent, TFSBundle.message("loading.items", new Object[0]));
    }
}

