/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui.servertree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.ServerInfo;
import org.jetbrains.tfsIntegration.ui.servertree.TfsTreeForm;

public class ServerBrowserDialog
extends DialogWrapper {
    private final TfsTreeForm myForm = new TfsTreeForm();

    public ServerBrowserDialog(String title, Project project, ServerInfo server, @Nullable String initialPath, boolean foldersOnly, boolean canCreateVirtualFolders) {
        super(project, false);
        this.myForm.initialize(server, initialPath, foldersOnly, canCreateVirtualFolders, null);
        this.myForm.addListener(new TfsTreeForm.SelectionListener(){

            @Override
            public void selectionChanged() {
                ServerBrowserDialog.this.setOKActionEnabled(ServerBrowserDialog.this.myForm.getSelectedItem() != null);
            }
        });
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myForm);
        this.setSize(500, 600);
        this.setTitle(title);
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myForm.getContentPane();
    }

    @Nullable
    public String getSelectedPath() {
        return this.myForm.getSelectedPath();
    }

    @Nullable
    public TfsTreeForm.SelectedItem getSelectedItem() {
        return this.myForm.getSelectedItem();
    }

    protected String getDimensionServiceKey() {
        return "TFS.ServerBrowser";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myForm.getPreferredFocusedComponent();
    }
}

