/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui.checkoutwizard;

import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.CheckoutModeForm;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.CheckoutWizardModel;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.CheckoutWizardStep;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.ChooseWorkspaceStep;

public class ChooseModeStep
extends CheckoutWizardStep {
    public static final Object ID = new Object();
    private final CheckoutModeForm myForm = new CheckoutModeForm();

    public ChooseModeStep(CheckoutWizardModel model) {
        super("Checkout Mode", model);
        this.myForm.addListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ChooseModeStep.this.revalidate();
                ChooseModeStep.this.fireStateChanged();
            }
        });
        this.revalidate();
    }

    private void revalidate() {
        this.myForm.setErrorMessage(this.validate());
    }

    @Nullable
    private String validate() {
        if (this.myForm.isAutoModeSelected()) {
            String name = this.myForm.getNewWorkspaceName();
            if (StringUtil.isEmpty((String)name)) {
                return TFSBundle.message("workspace.name.empty", new Object[0]);
            }
            if (!WorkspaceInfo.isValidName(name)) {
                return TFSBundle.message("workspace.name.invalid", new Object[0]);
            }
        }
        return null;
    }

    @NotNull
    public Object getStepId() {
        Object object = ID;
        if (object == null) {
            ChooseModeStep.$$$reportNull$$$0(0);
        }
        return object;
    }

    @Nullable
    public Object getNextStepId() {
        return ChooseWorkspaceStep.ID;
    }

    @Nullable
    public Object getPreviousStepId() {
        return null;
    }

    public boolean isComplete() {
        return this.validate() == null;
    }

    public void _init() {
        this.myForm.setNewWorkspaceName(this.myModel.getNewWorkspaceName());
        this.myForm.setAutoModeSelected(this.myModel.getMode() == CheckoutWizardModel.Mode.Auto);
        this.revalidate();
    }

    public void commit(AbstractWizardStepEx.CommitType commitType) throws CommitStepException {
        this.myModel.setMode(this.myForm.isAutoModeSelected() ? CheckoutWizardModel.Mode.Auto : CheckoutWizardModel.Mode.Manual);
        this.myModel.setNewWorkspaceName(this.myForm.getNewWorkspaceName());
    }

    public JComponent getComponent() {
        return this.myForm.getContentPanel();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myForm.getPreferredFocusedComponent();
    }

    public String getHelpId() {
        return "reference.checkoutTFS.checkoutmode";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/checkoutwizard/ChooseModeStep", "getStepId"));
    }
}

