/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.core.TFSProjectConfiguration;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.version.LatestVersionSpec;
import org.jetbrains.tfsIntegration.core.tfs.version.VersionSpecBase;
import org.jetbrains.tfsIntegration.ui.SelectRevisionForm;

public class UpdateSettingsForm {
    private final Map<WorkspaceInfo, WorkspaceSettings> myWorkspaceSettings;
    private JPanel myPanel;
    private JCheckBox myRecursiveBox;
    private JList myWorkspacesList;
    private SelectRevisionForm mySelectRevisionForm;
    private JPanel myWorkspaceSettingsPanel;
    private WorkspaceInfo mySelectedWorkspace;

    public UpdateSettingsForm(final Project project, final String title, Map<WorkspaceInfo, WorkspaceSettings> workspaceSettings) {
        this.myWorkspaceSettings = workspaceSettings;
        this.$$$setupUI$$$();
        ArrayList<WorkspaceInfo> workspaces = new ArrayList<WorkspaceInfo>(this.myWorkspaceSettings.keySet());
        Collections.sort(workspaces, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        this.myWorkspacesList.setModel(new CollectionListModel(workspaces));
        this.myWorkspacesList.getSelectionModel().setSelectionMode(0);
        this.myWorkspacesList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                WorkspaceInfo workspace = (WorkspaceInfo)value;
                String label = MessageFormat.format("{0} [{1}]", workspace.getName(), workspace.getServer().getPresentableUri());
                this.setText(label);
                return c;
            }
        });
        this.myWorkspacesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                try {
                    UpdateSettingsForm.this.applyCurrentValue();
                }
                catch (ConfigurationException ex) {
                    Messages.showErrorDialog((Project)project, (String)ex.getMessage(), (String)title);
                }
                UpdateSettingsForm.this.mySelectedWorkspace = (WorkspaceInfo)UpdateSettingsForm.this.myWorkspacesList.getSelectedValue();
                if (UpdateSettingsForm.this.mySelectedWorkspace != null) {
                    WorkspaceSettings workspaceSettings = (WorkspaceSettings)UpdateSettingsForm.this.myWorkspaceSettings.get(UpdateSettingsForm.this.mySelectedWorkspace);
                    UpdateSettingsForm.this.mySelectRevisionForm.init(project, UpdateSettingsForm.this.mySelectedWorkspace, workspaceSettings.serverPath, workspaceSettings.isDirectory);
                    UpdateSettingsForm.this.mySelectRevisionForm.setVersionSpec(workspaceSettings.version);
                } else {
                    UpdateSettingsForm.this.mySelectRevisionForm.disable();
                }
            }
        });
        if (workspaces.isEmpty()) {
            this.mySelectRevisionForm.disable();
        } else {
            this.myWorkspacesList.setSelectedIndex(0);
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myWorkspacesList, true));
        }
    }

    private void applyCurrentValue() throws ConfigurationException {
        if (this.mySelectedWorkspace != null) {
            VersionSpecBase version = this.mySelectRevisionForm.getVersionSpec();
            if (version != null) {
                this.myWorkspaceSettings.get((Object)this.mySelectedWorkspace).version = version;
            } else {
                throw new ConfigurationException("Invalid version specified");
            }
        }
    }

    public void reset(TFSProjectConfiguration configuration) {
        this.myRecursiveBox.setSelected(configuration.getState().UPDATE_RECURSIVELY);
        for (Map.Entry<WorkspaceInfo, WorkspaceSettings> e : this.myWorkspaceSettings.entrySet()) {
            e.getValue().version = configuration.getUpdateWorkspaceInfo(e.getKey()).getVersion();
        }
    }

    public void apply(TFSProjectConfiguration configuration) throws ConfigurationException {
        this.applyCurrentValue();
        configuration.getState().UPDATE_RECURSIVELY = this.myRecursiveBox.isSelected();
        for (Map.Entry<WorkspaceInfo, WorkspaceSettings> e : this.myWorkspaceSettings.entrySet()) {
            configuration.getUpdateWorkspaceInfo(e.getKey()).setVersion(e.getValue().version);
        }
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SelectRevisionForm selectRevisionForm;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myRecursiveBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("org/jetbrains/tfsIntegration/core/TFSBundle").getString("checkbox.update.switch.configurable.descend.into.child.directories"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBList jBList = new JBList();
        this.myWorkspacesList = jBList;
        jBScrollPane.setViewportView((Component)jBList);
        this.myWorkspaceSettingsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 2, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Selected workspace version", (int)0, (int)0, null, null));
        this.mySelectRevisionForm = selectRevisionForm = new SelectRevisionForm();
        JComponent jComponent = selectRevisionForm.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("&Affected workspaces");
        jPanel2.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        titledSeparator.setLabelFor((Component)jBScrollPane);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static class WorkspaceSettings {
        public final String serverPath;
        public final boolean isDirectory;
        public VersionSpecBase version;

        public WorkspaceSettings(@NotNull String serverPath, boolean isDirectory) {
            if (serverPath == null) {
                WorkspaceSettings.$$$reportNull$$$0(0);
            }
            this.version = LatestVersionSpec.INSTANCE;
            this.serverPath = serverPath;
            this.isDirectory = isDirectory;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverPath", "org/jetbrains/tfsIntegration/ui/UpdateSettingsForm$WorkspaceSettings", "<init>"));
        }
    }
}

