/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.version.ChangesetVersionSpec;
import org.jetbrains.tfsIntegration.core.tfs.version.DateVersionSpec;
import org.jetbrains.tfsIntegration.core.tfs.version.LabelVersionSpec;
import org.jetbrains.tfsIntegration.core.tfs.version.LatestVersionSpec;
import org.jetbrains.tfsIntegration.core.tfs.version.VersionSpecBase;
import org.jetbrains.tfsIntegration.core.tfs.version.WorkspaceVersionSpec;
import org.jetbrains.tfsIntegration.ui.SelectChangesetDialog;
import org.jetbrains.tfsIntegration.ui.SelectLabelDialog;

public class SelectRevisionForm {
    private static final DateFormat DATE_FORMAT = SimpleDateFormat.getInstance();
    private JPanel myPanel;
    private JRadioButton latestRadioButton;
    private JRadioButton dateRadioButton;
    private JRadioButton changesetRadioButton;
    private JRadioButton labelRadioButton;
    private JRadioButton workspaceRadioButton;
    private TextFieldWithBrowseButton.NoPathCompletion labelVersionText;
    private TextFieldWithBrowseButton.NoPathCompletion changesetVersionText;
    private JTextField dateText;
    private JTextField workspaceText;
    private WorkspaceInfo myWorkspace;
    private Project myProject;
    private String myServerPath;
    private boolean myIsDirectory;
    private final EventDispatcher<Listener> myEventDispatcher;

    public SelectRevisionForm(Project project, WorkspaceInfo workspace, String serverPath, boolean isDirectory) {
        this();
        this.init(project, workspace, serverPath, isDirectory);
    }

    public SelectRevisionForm() {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(Listener.class);
        DocumentAdapter documentListener = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e1) {
                ((Listener)SelectRevisionForm.this.myEventDispatcher.getMulticaster()).revisionChanged();
            }
        };
        this.labelVersionText.getTextField().getDocument().addDocumentListener((DocumentListener)documentListener);
        this.changesetVersionText.getTextField().getDocument().addDocumentListener((DocumentListener)documentListener);
        this.dateText.getDocument().addDocumentListener((DocumentListener)documentListener);
        this.workspaceText.getDocument().addDocumentListener((DocumentListener)documentListener);
        ActionListener radioButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectRevisionForm.this.updateContols();
                ((Listener)SelectRevisionForm.this.myEventDispatcher.getMulticaster()).revisionChanged();
            }
        };
        this.latestRadioButton.addActionListener(radioButtonListener);
        this.dateRadioButton.addActionListener(radioButtonListener);
        this.changesetRadioButton.addActionListener(radioButtonListener);
        this.labelRadioButton.addActionListener(radioButtonListener);
        this.workspaceRadioButton.addActionListener(radioButtonListener);
        this.changesetVersionText.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectChangesetDialog d = new SelectChangesetDialog(SelectRevisionForm.this.myProject, SelectRevisionForm.this.myWorkspace, SelectRevisionForm.this.myServerPath, SelectRevisionForm.this.myIsDirectory);
                if (d.showAndGet()) {
                    SelectRevisionForm.this.changesetVersionText.setText(String.valueOf(d.getChangeset()));
                }
            }
        });
        this.labelVersionText.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectLabelDialog d = new SelectLabelDialog(SelectRevisionForm.this.myProject, SelectRevisionForm.this.myWorkspace);
                if (d.showAndGet()) {
                    SelectRevisionForm.this.labelVersionText.setText(d.getLabelString());
                }
            }
        });
        this.latestRadioButton.setSelected(true);
    }

    public void init(Project project, WorkspaceInfo workspace, String serverPath, boolean isDirectory) {
        this.myWorkspace = workspace;
        this.myProject = project;
        this.myServerPath = serverPath;
        this.myIsDirectory = isDirectory;
    }

    private void updateContols() {
        this.workspaceText.setEnabled(this.workspaceRadioButton.isSelected());
        if (!this.workspaceRadioButton.isSelected()) {
            this.workspaceText.setText(null);
        } else {
            this.workspaceText.setText(this.myWorkspace.getName() + ';' + TfsUtil.getNameWithoutDomain(this.myWorkspace.getOwnerName()));
        }
        this.dateText.setEnabled(this.dateRadioButton.isSelected());
        if (!this.dateRadioButton.isSelected()) {
            this.dateText.setText(null);
        } else {
            this.dateText.setText(DATE_FORMAT.format(new Date()));
        }
        this.labelVersionText.setEnabled(this.labelRadioButton.isSelected());
        if (!this.labelRadioButton.isSelected()) {
            this.labelVersionText.setText(null);
        }
        this.changesetVersionText.setEnabled(this.changesetRadioButton.isSelected());
        if (!this.changesetRadioButton.isSelected()) {
            this.changesetVersionText.setText(null);
        }
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    public void setVersionSpec(VersionSpecBase version) {
        this.latestRadioButton.setEnabled(true);
        this.dateRadioButton.setEnabled(true);
        this.changesetRadioButton.setEnabled(true);
        this.labelRadioButton.setEnabled(true);
        this.workspaceRadioButton.setEnabled(true);
        if (version instanceof LatestVersionSpec) {
            this.latestRadioButton.setSelected(true);
        } else if (version instanceof ChangesetVersionSpec) {
            this.changesetRadioButton.setSelected(true);
            this.changesetVersionText.setEnabled(true);
            this.changesetVersionText.setText(version.getPresentableString());
        } else if (version instanceof WorkspaceVersionSpec) {
            this.workspaceRadioButton.setSelected(true);
            this.workspaceText.setEnabled(true);
            this.workspaceText.setText(version.getPresentableString());
        } else if (version instanceof DateVersionSpec) {
            this.dateRadioButton.setSelected(true);
            this.dateText.setEnabled(true);
            this.dateText.setText(version.getPresentableString());
        } else if (version instanceof LabelVersionSpec) {
            this.labelRadioButton.setSelected(true);
            this.labelVersionText.setEnabled(true);
            this.labelVersionText.setText(version.getPresentableString());
        }
        this.updateContols();
    }

    @Nullable
    public VersionSpecBase getVersionSpec() {
        if (this.latestRadioButton.isSelected()) {
            return LatestVersionSpec.INSTANCE;
        }
        if (this.changesetRadioButton.isSelected()) {
            try {
                int changeset = Integer.parseInt(this.changesetVersionText.getText());
                return new ChangesetVersionSpec(changeset);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (this.workspaceRadioButton.isSelected()) {
            return this.parseWorkspaceVersionSpec(this.workspaceText.getText());
        }
        if (this.dateRadioButton.isSelected()) {
            try {
                return new DateVersionSpec(DATE_FORMAT.parse(this.dateText.getText()));
            }
            catch (ParseException e) {
                return null;
            }
        }
        if (this.labelRadioButton.isSelected()) {
            if (this.labelVersionText.getText().trim().length() > 0) {
                return LabelVersionSpec.fromStringRepresentation(this.labelVersionText.getText());
            }
            return null;
        }
        return null;
    }

    @Nullable
    private WorkspaceVersionSpec parseWorkspaceVersionSpec(String versionSpec) {
        int newLength;
        String workspaceName;
        if (versionSpec == null || versionSpec.length() == 0 || versionSpec.charAt(0) == ';') {
            return null;
        }
        int semicolonIndex = versionSpec.indexOf(59);
        String string = workspaceName = semicolonIndex < 0 ? versionSpec : versionSpec.substring(0, semicolonIndex);
        if (!WorkspaceInfo.isValidName(workspaceName)) {
            return null;
        }
        String ownerName = semicolonIndex < 0 || semicolonIndex == versionSpec.length() - 1 ? TfsUtil.getNameWithoutDomain(this.myWorkspace.getOwnerName()) : versionSpec.substring(semicolonIndex + 1);
        for (newLength = ownerName.length(); newLength > 0 && ownerName.charAt(newLength - 1) == ' '; --newLength) {
        }
        if (newLength == 0) {
            ownerName = TfsUtil.getNameWithoutDomain(this.myWorkspace.getOwnerName());
        } else if (newLength < ownerName.length()) {
            ownerName = ownerName.substring(0, newLength);
        }
        return new WorkspaceVersionSpec(workspaceName, ownerName);
    }

    public void disable() {
        this.latestRadioButton.setSelected(true);
        this.latestRadioButton.setEnabled(false);
        this.dateRadioButton.setEnabled(false);
        this.changesetRadioButton.setEnabled(false);
        this.labelRadioButton.setEnabled(false);
        this.workspaceRadioButton.setEnabled(false);
        this.updateContols();
    }

    public void addListener(Listener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(Listener listener) {
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        TextFieldWithBrowseButton.NoPathCompletion noPathCompletion;
        JRadioButton jRadioButton;
        TextFieldWithBrowseButton.NoPathCompletion noPathCompletion2;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.latestRadioButton = jRadioButton5 = new JRadioButton();
        ((Component)jRadioButton5).setEnabled(true);
        jRadioButton5.setSelected(true);
        jRadioButton5.setText("Latest");
        jPanel2.add((Component)jRadioButton5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.dateRadioButton = jRadioButton4 = new JRadioButton();
        jRadioButton4.setText("Date");
        jPanel2.add((Component)jRadioButton4, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.labelRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Label");
        jPanel2.add((Component)jRadioButton3, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.workspaceRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Workspace");
        jPanel2.add((Component)jRadioButton2, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.labelVersionText = noPathCompletion2 = new TextFieldWithBrowseButton.NoPathCompletion();
        noPathCompletion2.setEnabled(false);
        noPathCompletion2.setText("");
        jPanel2.add((Component)noPathCompletion2, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.changesetRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Changeset");
        jPanel2.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.changesetVersionText = noPathCompletion = new TextFieldWithBrowseButton.NoPathCompletion();
        noPathCompletion.setEnabled(false);
        jPanel2.add((Component)noPathCompletion, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, new Dimension(150, -1), new Dimension(150, -1), null));
        this.workspaceText = jTextField2 = new JTextField();
        ((Component)jTextField2).setEnabled(false);
        jPanel2.add((Component)jTextField2, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.dateText = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(false);
        jPanel2.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton5);
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    public static interface Listener
    extends EventListener {
        public void revisionChanged();
    }
}

