/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.version.VersionSpecBase;
import org.jetbrains.tfsIntegration.ui.CreateBranchForm;

public class CreateBranchDialog
extends DialogWrapper {
    private final CreateBranchForm myForm;

    public CreateBranchDialog(Project project, WorkspaceInfo workspace, String serverPath, boolean isDirectory) {
        super(project, true);
        this.myForm = new CreateBranchForm(project, workspace, serverPath, isDirectory);
        this.myForm.addListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CreateBranchDialog.this.revalidate();
            }
        });
        this.setTitle(TFSBundle.message("create.branch.dialog.title", new Object[0]));
        this.setSize(380, 450);
        this.init();
        this.revalidate();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myForm.getContentPane();
    }

    private void revalidate() {
        this.setOKActionEnabled(StringUtil.isNotEmpty((String)this.myForm.getTargetPath()));
    }

    @Nullable
    public VersionSpecBase getVersionSpec() {
        return this.myForm.getVersionSpec();
    }

    public String getTargetPath() {
        return this.myForm.getTargetPath();
    }

    public boolean isCreateWorkingCopies() {
        return this.myForm.isCreateWorkingCopies();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myForm.getPreferredFocusedComponent();
    }

    protected String getDimensionServiceKey() {
        return "TFS.CreateBranch";
    }
}

