/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.checkin.CheckinPoliciesManager;
import org.jetbrains.tfsIntegration.checkin.DuplicatePolicyIdException;
import org.jetbrains.tfsIntegration.checkin.PolicyBase;
import org.jetbrains.tfsIntegration.checkin.StatefulPolicyDescriptor;
import org.jetbrains.tfsIntegration.checkin.StatefulPolicyParser;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.core.configuration.TfsCheckinPoliciesCompatibility;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlPath;
import org.jetbrains.tfsIntegration.ui.ChooseCheckinPolicyDialog;
import org.jetbrains.tfsIntegration.ui.ManageWorkspacesForm;

public class CheckInPoliciesForm {
    private final ColumnInfo[] COLUMNS;
    private JComboBox myProjectCombo;
    private JButton myAddButton;
    private JButton myEditButton;
    private TableView<Pair<StatefulPolicyDescriptor, Boolean>> myPoliciesTable;
    private JButton myRemoveButton;
    private JPanel myContentPane;
    private JCheckBox myTeampriseCheckBox;
    private JCheckBox myNonInstalledPoliciesCheckBox;
    private JCheckBox myTeamExplorerCheckBox;
    private JCheckBox myOverrideCheckBox;
    private final Project myProject;
    private final Map<String, ModifyableProjectEntry> myProjectToDescriptors;
    private static final MyRenderer NAME_RENDERER = new MyRenderer(){

        @Override
        protected String getValue(StatefulPolicyDescriptor descriptor) {
            return descriptor.getType().getName();
        }
    };
    private static final MyRenderer DESCRIPTION_RENDERER = new MyRenderer(){

        @Override
        protected String getValue(StatefulPolicyDescriptor descriptor) {
            return descriptor.getType().getDescription();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel component = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Pair item = (Pair)value;
            component.setToolTipText(this.getValue((StatefulPolicyDescriptor)item.first));
            return component;
        }
    };

    public CheckInPoliciesForm(Project project, Map<String, ManageWorkspacesForm.ProjectEntry> projectToDescriptors) {
        ColumnInfo[] columnInfoArray = new ColumnInfo[3];
        this.$$$setupUI$$$();
        columnInfoArray[0] = new ColumnInfo<Pair<StatefulPolicyDescriptor, Boolean>, Boolean>("Enabled"){

            public Boolean valueOf(Pair<StatefulPolicyDescriptor, Boolean> item) {
                return ((StatefulPolicyDescriptor)item.first).isEnabled();
            }

            public Class getColumnClass() {
                return Boolean.class;
            }

            public int getWidth(JTable table) {
                return 60;
            }

            public boolean isCellEditable(Pair<StatefulPolicyDescriptor, Boolean> item) {
                return true;
            }

            public void setValue(Pair<StatefulPolicyDescriptor, Boolean> item, Boolean value) {
                ((StatefulPolicyDescriptor)item.first).setEnabled(value);
                ((ModifyableProjectEntry)((CheckInPoliciesForm)CheckInPoliciesForm.this).myProjectToDescriptors.get((Object)((CheckInPoliciesForm)CheckInPoliciesForm.this).getSelectedProject())).isModified = true;
            }
        };
        columnInfoArray[1] = new ColumnInfo<Pair<StatefulPolicyDescriptor, Boolean>, Pair<StatefulPolicyDescriptor, Boolean>>("Policy Type"){

            public Pair<StatefulPolicyDescriptor, Boolean> valueOf(Pair<StatefulPolicyDescriptor, Boolean> item) {
                return item;
            }

            public TableCellRenderer getRenderer(Pair<StatefulPolicyDescriptor, Boolean> item) {
                return NAME_RENDERER;
            }
        };
        columnInfoArray[2] = new ColumnInfo<Pair<StatefulPolicyDescriptor, Boolean>, Pair<StatefulPolicyDescriptor, Boolean>>("Description"){

            public Pair<StatefulPolicyDescriptor, Boolean> valueOf(Pair<StatefulPolicyDescriptor, Boolean> item) {
                return item;
            }

            public TableCellRenderer getRenderer(Pair<StatefulPolicyDescriptor, Boolean> item) {
                return DESCRIPTION_RENDERER;
            }
        };
        this.COLUMNS = columnInfoArray;
        this.myProject = project;
        this.myProjectToDescriptors = new HashMap<String, ModifyableProjectEntry>(projectToDescriptors.size());
        for (Map.Entry<String, ManageWorkspacesForm.ProjectEntry> e : projectToDescriptors.entrySet()) {
            this.myProjectToDescriptors.put(e.getKey(), new ModifyableProjectEntry(new ModifyableProjectEntry(e.getValue())));
        }
        this.myProjectCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckInPoliciesForm.this.updateTable();
                CheckInPoliciesForm.this.updateCheckboxes();
            }
        });
        this.myPoliciesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CheckInPoliciesForm.this.updateButtons();
            }
        });
        ArrayList<String> projects = new ArrayList<String>(this.myProjectToDescriptors.keySet());
        Collections.sort(projects, (s1, s2) -> s1.compareTo((String)s2));
        this.myProjectCombo.setModel(new DefaultComboBoxModel<String>(ArrayUtil.toStringArray(projects)));
        this.myProjectCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel component = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                String path = (String)value;
                component.setText(VersionControlPath.getTeamProject(path));
                return component;
            }
        });
        this.myPoliciesTable.setModelAndUpdateColumns(new ListTableModel(this.COLUMNS));
        this.myEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatefulPolicyDescriptor descriptor = CheckInPoliciesForm.this.getSelectedDescriptor();
                CheckInPoliciesForm.this.editPolicy(descriptor);
            }
        });
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatefulPolicyDescriptor descriptor = CheckInPoliciesForm.this.getSelectedDescriptor();
                String message = MessageFormat.format("Are you sure to remove checkin policy ''{0}''?", descriptor.getType().getName());
                if (Messages.showOkCancelDialog((Project)CheckInPoliciesForm.this.myProject, (String)message, (String)"Remove Checkin Policy", (Icon)Messages.getQuestionIcon()) == 0) {
                    ModifyableProjectEntry projectEntry = (ModifyableProjectEntry)CheckInPoliciesForm.this.myProjectToDescriptors.get(CheckInPoliciesForm.this.getSelectedProject());
                    projectEntry.descriptors.remove(descriptor);
                    projectEntry.isModified = true;
                    CheckInPoliciesForm.this.updateTable();
                    CheckInPoliciesForm.this.updateButtons();
                }
            }
        });
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifyableProjectEntry projectEntry = (ModifyableProjectEntry)CheckInPoliciesForm.this.myProjectToDescriptors.get(CheckInPoliciesForm.this.getSelectedProject());
                ArrayList<PolicyBase> policies = new ArrayList<PolicyBase>();
                try {
                    block2: for (PolicyBase installed : CheckinPoliciesManager.getInstalledPolicies()) {
                        if (!installed.canEdit()) {
                            for (StatefulPolicyDescriptor descriptor : projectEntry.descriptors) {
                                if (!descriptor.getType().equals(installed.getPolicyType())) continue;
                                continue block2;
                            }
                        }
                        policies.add(installed);
                    }
                }
                catch (DuplicatePolicyIdException ex) {
                    String message = MessageFormat.format("Several checkin policies with the same id found: ''{0}''.\nPlease review your extensions.", ex.getDuplicateId());
                    Messages.showErrorDialog((Project)CheckInPoliciesForm.this.myProject, (String)message, (String)"Add Checkin Policy");
                    return;
                }
                ChooseCheckinPolicyDialog d = new ChooseCheckinPolicyDialog(CheckInPoliciesForm.this.myProject, policies);
                if (!d.showAndGet()) {
                    return;
                }
                PolicyBase policy = d.getSelectedPolicy();
                StatefulPolicyDescriptor newDescriptor = new StatefulPolicyDescriptor(policy.getPolicyType(), true, StatefulPolicyParser.createEmptyConfiguration(), Collections.emptyList(), "0", null);
                if (!CheckInPoliciesForm.this.editPolicy(newDescriptor)) {
                    return;
                }
                projectEntry.descriptors.add(newDescriptor);
                projectEntry.isModified = true;
                CheckInPoliciesForm.this.updateTable();
                int index = projectEntry.descriptors.size() - 1;
                CheckInPoliciesForm.this.myPoliciesTable.getSelectionModel().setSelectionInterval(index, index);
                CheckInPoliciesForm.this.updateButtons();
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                StatefulPolicyDescriptor descriptor = CheckInPoliciesForm.this.getSelectedDescriptor();
                if (descriptor != null) {
                    CheckInPoliciesForm.this.editPolicy(descriptor);
                }
                return true;
            }
        }.installOn(this.myPoliciesTable);
        this.myTeampriseCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifyableProjectEntry entry = (ModifyableProjectEntry)CheckInPoliciesForm.this.myProjectToDescriptors.get(CheckInPoliciesForm.this.getSelectedProject());
                entry.policiesCompatibilityOverride.teamprise = CheckInPoliciesForm.this.myTeampriseCheckBox.isSelected();
                entry.isModified = true;
            }
        });
        this.myTeamExplorerCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifyableProjectEntry entry = (ModifyableProjectEntry)CheckInPoliciesForm.this.myProjectToDescriptors.get(CheckInPoliciesForm.this.getSelectedProject());
                entry.policiesCompatibilityOverride.teamExplorer = CheckInPoliciesForm.this.myTeamExplorerCheckBox.isSelected();
                entry.isModified = true;
            }
        });
        this.myNonInstalledPoliciesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifyableProjectEntry entry = (ModifyableProjectEntry)CheckInPoliciesForm.this.myProjectToDescriptors.get(CheckInPoliciesForm.this.getSelectedProject());
                entry.policiesCompatibilityOverride.nonInstalled = CheckInPoliciesForm.this.myNonInstalledPoliciesCheckBox.isSelected();
                entry.isModified = true;
            }
        });
        this.myOverrideCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifyableProjectEntry entry = (ModifyableProjectEntry)CheckInPoliciesForm.this.myProjectToDescriptors.get(CheckInPoliciesForm.this.getSelectedProject());
                entry.policiesCompatibilityOverride = CheckInPoliciesForm.this.myOverrideCheckBox.isSelected() ? new TfsCheckinPoliciesCompatibility(false, false, false) : null;
                CheckInPoliciesForm.this.updateCheckboxes();
                entry.isModified = true;
            }
        });
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = CheckInPoliciesForm.this.myTeamExplorerCheckBox.isSelected() || CheckInPoliciesForm.this.myTeampriseCheckBox.isSelected();
                CheckInPoliciesForm.this.myNonInstalledPoliciesCheckBox.setEnabled(b);
                if (!b) {
                    CheckInPoliciesForm.this.myNonInstalledPoliciesCheckBox.setSelected(false);
                    ((ModifyableProjectEntry)((CheckInPoliciesForm)CheckInPoliciesForm.this).myProjectToDescriptors.get((Object)((CheckInPoliciesForm)CheckInPoliciesForm.this).getSelectedProject())).policiesCompatibilityOverride.nonInstalled = false;
                }
            }
        };
        this.myTeamExplorerCheckBox.addActionListener(l);
        this.myTeampriseCheckBox.addActionListener(l);
        this.updateTable();
        this.updateCheckboxes();
        this.updateButtons();
    }

    private void updateCheckboxes() {
        ModifyableProjectEntry entry = this.myProjectToDescriptors.get(this.getSelectedProject());
        this.myOverrideCheckBox.setText(TFSBundle.message("override.policies.compatibility.checkbox", VersionControlPath.getTeamProject(this.getSelectedProject())));
        this.myOverrideCheckBox.setSelected(entry.policiesCompatibilityOverride != null);
        this.updateSlaveCheckboxes(entry.policiesCompatibilityOverride);
    }

    private void updateSlaveCheckboxes(@Nullable TfsCheckinPoliciesCompatibility override) {
        if (override != null) {
            this.myTeampriseCheckBox.setEnabled(true);
            this.myTeampriseCheckBox.setSelected(override.teamprise);
            this.myTeamExplorerCheckBox.setEnabled(true);
            this.myTeamExplorerCheckBox.setSelected(override.teamExplorer);
            this.myNonInstalledPoliciesCheckBox.setSelected(override.nonInstalled);
            this.myNonInstalledPoliciesCheckBox.setEnabled(this.myTeamExplorerCheckBox.isSelected() || this.myTeampriseCheckBox.isSelected());
        } else {
            this.myOverrideCheckBox.setSelected(false);
            this.myTeampriseCheckBox.setSelected(false);
            this.myTeampriseCheckBox.setEnabled(false);
            this.myTeamExplorerCheckBox.setSelected(false);
            this.myTeamExplorerCheckBox.setEnabled(false);
            this.myNonInstalledPoliciesCheckBox.setSelected(false);
            this.myNonInstalledPoliciesCheckBox.setEnabled(false);
        }
    }

    private void updateButtons() {
        StatefulPolicyDescriptor descriptor = this.getSelectedDescriptor();
        if (descriptor == null) {
            this.myEditButton.setEnabled(false);
            this.myRemoveButton.setEnabled(false);
        } else {
            try {
                PolicyBase policy = CheckinPoliciesManager.find(descriptor.getType());
                this.myEditButton.setEnabled(policy != null && CheckInPoliciesForm.canEditSafe(policy));
                this.myRemoveButton.setEnabled(true);
            }
            catch (DuplicatePolicyIdException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void updateTable() {
        ArrayList<Pair> list = new ArrayList<Pair>(this.myProjectToDescriptors.get((Object)this.getSelectedProject()).descriptors.size());
        try {
            Iterator iterator = this.myProjectToDescriptors.get((Object)this.getSelectedProject()).descriptors.iterator();
            while (iterator.hasNext()) {
                StatefulPolicyDescriptor descriptor;
                list.add(Pair.create((Object)descriptor, (Object)(CheckinPoliciesManager.find((descriptor = (StatefulPolicyDescriptor)iterator.next()).getType()) != null ? 1 : 0)));
            }
        }
        catch (DuplicatePolicyIdException e) {
            throw new RuntimeException(e);
        }
        ((ListTableModel)this.myPoliciesTable.getModel()).setItems(list);
    }

    private String getSelectedProject() {
        return (String)this.myProjectCombo.getSelectedItem();
    }

    @Nullable
    private StatefulPolicyDescriptor getSelectedDescriptor() {
        Pair selected = (Pair)this.myPoliciesTable.getSelectedObject();
        return selected != null ? (StatefulPolicyDescriptor)selected.first : null;
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    private boolean editPolicy(StatefulPolicyDescriptor descriptor) {
        boolean result;
        PolicyBase policy;
        try {
            policy = CheckinPoliciesManager.find(descriptor.getType());
        }
        catch (DuplicatePolicyIdException e) {
            throw new RuntimeException(e);
        }
        if (policy == null) {
            return false;
        }
        if (!CheckInPoliciesForm.canEditSafe(policy)) {
            return true;
        }
        try {
            policy.loadState(descriptor.getConfiguration().clone());
        }
        catch (Throwable t) {
            String message = MessageFormat.format("Cannot load state of checkin policy ''{0}'':\n{1}", descriptor.getType().getName(), t.getMessage());
            Messages.showErrorDialog((Project)this.myProject, (String)message, (String)"Edit Checkin Policy");
            return false;
        }
        try {
            result = policy.edit(this.myProject);
        }
        catch (Throwable t) {
            String message = MessageFormat.format("Cannot edit checkin policy ''{0}'':\n{1}", descriptor.getType().getName(), t.getMessage());
            Messages.showErrorDialog((Project)this.myProject, (String)message, (String)"Edit Checkin Policy");
            return false;
        }
        if (result) {
            Element configurationElement = StatefulPolicyParser.createEmptyConfiguration();
            try {
                policy.saveState(configurationElement);
                descriptor.setConfiguration(configurationElement);
                this.myProjectToDescriptors.get((Object)this.getSelectedProject()).isModified = true;
            }
            catch (Throwable t) {
                String message = MessageFormat.format("Cannot save state of checkin policy ''{0}'':\n{1}", descriptor.getType().getName(), t.getMessage());
                Messages.showErrorDialog((Project)this.myProject, (String)message, (String)"Edit Checkin Policy");
            }
        }
        return result;
    }

    private static boolean canEditSafe(PolicyBase policy) {
        try {
            return policy.canEdit();
        }
        catch (Throwable t) {
            TFSVcs.LOG.warn(t);
            return false;
        }
    }

    public Map<String, ManageWorkspacesForm.ProjectEntry> getModifications() {
        HashMap<String, ManageWorkspacesForm.ProjectEntry> result = new HashMap<String, ManageWorkspacesForm.ProjectEntry>();
        for (Map.Entry<String, ModifyableProjectEntry> entry : this.myProjectToDescriptors.entrySet()) {
            if (!entry.getValue().isModified) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JButton jButton;
        JButton jButton2;
        TableView tableView;
        JButton jButton3;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("<html><b>Team project:</b></html>");
        jLabel.setDisplayedMnemonic('P');
        jLabel.setDisplayedMnemonicIndex(14);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProjectCombo = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, new Dimension(120, -1), null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Teamprise checkin policies", (int)0, (int)0, null, null));
        this.myAddButton = jButton3 = new JButton();
        jButton3.setText("Add...");
        jButton3.setMnemonic('A');
        jButton3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jButton3, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 4, 1, 0, 3, 7, 7, null, null, null));
        this.myPoliciesTable = tableView = new TableView();
        jBScrollPane.setViewportView((Component)tableView);
        this.myEditButton = jButton2 = new JButton();
        jButton2.setText("Edit...");
        jButton2.setMnemonic('D');
        jButton2.setDisplayedMnemonicIndex(1);
        jPanel2.add((Component)jButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRemoveButton = jButton = new JButton();
        jButton.setText("Remove");
        jButton.setMnemonic('R');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jButton, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel3, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Compatibility", (int)0, (int)0, null, null));
        this.myTeampriseCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Evaluate Teamprise policies");
        jCheckBox4.setMnemonic('E');
        jCheckBox4.setDisplayedMnemonicIndex(10);
        jPanel3.add((Component)jCheckBox4, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myNonInstalledPoliciesCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Warn about not installed policies");
        jCheckBox3.setMnemonic('W');
        jCheckBox3.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jCheckBox3, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myOverrideCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Override default settings for the selected team project:");
        jCheckBox2.setMnemonic('O');
        jCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTeamExplorerCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Evaluate Team Explorer policies");
        jCheckBox.setMnemonic('T');
        jCheckBox.setDisplayedMnemonicIndex(9);
        jPanel3.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private static abstract class MyRenderer
    extends DefaultTableCellRenderer {
        private static final Color NOT_INSTALLED_POLICY_COLOR = UIUtil.getInactiveTextColor();

        private MyRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel component = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Pair item = (Pair)value;
            component.setText(this.getValue((StatefulPolicyDescriptor)item.first));
            Color foreground = isSelected ? table.getSelectionForeground() : ((Boolean)item.second != false ? table.getForeground() : NOT_INSTALLED_POLICY_COLOR);
            component.setForeground(foreground);
            return component;
        }

        protected abstract String getValue(StatefulPolicyDescriptor var1);
    }

    private static class ModifyableProjectEntry
    extends ManageWorkspacesForm.ProjectEntry {
        public boolean isModified = false;

        public ModifyableProjectEntry(ManageWorkspacesForm.ProjectEntry entry) {
            this.descriptors = entry.descriptors;
            this.policiesCompatibilityOverride = entry.policiesCompatibilityOverride;
        }
    }
}

