/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.tfs.ServerInfo;
import org.jetbrains.tfsIntegration.ui.CheckInPoliciesForm;
import org.jetbrains.tfsIntegration.ui.ManageWorkspacesForm;

public class CheckInPoliciesDialog
extends DialogWrapper {
    private final Project myProject;
    private final Map<String, ManageWorkspacesForm.ProjectEntry> myProjectToDescriptors;
    private CheckInPoliciesForm myForm;

    public CheckInPoliciesDialog(Project project, ServerInfo server, Map<String, ManageWorkspacesForm.ProjectEntry> projectToDescriptors) {
        super(project, false);
        this.myProject = project;
        this.myProjectToDescriptors = projectToDescriptors;
        this.setTitle(TFSBundle.message("checkin.policies.dialog.title", server.getPresentableUri()));
        this.init();
        this.setSize(800, 500);
    }

    protected JComponent createCenterPanel() {
        this.myForm = new CheckInPoliciesForm(this.myProject, this.myProjectToDescriptors);
        return this.myForm.getContentPane();
    }

    protected String getDimensionServiceKey() {
        return "TFS.ConfigureCheckInPolicies";
    }

    public Map<String, ManageWorkspacesForm.ProjectEntry> getModifications() {
        return this.myForm.getModifications();
    }

    protected String getHelpId() {
        return "project.propVCSSupport.VCSs.TFS.edit.checkin.policies";
    }
}

