/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.project.Project;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Item;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemType;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.LabelItemSpec;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.labels.LabelItemSpecWithItems;
import org.jetbrains.tfsIntegration.core.tfs.labels.LabelModel;
import org.jetbrains.tfsIntegration.ui.AddItemDialog;
import org.jetbrains.tfsIntegration.ui.LabelItemsTableModel;
import org.jetbrains.tfsIntegration.ui.UiConstants;

public class ApplyLabelForm {
    private final Project myProject;
    private final WorkspaceInfo myWorkspace;
    private final String mySourcePath;
    private JPanel myContentPane;
    private JTextField myLabelNameTextField;
    private JTextArea myLabelCommentTextArea;
    private JTable myTable;
    private JButton myAddButton;
    private JButton myRemoveButton;
    private LabelItemsTableModel myTableModel;
    private final LabelModel myLabelModel;
    private final EventDispatcher<Listener> myEventDispatcher;

    public ApplyLabelForm(Project project, WorkspaceInfo workspace, String sourcePath) {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(Listener.class);
        this.myProject = project;
        this.myWorkspace = workspace;
        this.mySourcePath = sourcePath;
        this.myLabelModel = new LabelModel();
        this.myLabelNameTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ((Listener)ApplyLabelForm.this.myEventDispatcher.getMulticaster()).dataChanged(ApplyLabelForm.this.getLabelName(), ApplyLabelForm.this.myTableModel.getRowCount());
            }
        });
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplyLabelForm.this.addItems();
            }
        });
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplyLabelForm.this.removeItems();
            }
        });
        this.initTable();
        this.updateButtons();
    }

    private void initTable() {
        this.myTableModel = new LabelItemsTableModel();
        this.myTable.setModel(this.myTableModel);
        for (int i = 0; i < LabelItemsTableModel.Column.values().length; ++i) {
            this.myTable.getColumnModel().getColumn(i).setPreferredWidth(LabelItemsTableModel.Column.values()[i].getWidth());
        }
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ApplyLabelForm.this.updateButtons();
            }
        });
        this.myTable.getColumnModel().getColumn(LabelItemsTableModel.Column.Item.ordinal()).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Item item = (Item)value;
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setIcon(item.getType() == ItemType.Folder ? UiConstants.ICON_FOLDER : UiConstants.ICON_FILE);
                this.setValue(item.getItem());
                return this;
            }
        });
    }

    private void removeItems() {
        ArrayList<LabelItemSpecWithItems> removalSpecs = new ArrayList<LabelItemSpecWithItems>(this.myTable.getSelectedRows().length);
        for (int selectedRow : this.myTable.getSelectedRows()) {
            removalSpecs.add(LabelItemSpecWithItems.createForRemove(this.myTableModel.getItem(selectedRow)));
        }
        this.myLabelModel.addAll(removalSpecs);
        this.reloadItems();
    }

    private void reloadItems() {
        this.myTableModel.setContent(this.myLabelModel.calculateItemsToDisplay());
        ((Listener)this.myEventDispatcher.getMulticaster()).dataChanged(this.getLabelName(), this.myTableModel.getRowCount());
    }

    public void addItems() {
        AddItemDialog d = new AddItemDialog(this.myProject, this.myWorkspace, this.mySourcePath);
        if (d.showAndGet()) {
            this.myLabelModel.add(d.getLabelSpec());
            this.reloadItems();
        }
    }

    private void updateButtons() {
        this.myRemoveButton.setEnabled(this.myTable.getSelectedRowCount() > 0);
    }

    public JPanel getContentPane() {
        return this.myContentPane;
    }

    public String getLabelName() {
        return this.myLabelNameTextField.getText().trim();
    }

    public String getLabelComment() {
        return this.myLabelCommentTextArea.getText();
    }

    public List<LabelItemSpec> getLabelItemSpecs() {
        return this.myLabelModel.getLabelItemSpecs();
    }

    public void addListener(Listener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(Listener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextArea jTextArea;
        JButton jButton;
        JButton jButton2;
        JTextField jTextField;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Name:");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLabelNameTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Comments:");
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Items:");
        jPanel.add((Component)jLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(6, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAddButton = jButton2 = new JButton();
        jButton2.setText("Add...");
        jButton2.setMnemonic('A');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myRemoveButton = jButton = new JButton();
        ((Component)jButton).setEnabled(false);
        jButton.setText("Remove");
        jButton.setMnemonic('R');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(5, 0, 1, 1, 0, 3, 7, 7, null, new Dimension(-1, 250), null));
        JBTable jBTable = new JBTable();
        this.myTable = jBTable;
        jBScrollPane.setViewportView((Component)jBTable);
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel.add((Component)jBScrollPane2, new GridConstraints(3, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myLabelCommentTextArea = jTextArea = new JTextArea();
        jTextArea.setRows(4);
        jBScrollPane2.setViewportView(jTextArea);
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    public static interface Listener
    extends EventListener {
        public void dataChanged(String var1, int var2);
    }
}

