/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.exceptions;

import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLHandshakeException;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultSubCode;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axis2.AxisFault;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.exceptions.ConnectionFailedException;
import org.jetbrains.tfsIntegration.exceptions.ConnectionTimeoutException;
import org.jetbrains.tfsIntegration.exceptions.ForbiddenException;
import org.jetbrains.tfsIntegration.exceptions.HostNotApplicableException;
import org.jetbrains.tfsIntegration.exceptions.HostNotFoundException;
import org.jetbrains.tfsIntegration.exceptions.IdentityNotFoundException;
import org.jetbrains.tfsIntegration.exceptions.IllegalIdentityException;
import org.jetbrains.tfsIntegration.exceptions.InvalidPathException;
import org.jetbrains.tfsIntegration.exceptions.ItemNotFoundException;
import org.jetbrains.tfsIntegration.exceptions.SSLConnectionException;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.exceptions.UnauthorizedException;
import org.jetbrains.tfsIntegration.exceptions.UnknownException;
import org.jetbrains.tfsIntegration.exceptions.WorkspaceNotFoundException;

public class TfsExceptionManager {
    private static final String TRANSPORT_ERROR_MESSAGE = "Transport error: ";
    private static final Map<String, Class<?>> ourExceptionsBySubcodes = new HashMap();

    @Nullable
    private static TfsException createTfsExceptionFromThrowable(Throwable throwable) {
        if (throwable instanceof ConnectException) {
            return new ConnectionFailedException(throwable);
        }
        if (throwable instanceof UnknownHostException) {
            return new HostNotFoundException(throwable);
        }
        if (throwable instanceof NoHttpResponseException) {
            return new HostNotFoundException(throwable);
        }
        if (throwable instanceof SSLHandshakeException) {
            return new SSLConnectionException((SSLHandshakeException)throwable);
        }
        if (throwable instanceof SOAPProcessingException) {
            return new ConnectionFailedException(throwable, TFSBundle.message("invalid.soap.response", new Object[0]));
        }
        if (throwable instanceof SocketException) {
            return new ConnectionFailedException(throwable);
        }
        if (throwable instanceof SocketTimeoutException || throwable instanceof ConnectTimeoutException) {
            return new ConnectionTimeoutException(throwable);
        }
        return null;
    }

    @Nullable
    private static TfsException createTfsExceptionFromAxisFault(AxisFault axisFault) {
        int errorCode;
        Class<?> exceptionClass;
        String subcodeText;
        SOAPFaultValue subcodeValue;
        SOAPFaultSubCode subCode;
        TfsException result = TfsExceptionManager.createTfsExceptionFromThrowable(axisFault.getCause());
        if (result != null) {
            return result;
        }
        SOAPFaultCode code = axisFault.getFaultCodeElement();
        if (code != null && (subCode = code.getSubCode()) != null && (subcodeValue = subCode.getValue()) != null && (subcodeText = subcodeValue.getText()) != null && (exceptionClass = ourExceptionsBySubcodes.get(subcodeText)) != null) {
            try {
                return (TfsException)exceptionClass.getConstructor(AxisFault.class).newInstance(axisFault);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((errorCode = TfsExceptionManager.getTransportErrorCode(axisFault)) != -1) {
            return TfsExceptionManager.createHttpTransportErrorException(errorCode, axisFault);
        }
        return new UnknownException((Exception)axisFault);
    }

    public static int getTransportErrorCode(AxisFault axisFault) {
        String[] tokens;
        if (axisFault.getMessage() != null && axisFault.getMessage().startsWith(TRANSPORT_ERROR_MESSAGE) && (tokens = axisFault.getMessage().substring(TRANSPORT_ERROR_MESSAGE.length()).split(" ")).length > 0) {
            try {
                return Integer.parseInt(tokens[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static TfsException processException(Exception e) {
        TfsException result = e instanceof AxisFault ? TfsExceptionManager.createTfsExceptionFromAxisFault((AxisFault)e) : TfsExceptionManager.createTfsExceptionFromThrowable(e);
        if (e instanceof TfsException) {
            result = (TfsException)e;
        }
        if (result == null) {
            TFSVcs.LOG.warn("Unknown exception", (Throwable)e);
            result = new UnknownException(e);
        }
        return result;
    }

    public static TfsException createHttpTransportErrorException(int errorCode, AxisFault axisFault) {
        switch (errorCode) {
            case 401: {
                return new UnauthorizedException(axisFault);
            }
            case 502: {
                return new HostNotFoundException((Throwable)axisFault);
            }
            case 404: {
                return new HostNotApplicableException(axisFault);
            }
            case 403: {
                return new ForbiddenException(axisFault);
            }
            case 407: {
                return new TfsException(TFSBundle.message("proxy.auth.failed", new Object[0]));
            }
        }
        return new ConnectionFailedException((Throwable)axisFault, errorCode);
    }

    static {
        ourExceptionsBySubcodes.put("WorkspaceNotFoundException", WorkspaceNotFoundException.class);
        ourExceptionsBySubcodes.put("IllegalIdentityException", IllegalIdentityException.class);
        ourExceptionsBySubcodes.put("IdentityNotFoundException", IdentityNotFoundException.class);
        ourExceptionsBySubcodes.put("ItemNotFoundException", ItemNotFoundException.class);
        ourExceptionsBySubcodes.put("InvalidPathException", InvalidPathException.class);
    }
}

