/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs.version;

import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.VersionSpec;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.databinding.utils.BeanUtil;
import org.apache.axis2.databinding.utils.writer.MTOMAwareXMLStreamWriter;

public abstract class VersionSpecBase
extends VersionSpec {
    public void serialize(QName parentQName, OMFactory factory, MTOMAwareXMLStreamWriter xmlWriter) throws XMLStreamException {
        String prefix = parentQName.getPrefix();
        String namespace = parentQName.getNamespaceURI();
        if (namespace != null) {
            String writerPrefix = xmlWriter.getPrefix(namespace);
            if (writerPrefix != null) {
                xmlWriter.writeStartElement(namespace, parentQName.getLocalPart());
            } else {
                if (prefix == null) {
                    prefix = VersionSpecBase.genPrefix(namespace);
                }
                xmlWriter.writeStartElement(prefix, parentQName.getLocalPart(), namespace);
                xmlWriter.writeNamespace(prefix, namespace);
                xmlWriter.setPrefix(prefix, namespace);
            }
        } else {
            xmlWriter.writeStartElement(parentQName.getLocalPart());
        }
        this.writeAttributes(parentQName, factory, xmlWriter);
        xmlWriter.writeEndElement();
    }

    private static String genPrefix(String namespace) {
        if (namespace.equals("http://schemas.microsoft.com/TeamFoundation/2005/06/VersionControl/ClientServices/03")) {
            return "";
        }
        return BeanUtil.getUniquePrefix();
    }

    protected abstract void writeAttributes(QName var1, OMFactory var2, MTOMAwareXMLStreamWriter var3) throws XMLStreamException;

    protected static void writeVersionAttribute(String namespace, String attName, String attValue, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (namespace.length() == 0) {
            xmlWriter.writeAttribute(attName, attValue);
        } else {
            VersionSpecBase.regPrefix(xmlWriter, namespace);
            xmlWriter.writeAttribute(namespace, attName, attValue);
        }
    }

    private static String regPrefix(XMLStreamWriter xmlWriter, String namespace) throws XMLStreamException {
        String prefix = xmlWriter.getPrefix(namespace);
        if (prefix == null) {
            prefix = VersionSpecBase.genPrefix(namespace);
            while (xmlWriter.getNamespaceContext().getNamespaceURI(prefix) != null) {
                prefix = BeanUtil.getUniquePrefix();
            }
            xmlWriter.writeNamespace(prefix, namespace);
            xmlWriter.setPrefix(prefix, namespace);
        }
        return prefix;
    }

    public abstract String getPresentableString();
}

