/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs.version;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.databinding.utils.writer.MTOMAwareXMLStreamWriter;
import org.jetbrains.tfsIntegration.core.tfs.version.VersionSpecBase;

public class LabelVersionSpec
extends VersionSpecBase {
    private final String myLabel;
    private final String myScope;

    public LabelVersionSpec(String label, String scope) {
        this.myLabel = label;
        this.myScope = scope;
    }

    @Override
    protected void writeAttributes(QName parentQName, OMFactory factory, MTOMAwareXMLStreamWriter xmlWriter) throws XMLStreamException {
        LabelVersionSpec.writeVersionAttribute("", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", (XMLStreamWriter)xmlWriter);
        LabelVersionSpec.writeVersionAttribute("", "xsi:type", "LabelVersionSpec", (XMLStreamWriter)xmlWriter);
        LabelVersionSpec.writeVersionAttribute("", "label", this.myLabel, (XMLStreamWriter)xmlWriter);
        if (this.myScope != null) {
            LabelVersionSpec.writeVersionAttribute("", "scope", this.myScope, (XMLStreamWriter)xmlWriter);
        }
    }

    @Override
    public String getPresentableString() {
        return this.myScope != null ? this.myLabel + "@" + this.myScope : this.myLabel;
    }

    public String getLabel() {
        return this.myLabel;
    }

    public String getScope() {
        return this.myScope;
    }

    public static LabelVersionSpec fromStringRepresentation(String stringRepresentation) {
        int atPos = stringRepresentation.indexOf(64);
        if (atPos != -1) {
            return new LabelVersionSpec(stringRepresentation.substring(0, atPos), stringRepresentation.substring(atPos + 1));
        }
        return new LabelVersionSpec(stringRepresentation, null);
    }
}

