/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs.version;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.databinding.utils.writer.MTOMAwareXMLStreamWriter;
import org.jetbrains.tfsIntegration.core.tfs.version.VersionSpecBase;

public class DateVersionSpec
extends VersionSpecBase {
    static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    public static SimpleDateFormat otextFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private static final DateFormat defaultDateFormat = new SimpleDateFormat();
    private final Date myDate;

    public DateVersionSpec(Date date) {
        this.myDate = date;
    }

    public Date getMyDate() {
        return this.myDate;
    }

    @Override
    protected void writeAttributes(QName parentQName, OMFactory factory, MTOMAwareXMLStreamWriter xmlWriter) throws XMLStreamException {
        DateVersionSpec.writeVersionAttribute("", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", (XMLStreamWriter)xmlWriter);
        DateVersionSpec.writeVersionAttribute("", "xsi:type", "DateVersionSpec", (XMLStreamWriter)xmlWriter);
        DateVersionSpec.writeVersionAttribute("", "date", this.getDateString(), (XMLStreamWriter)xmlWriter);
        DateVersionSpec.writeVersionAttribute("", "otext", this.getOTextString(), (XMLStreamWriter)xmlWriter);
    }

    public String getOTextString() {
        return otextFormat.format(this.myDate);
    }

    public String getDateString() {
        String dateString = dateFormat.format(this.myDate);
        dateString = dateString.substring(0, 22) + ":" + dateString.substring(22);
        return dateString;
    }

    public Date getDate() {
        return this.myDate;
    }

    @Override
    public String getPresentableString() {
        return defaultDateFormat.format(this.myDate);
    }
}

