/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs.operations;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Failure;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.GetOperation;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.tfs.ItemPath;
import org.jetbrains.tfsIntegration.core.tfs.ResultWithFailures;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlPath;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.operations.ApplyGetOperations;
import org.jetbrains.tfsIntegration.core.tfs.operations.ApplyProgress;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

public class UndoPendingChanges {
    @NonNls
    private static final String ITEM_NOT_CHECKED_OUT_FAILURE = "ItemNotCheckedOutException";

    public static UndoPendingChangesResult execute(Project project, WorkspaceInfo workspace, Collection<String> serverPaths, boolean forbidDownload, @NotNull ApplyProgress progress, boolean tolerateNoChangesFailure) {
        if (progress == null) {
            UndoPendingChanges.$$$reportNull$$$0(0);
        }
        if (serverPaths.isEmpty()) {
            return new UndoPendingChangesResult(Collections.emptyMap(), Collections.emptyList());
        }
        try {
            ResultWithFailures<GetOperation> result = workspace.getServer().getVCS().undoPendingChanges(workspace.getName(), workspace.getOwnerName(), serverPaths, project, TFSBundle.message("reverting", new Object[0]));
            Collection<Failure> failures = result.getFailures();
            if (tolerateNoChangesFailure) {
                Iterator<Failure> i = failures.iterator();
                while (i.hasNext()) {
                    if (!ITEM_NOT_CHECKED_OUT_FAILURE.equals(i.next().getCode())) continue;
                    i.remove();
                }
            }
            ArrayList<VcsException> errors = new ArrayList<VcsException>(TfsUtil.getVcsExceptions(failures));
            HashMap<ItemPath, ItemPath> undonePaths = new HashMap<ItemPath, ItemPath>();
            for (GetOperation getOperation : result.getResult()) {
                if (getOperation.getSlocal() == null || getOperation.getTlocal() == null) continue;
                FilePath sourcePath = VersionControlPath.getFilePath(getOperation.getSlocal(), getOperation.getType() == ItemType.Folder);
                FilePath targetPath = VersionControlPath.getFilePath(getOperation.getTlocal(), getOperation.getType() == ItemType.Folder);
                undonePaths.put(new ItemPath(sourcePath, workspace.findServerPathsByLocalPath(sourcePath, false, project).iterator().next()), new ItemPath(targetPath, workspace.findServerPathsByLocalPath(targetPath, false, project).iterator().next()));
            }
            ApplyGetOperations.DownloadMode downloadMode = forbidDownload ? ApplyGetOperations.DownloadMode.FORBID : ApplyGetOperations.DownloadMode.FORCE;
            Collection<VcsException> applyingErrors = ApplyGetOperations.execute(project, workspace, result.getResult(), progress, null, downloadMode);
            errors.addAll(applyingErrors);
            return new UndoPendingChangesResult(undonePaths, errors);
        }
        catch (TfsException e) {
            return new UndoPendingChangesResult(Collections.emptyMap(), Collections.singletonList(new VcsException((Throwable)e)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "org/jetbrains/tfsIntegration/core/tfs/operations/UndoPendingChanges", "execute"));
    }

    public static class UndoPendingChangesResult {
        public final Collection<VcsException> errors;
        public final Map<ItemPath, ItemPath> undonePaths;

        public UndoPendingChangesResult(Map<ItemPath, ItemPath> undonePaths, Collection<VcsException> errors) {
            this.undonePaths = undonePaths;
            this.errors = errors;
        }
    }
}

