/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs.labels;

import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Item;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemSpec;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemType;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.LabelItemSpec;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.RecursionType;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.VersionSpec;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlServer;
import org.jetbrains.tfsIntegration.core.tfs.labels.ItemAndVersion;
import org.jetbrains.tfsIntegration.core.tfs.version.VersionSpecBase;

public class LabelItemSpecWithItems {
    private final LabelItemSpec myLabelItemSpec;
    private final List<Item> myItemsList;

    private LabelItemSpecWithItems(@NotNull LabelItemSpec labelItemSpec, @NotNull List<Item> itemsList) {
        if (labelItemSpec == null) {
            LabelItemSpecWithItems.$$$reportNull$$$0(0);
        }
        if (itemsList == null) {
            LabelItemSpecWithItems.$$$reportNull$$$0(1);
        }
        this.myLabelItemSpec = labelItemSpec;
        this.myItemsList = itemsList;
    }

    public static LabelItemSpecWithItems createForAdd(@NotNull ItemSpec item, @NotNull VersionSpecBase version, @NotNull List<Item> itemsList) {
        if (item == null) {
            LabelItemSpecWithItems.$$$reportNull$$$0(2);
        }
        if (version == null) {
            LabelItemSpecWithItems.$$$reportNull$$$0(3);
        }
        if (itemsList == null) {
            LabelItemSpecWithItems.$$$reportNull$$$0(4);
        }
        LabelItemSpec labelItemSpec = new LabelItemSpec();
        labelItemSpec.setItemSpec(item);
        labelItemSpec.setVersion((VersionSpec)version);
        labelItemSpec.setEx(false);
        return new LabelItemSpecWithItems(labelItemSpec, itemsList);
    }

    public static LabelItemSpecWithItems createForRemove(@NotNull ItemAndVersion item) {
        if (item == null) {
            LabelItemSpecWithItems.$$$reportNull$$$0(5);
        }
        ItemSpec itemSpec = VersionControlServer.createItemSpec(item.getItem().getItem(), (RecursionType)(item.getItem().getType() == ItemType.Folder ? RecursionType.Full : null));
        LabelItemSpec labelItemSpec = new LabelItemSpec();
        labelItemSpec.setEx(true);
        labelItemSpec.setItemSpec(itemSpec);
        labelItemSpec.setVersion(item.getVersionSpec());
        return new LabelItemSpecWithItems(labelItemSpec, Collections.emptyList());
    }

    public LabelItemSpec getLabelItemSpec() {
        return this.myLabelItemSpec;
    }

    public List<Item> getItemsList() {
        return this.myItemsList;
    }

    public String getServerPath() {
        return this.getLabelItemSpec().getItemSpec().getItem();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelItemSpec";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemsList";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/tfsIntegration/core/tfs/labels/LabelItemSpecWithItems";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createForAdd";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createForRemove";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

