/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ArrayOfWorkingFolder;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.DeletedState;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ExtendedItem;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.WorkingFolder;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.WorkingFolderType;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Workspace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.core.tfs.ItemPath;
import org.jetbrains.tfsIntegration.core.tfs.ServerInfo;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlPath;
import org.jetbrains.tfsIntegration.core.tfs.WorkingFolderInfo;
import org.jetbrains.tfsIntegration.core.tfs.Workstation;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.exceptions.WorkspaceNotFoundException;

public class WorkspaceInfo {
    private static final Collection<String> WORKSPACE_NAME_INVALID_CHARS = Arrays.asList("\"", "/", ":", "<", ">", "|", "*", "?");
    private static final Collection<String> WORKSPACE_NAME_INVALID_ENDING_CHARS = Arrays.asList(" ", ".");
    private final ServerInfo myServerInfo;
    private final String myOwnerName;
    private final String myComputer;
    private String myOriginalName;
    private String myComment;
    private Calendar myTimestamp;
    private boolean myLoaded;
    private String myModifiedName;
    @NotNull
    private Location myLocation;
    @Nullable
    private String myOwnerDisplayName;
    @NotNull
    private final List<String> myOwnerAliases;
    @Nullable
    private String mySecurityToken;
    private int myOptions;
    private List<WorkingFolderInfo> myWorkingFoldersInfos;

    public WorkspaceInfo(@NotNull ServerInfo serverInfo, @NotNull String owner, @NotNull String computer) {
        if (serverInfo == null) {
            WorkspaceInfo.$$$reportNull$$$0(0);
        }
        if (owner == null) {
            WorkspaceInfo.$$$reportNull$$$0(1);
        }
        if (computer == null) {
            WorkspaceInfo.$$$reportNull$$$0(2);
        }
        this.myLocation = Location.SERVER;
        this.myOwnerAliases = ContainerUtil.newArrayList();
        this.myWorkingFoldersInfos = new ArrayList<WorkingFolderInfo>();
        this.myServerInfo = serverInfo;
        this.myOwnerName = owner;
        this.myComputer = computer;
        this.myTimestamp = new GregorianCalendar();
    }

    public WorkspaceInfo(@NotNull ServerInfo serverInfo, @NotNull String name, String owner, String computer, String comment, Calendar timestamp, boolean isLocal, @Nullable String ownerDisplayName, @Nullable String securityToken, int options) {
        if (serverInfo == null) {
            WorkspaceInfo.$$$reportNull$$$0(3);
        }
        if (name == null) {
            WorkspaceInfo.$$$reportNull$$$0(4);
        }
        this(serverInfo, owner, computer);
        this.myOriginalName = name;
        this.myComment = comment;
        this.myTimestamp = timestamp;
        this.myLocation = Location.from(isLocal);
        this.myOwnerDisplayName = ownerDisplayName;
        this.mySecurityToken = securityToken;
        this.myOptions = options;
    }

    @NotNull
    public ServerInfo getServer() {
        ServerInfo serverInfo = this.myServerInfo;
        if (serverInfo == null) {
            WorkspaceInfo.$$$reportNull$$$0(5);
        }
        return serverInfo;
    }

    public String getOwnerName() {
        return this.myOwnerName;
    }

    public String getComputer() {
        return this.myComputer;
    }

    public String getName() {
        return this.myModifiedName != null ? this.myModifiedName : this.myOriginalName;
    }

    public void setName(String name) {
        this.checkCurrentOwnerAndComputer();
        this.myModifiedName = name;
    }

    @NotNull
    public Location getLocation() {
        Location location = this.myLocation;
        if (location == null) {
            WorkspaceInfo.$$$reportNull$$$0(6);
        }
        return location;
    }

    public void setLocation(@NotNull Location location) {
        if (location == null) {
            WorkspaceInfo.$$$reportNull$$$0(7);
        }
        this.myLocation = location;
    }

    public boolean isLocal() {
        return Location.LOCAL.equals((Object)this.myLocation);
    }

    public String getComment() {
        return this.myComment;
    }

    public void setComment(String comment) {
        this.checkCurrentOwnerAndComputer();
        this.myComment = comment;
    }

    public Calendar getTimestamp() {
        return this.myTimestamp;
    }

    public void setTimestamp(Calendar timestamp) {
        this.checkCurrentOwnerAndComputer();
        this.myTimestamp = timestamp;
    }

    @Nullable
    public String getOwnerDisplayName() {
        return this.myOwnerDisplayName;
    }

    @Nullable
    public String getSecurityToken() {
        return this.mySecurityToken;
    }

    public int getOptions() {
        return this.myOptions;
    }

    @NotNull
    public List<String> getOwnerAliases() {
        List<String> list = this.myOwnerAliases;
        if (list == null) {
            WorkspaceInfo.$$$reportNull$$$0(8);
        }
        return list;
    }

    public List<WorkingFolderInfo> getWorkingFolders(Object projectOrComponent) throws TfsException {
        this.loadFromServer(projectOrComponent, false);
        return this.getWorkingFoldersCached();
    }

    public List<WorkingFolderInfo> getWorkingFoldersCached() {
        return Collections.unmodifiableList(this.myWorkingFoldersInfos);
    }

    public void loadFromServer(Object projectOrComponent, boolean force) throws TfsException {
        if (this.myOriginalName == null || this.myLoaded || !this.hasCurrentOwnerAndComputer()) {
            return;
        }
        Workspace workspaceBean = this.getServer().getVCS().loadWorkspace(this.getName(), this.getOwnerName(), projectOrComponent, force);
        if (!this.hasCurrentOwnerAndComputer()) {
            throw new WorkspaceNotFoundException(TFSBundle.message("workspace.wrong.owner", this.getName(), this.getOwnerName()));
        }
        WorkspaceInfo.fromBean(workspaceBean, this);
        this.myLoaded = true;
    }

    boolean hasMappingCached(FilePath localPath, boolean considerChildMappings) {
        return WorkspaceInfo.hasMapping(this.getWorkingFoldersCached(), localPath, considerChildMappings);
    }

    boolean hasMapping(FilePath localPath, boolean considerChildMappings, Object projectOrComponent) throws TfsException {
        return WorkspaceInfo.hasMapping(this.getWorkingFolders(projectOrComponent), localPath, considerChildMappings) && this.hasCurrentOwnerAndComputer();
    }

    boolean hasCurrentOwnerAndComputer() {
        String owner = this.getServer().getQualifiedUsername();
        return owner != null && this.isWorkspaceOwner(owner) && Workstation.getComputerName().equalsIgnoreCase(this.getComputer());
    }

    public boolean isWorkspaceOwner(@NotNull String owner) {
        if (owner == null) {
            WorkspaceInfo.$$$reportNull$$$0(9);
        }
        return owner.equalsIgnoreCase(this.myOwnerName) || ContainerUtil.or(this.myOwnerAliases, alias -> {
            if (owner == null) {
                WorkspaceInfo.$$$reportNull$$$0(17);
            }
            return owner.equalsIgnoreCase((String)alias);
        });
    }

    private void checkCurrentOwnerAndComputer() {
        if (!this.hasCurrentOwnerAndComputer()) {
            throw new IllegalStateException("Workspace " + this.getName() + " has other owner");
        }
    }

    public Collection<String> findServerPathsByLocalPath(@NotNull FilePath localPath, boolean considerChildMappings, Object projectOrComponent) throws TfsException {
        FilePath localPathOnLocalFileSystem;
        WorkingFolderInfo parentMapping;
        if (localPath == null) {
            WorkspaceInfo.$$$reportNull$$$0(10);
        }
        if ((parentMapping = this.findNearestParentMapping(localPathOnLocalFileSystem = VcsUtil.getFilePath((String)localPath.getPath(), (boolean)localPath.isDirectory()), projectOrComponent)) != null) {
            return Collections.singletonList(parentMapping.getServerPathByLocalPath(localPathOnLocalFileSystem));
        }
        if (considerChildMappings) {
            ArrayList<String> childMappings = new ArrayList<String>();
            for (WorkingFolderInfo workingFolder : this.getWorkingFolders(projectOrComponent)) {
                if (!workingFolder.getLocalPath().isUnder(localPathOnLocalFileSystem, false)) continue;
                childMappings.add(workingFolder.getServerPath());
            }
            return childMappings;
        }
        return Collections.emptyList();
    }

    @Nullable
    public FilePath findLocalPathByServerPath(@NotNull String serverPath, boolean isDirectory, Object projectOrComponent) throws TfsException {
        WorkingFolderInfo parentMapping;
        if (serverPath == null) {
            WorkspaceInfo.$$$reportNull$$$0(11);
        }
        return (parentMapping = this.findNearestParentMapping(serverPath, isDirectory, projectOrComponent)) != null ? parentMapping.getLocalPathByServerPath(serverPath, isDirectory) : null;
    }

    public boolean hasLocalPathForServerPath(@NotNull String serverPath, Object projectOrComponent) throws TfsException {
        if (serverPath == null) {
            WorkspaceInfo.$$$reportNull$$$0(12);
        }
        return this.findLocalPathByServerPath(serverPath, false, projectOrComponent) != null;
    }

    @Nullable
    private WorkingFolderInfo findNearestParentMapping(@NotNull FilePath localPath, Object projectOrComponent) throws TfsException {
        if (localPath == null) {
            WorkspaceInfo.$$$reportNull$$$0(13);
        }
        WorkingFolderInfo mapping = null;
        for (WorkingFolderInfo folderInfo : this.getWorkingFolders(projectOrComponent)) {
            if (folderInfo.getServerPathByLocalPath(localPath) == null || mapping != null && !folderInfo.getLocalPath().isUnder(mapping.getLocalPath(), false)) continue;
            mapping = folderInfo;
        }
        return mapping;
    }

    @Nullable
    private WorkingFolderInfo findNearestParentMapping(@NotNull String serverPath, boolean isDirectory, Object projectOrComponent) throws TfsException {
        if (serverPath == null) {
            WorkspaceInfo.$$$reportNull$$$0(14);
        }
        WorkingFolderInfo mapping = null;
        for (WorkingFolderInfo folderInfo : this.getWorkingFolders(projectOrComponent)) {
            if (folderInfo.getLocalPathByServerPath(serverPath, isDirectory) == null || mapping != null && !VersionControlPath.isUnder(mapping.getServerPath(), folderInfo.getServerPath())) continue;
            mapping = folderInfo;
        }
        return mapping;
    }

    public void addWorkingFolderInfo(WorkingFolderInfo workingFolderInfo) {
        this.myWorkingFoldersInfos.add(workingFolderInfo);
    }

    public void addOwnerAlias(@NotNull String alias) {
        if (alias == null) {
            WorkspaceInfo.$$$reportNull$$$0(15);
        }
        this.myOwnerAliases.add(alias);
    }

    public void removeWorkingFolderInfo(WorkingFolderInfo folderInfo) {
        this.checkCurrentOwnerAndComputer();
        this.myWorkingFoldersInfos.remove(folderInfo);
    }

    public void setWorkingFolders(List<WorkingFolderInfo> workingFolders) {
        this.checkCurrentOwnerAndComputer();
        this.myWorkingFoldersInfos.clear();
        this.myWorkingFoldersInfos.addAll(workingFolders);
    }

    public void saveToServer(Object projectOrComponent, WorkspaceInfo originalWorkspace) throws TfsException {
        this.checkCurrentOwnerAndComputer();
        if (this.myOriginalName != null) {
            this.getServer().getVCS().updateWorkspace(this.myOriginalName, WorkspaceInfo.toBean(this), projectOrComponent, true);
            this.getServer().replaceWorkspace(originalWorkspace, this);
        } else {
            this.getServer().getVCS().createWorkspace(WorkspaceInfo.toBean(this), projectOrComponent);
            this.getServer().addWorkspaceInfo(this);
        }
        this.myOriginalName = this.getName();
        Workstation.getInstance().update();
    }

    private static Workspace toBean(WorkspaceInfo info) {
        ArrayOfWorkingFolder folders = new ArrayOfWorkingFolder();
        List<WorkingFolderInfo> workingFolders = info.getWorkingFoldersCached();
        ArrayList<WorkingFolder> foldersList = new ArrayList<WorkingFolder>(workingFolders.size());
        for (WorkingFolderInfo folderInfo : workingFolders) {
            foldersList.add(WorkspaceInfo.toBean(folderInfo));
        }
        folders.setWorkingFolder(foldersList.toArray(new WorkingFolder[foldersList.size()]));
        Workspace bean = new Workspace();
        bean.setComment(info.getComment());
        bean.setComputer(info.getComputer());
        bean.setFolders(folders);
        bean.setLastAccessDate(info.getTimestamp());
        bean.setName(info.getName());
        bean.setOwner(info.getOwnerName());
        bean.setIslocal(info.isLocal());
        bean.setOwnerdisp(info.myOwnerDisplayName);
        bean.setOwnerAliases(TfsUtil.toArrayOfString(ContainerUtil.nullize(info.myOwnerAliases)));
        bean.setSecuritytoken(info.mySecurityToken);
        bean.setOptions(info.myOptions);
        return bean;
    }

    @NotNull
    private static WorkingFolder toBean(WorkingFolderInfo folderInfo) {
        WorkingFolder bean = new WorkingFolder();
        bean.setItem(folderInfo.getServerPath());
        bean.setLocal(VersionControlPath.toTfsRepresentation(folderInfo.getLocalPath()));
        bean.setType(folderInfo.getStatus() == WorkingFolderInfo.Status.Cloaked ? WorkingFolderType.Cloak : WorkingFolderType.Map);
        WorkingFolder workingFolder = bean;
        if (workingFolder == null) {
            WorkspaceInfo.$$$reportNull$$$0(16);
        }
        return workingFolder;
    }

    @Nullable
    private static WorkingFolderInfo fromBean(WorkingFolder bean) {
        WorkingFolderInfo.Status status;
        WorkingFolderInfo.Status status2 = status = WorkingFolderType.Cloak.equals((Object)bean.getType()) ? WorkingFolderInfo.Status.Cloaked : WorkingFolderInfo.Status.Active;
        if (bean.getLocal() != null) {
            return new WorkingFolderInfo(status, VersionControlPath.getFilePath(bean.getLocal(), true), bean.getItem());
        }
        TFSVcs.LOG.info("null local folder mapping for " + bean.getItem());
        return null;
    }

    static void fromBean(Workspace bean, WorkspaceInfo workspace) {
        workspace.myOriginalName = bean.getName();
        workspace.setLocation(Location.from(bean.getIslocal()));
        workspace.setComment(bean.getComment());
        workspace.setTimestamp(bean.getLastAccessDate());
        workspace.myOwnerDisplayName = bean.getOwnerdisp();
        workspace.myOwnerAliases.clear();
        if (bean.getOwnerAliases() != null) {
            ContainerUtil.addAll(workspace.myOwnerAliases, (Object[])bean.getOwnerAliases().getString());
        }
        workspace.mySecurityToken = bean.getSecuritytoken();
        workspace.myOptions = bean.getOptions();
        WorkingFolder[] folders = bean.getFolders().getWorkingFolder() != null ? bean.getFolders().getWorkingFolder() : new WorkingFolder[]{};
        ArrayList<WorkingFolderInfo> workingFoldersInfos = new ArrayList<WorkingFolderInfo>(folders.length);
        for (WorkingFolder folderBean : folders) {
            WorkingFolderInfo folderInfo = WorkspaceInfo.fromBean(folderBean);
            if (folderInfo == null) continue;
            workingFoldersInfos.add(folderInfo);
        }
        workspace.myWorkingFoldersInfos = workingFoldersInfos;
    }

    public WorkspaceInfo getCopy() {
        WorkspaceInfo copy = new WorkspaceInfo(this.myServerInfo, this.myOwnerName, this.myComputer);
        copy.myLocation = this.myLocation;
        copy.myComment = this.myComment;
        copy.myLoaded = this.myLoaded;
        copy.myOriginalName = this.myOriginalName;
        copy.myModifiedName = this.myModifiedName;
        copy.myTimestamp = this.myTimestamp;
        copy.myOwnerDisplayName = this.myOwnerDisplayName;
        copy.myOwnerAliases.addAll(this.myOwnerAliases);
        copy.mySecurityToken = this.mySecurityToken;
        copy.myOptions = this.myOptions;
        for (WorkingFolderInfo workingFolder : this.myWorkingFoldersInfos) {
            copy.myWorkingFoldersInfos.add(workingFolder.getCopy());
        }
        return copy;
    }

    public Map<FilePath, ExtendedItem> getExtendedItems2(List<ItemPath> paths, Object projectOrComponent, String progressTitle) throws TfsException {
        return this.getServer().getVCS().getExtendedItems(this.getName(), this.getOwnerName(), TfsUtil.getLocalPaths(paths), DeletedState.Any, projectOrComponent, progressTitle);
    }

    public Map<FilePath, ExtendedItem> getExtendedItems(List<FilePath> paths, Object projectOrComponent, String progressTitle) throws TfsException {
        return this.getServer().getVCS().getExtendedItems(this.getName(), this.getOwnerName(), paths, DeletedState.Any, projectOrComponent, progressTitle);
    }

    public static boolean isValidName(String name) {
        for (String invalid : WORKSPACE_NAME_INVALID_CHARS) {
            if (!name.contains(invalid)) continue;
            return false;
        }
        for (String invalidEnd : WORKSPACE_NAME_INVALID_ENDING_CHARS) {
            if (!name.endsWith(invalidEnd)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasMapping(Collection<WorkingFolderInfo> mappings, FilePath localPath, boolean considerChildMappings) {
        FilePath localPathOnLocalFileSystem = VcsUtil.getFilePath((String)localPath.getPath(), (boolean)localPath.isDirectory());
        for (WorkingFolderInfo mapping : mappings) {
            if (!localPathOnLocalFileSystem.isUnder(mapping.getLocalPath(), false) && (!considerChildMappings || !mapping.getLocalPath().isUnder(localPathOnLocalFileSystem, false))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "WorkspaceInfo[server=" + this.getServer().getUri() + ",name=" + this.getName() + ",owner=" + this.getOwnerName() + ",computer=" + this.getComputer() + ",comment=" + this.getComment() + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverInfo";
                break;
            }
            case 1: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/tfsIntegration/core/tfs/WorkspaceInfo";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverPath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/tfsIntegration/core/tfs/WorkspaceInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getServer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnerAliases";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "toBean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 16: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setLocation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isWorkspaceOwner";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findServerPathsByLocalPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findLocalPathByServerPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasLocalPathForServerPath";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findNearestParentMapping";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addOwnerAlias";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isWorkspaceOwner$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Location {
        LOCAL,
        SERVER;


        @NotNull
        public static Location from(boolean isLocal) {
            Location location = isLocal ? LOCAL : SERVER;
            if (location == null) {
                Location.$$$reportNull$$$0(0);
            }
            return location;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/tfs/WorkspaceInfo$Location", "from"));
        }
    }
}

