/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.configuration.TFSConfigurationManager;
import org.jetbrains.tfsIntegration.core.configuration.TfsCheckinPoliciesCompatibility;
import org.jetbrains.tfsIntegration.ui.ProjectConfigurableForm;

public class TFSProjectConfigurable
implements Configurable {
    private final Project myProject;
    private ProjectConfigurableForm myComponent;

    public TFSProjectConfigurable(Project project) {
        this.myProject = project;
    }

    @Nullable
    @Nls
    public String getDisplayName() {
        return null;
    }

    @NonNls
    public String getHelpTopic() {
        return "project.propVCSSupport.VCSs.TFS";
    }

    public JComponent createComponent() {
        this.myComponent = new ProjectConfigurableForm(this.myProject);
        return this.myComponent.getContentPane();
    }

    public boolean isModified() {
        if (TFSConfigurationManager.getInstance().useIdeaHttpProxy() != this.myComponent.useProxy()) {
            return true;
        }
        TfsCheckinPoliciesCompatibility c = TFSConfigurationManager.getInstance().getCheckinPoliciesCompatibility();
        if (c.teamExplorer != this.myComponent.supportTfsCheckinPolicies()) {
            return true;
        }
        if (c.teamprise != this.myComponent.supportStatefulCheckinPolicies()) {
            return true;
        }
        return c.nonInstalled != this.myComponent.reportNotInstalledCheckinPolicies();
    }

    public void apply() throws ConfigurationException {
        TFSConfigurationManager.getInstance().setUseIdeaHttpProxy(this.myComponent.useProxy());
        TFSConfigurationManager.getInstance().setSupportTfsCheckinPolicies(this.myComponent.supportTfsCheckinPolicies());
        TFSConfigurationManager.getInstance().setSupportStatefulCheckinPolicies(this.myComponent.supportStatefulCheckinPolicies());
        TFSConfigurationManager.getInstance().setReportNotInstalledCheckinPolicies(this.myComponent.reportNotInstalledCheckinPolicies());
    }

    public void reset() {
        this.myComponent.setUserProxy(TFSConfigurationManager.getInstance().useIdeaHttpProxy());
        TfsCheckinPoliciesCompatibility c = TFSConfigurationManager.getInstance().getCheckinPoliciesCompatibility();
        this.myComponent.setSupportTfsCheckinPolicies(c.teamExplorer);
        this.myComponent.setSupportStatefulCheckinPolicies(c.teamprise);
        this.myComponent.setReportNotInstalledCheckinPolicies(c.nonInstalled);
    }

    public void disposeUIResources() {
        this.myComponent = null;
    }
}

