/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.DiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.HistoryAsTreeProvider;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsDependentHistoryComponents;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.ColumnInfo;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Changeset;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ExtendedItem;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Item;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemType;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.TFSFileRevision;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.version.ChangesetVersionSpec;
import org.jetbrains.tfsIntegration.core.tfs.version.LatestVersionSpec;
import org.jetbrains.tfsIntegration.core.tfs.version.VersionSpecBase;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

public class TFSHistoryProvider
implements VcsHistoryProvider {
    @NotNull
    private final Project myProject;

    public TFSHistoryProvider(@NotNull Project project) {
        if (project == null) {
            TFSHistoryProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public VcsDependentHistoryComponents getUICustomization(VcsHistorySession session, JComponent forShortcutRegistration) {
        return VcsDependentHistoryComponents.createOnlyColumns((ColumnInfo[])ColumnInfo.EMPTY_ARRAY);
    }

    public AnAction[] getAdditionalActions(Runnable refresher) {
        return AnAction.EMPTY_ARRAY;
    }

    public boolean isDateOmittable() {
        return false;
    }

    @Nullable
    @NonNls
    public String getHelpId() {
        return null;
    }

    @Nullable
    public VcsHistorySession createSessionFor(FilePath filePath) throws VcsException {
        try {
            Pair<WorkspaceInfo, ExtendedItem> workspaceAndItem = TfsUtil.getWorkspaceAndExtendedItem(filePath, this.myProject, TFSBundle.message("loading.item", new Object[0]));
            if (workspaceAndItem == null || workspaceAndItem.second == null) {
                return null;
            }
            List<TFSFileRevision> revisions = TFSHistoryProvider.getRevisions(this.myProject, ((ExtendedItem)workspaceAndItem.second).getSitem(), filePath.isDirectory(), (WorkspaceInfo)workspaceAndItem.first, LatestVersionSpec.INSTANCE);
            if (revisions.isEmpty()) {
                return null;
            }
            return TFSHistoryProvider.createSession(workspaceAndItem, revisions);
        }
        catch (TfsException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private static VcsAbstractHistorySession createSession(final Pair<WorkspaceInfo, ExtendedItem> workspaceAndItem, List<? extends VcsFileRevision> revisions) {
        return new VcsAbstractHistorySession(revisions){

            public VcsRevisionNumber calcCurrentRevisionNumber() {
                return TfsUtil.getCurrentRevisionNumber((ExtendedItem)workspaceAndItem.second);
            }

            public HistoryAsTreeProvider getHistoryAsTreeProvider() {
                return null;
            }

            public VcsHistorySession copy() {
                return TFSHistoryProvider.createSession((Pair<WorkspaceInfo, ExtendedItem>)workspaceAndItem, this.getRevisionList());
            }

            public boolean isContentAvailable(VcsFileRevision revision) {
                return ((ExtendedItem)workspaceAndItem.second).getType() == ItemType.File;
            }
        };
    }

    public void reportAppendableHistory(FilePath path, VcsAppendableHistorySessionPartner partner) throws VcsException {
        VcsHistorySession session = this.createSessionFor(path);
        partner.reportCreatedEmptySession((VcsAbstractHistorySession)session);
    }

    public static List<TFSFileRevision> getRevisions(Project project, String serverPath, boolean isDirectory, WorkspaceInfo workspace, VersionSpecBase versionTo) throws TfsException {
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)project);
        int maxCount = vcsConfiguration.LIMIT_HISTORY ? vcsConfiguration.MAXIMUM_HISTORY_ROWS : Integer.MAX_VALUE;
        List<Changeset> changesets = workspace.getServer().getVCS().queryHistory(workspace, serverPath, isDirectory, null, new ChangesetVersionSpec(1), versionTo, project, TFSBundle.message("loading.item", new Object[0]), maxCount);
        ArrayList<TFSFileRevision> revisions = new ArrayList<TFSFileRevision>(changesets.size());
        for (Changeset changeset : changesets) {
            Item item = changeset.getChanges().getChange()[0].getItem();
            revisions.add(new TFSFileRevision(project, workspace, item.getItemid(), changeset.getDate().getTime(), changeset.getComment(), changeset.getOwner(), changeset.getCset()));
        }
        return revisions;
    }

    public boolean supportsHistoryForDirectories() {
        return true;
    }

    public DiffFromHistoryHandler getHistoryDiffHandler() {
        return null;
    }

    public boolean canShowHistoryFor(@NotNull VirtualFile file) {
        if (file == null) {
            TFSHistoryProvider.$$$reportNull$$$0(1);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/tfsIntegration/core/TFSHistoryProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "canShowHistoryFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

