/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.checkin;

import java.util.List;
import org.jdom.Element;
import org.jetbrains.tfsIntegration.checkin.Memento;

public class XMLMemento
implements Memento {
    private Element myElement;

    public XMLMemento(Element element) {
        this.myElement = element;
    }

    @Override
    public Memento createChild(String nodeName) {
        Element element = new Element(nodeName);
        this.myElement.addContent(element);
        return new XMLMemento(element);
    }

    @Override
    public Memento copyChild(Memento child) {
        Element element = ((XMLMemento)child).myElement.clone();
        this.myElement.addContent(element);
        return new XMLMemento(element);
    }

    @Override
    public Memento getChild(String nodeName) {
        Element element = this.myElement.getChild(nodeName);
        return element != null ? new XMLMemento(element) : null;
    }

    @Override
    public Memento[] getChildren(String nodeName) {
        List elements = this.myElement.getChildren(nodeName);
        Memento[] result = new Memento[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            result[i] = new XMLMemento((Element)elements.get(i));
        }
        return result;
    }

    @Override
    public String getName() {
        return this.myElement.getName();
    }

    @Override
    public Double getDouble(String key) {
        String s = this.myElement.getAttributeValue(key);
        if (s != null) {
            try {
                return new Double(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Float getFloat(String key) {
        String s = this.myElement.getAttributeValue(key);
        if (s != null) {
            try {
                return new Float(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Integer getInteger(String key) {
        String s = this.myElement.getAttributeValue(key);
        if (s != null) {
            try {
                return new Integer(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Long getLong(String key) {
        String s = this.myElement.getAttributeValue(key);
        if (s != null) {
            try {
                return new Long(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getString(String key) {
        return this.myElement.getAttributeValue(key);
    }

    @Override
    public Boolean getBoolean(String key) {
        String s = this.myElement.getAttributeValue(key);
        if (s != null) {
            return Boolean.valueOf(s);
        }
        return null;
    }

    @Override
    public String getTextData() {
        String text = this.myElement.getText();
        if (text != null && text.length() == 0) {
            text = null;
        }
        return text;
    }

    @Override
    public void putDouble(String key, double value) {
        this.myElement.setAttribute(key, String.valueOf(value));
    }

    @Override
    public void putFloat(String key, float value) {
        this.myElement.setAttribute(key, String.valueOf(value));
    }

    @Override
    public void putInteger(String key, int value) {
        this.myElement.setAttribute(key, String.valueOf(value));
    }

    @Override
    public void putLong(String key, long value) {
        this.myElement.setAttribute(key, String.valueOf(value));
    }

    @Override
    public void putMemento(Memento memento) {
        this.myElement = ((XMLMemento)memento).myElement.clone();
    }

    @Override
    public void putString(String key, String value) {
        this.myElement.setAttribute(key, value);
    }

    @Override
    public void putBoolean(String key, boolean value) {
        this.myElement.setAttribute(key, String.valueOf(value));
    }

    @Override
    public void putTextData(String data) {
        this.myElement.setText(data);
    }

    public Element getElement() {
        return this.myElement;
    }
}

