/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ExtendedItem;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.tfs.TfsFileUtil;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

public abstract class SingleItemAction
extends AnAction {
    private static final Collection<FileStatus> ALLOWED_STATUSES = Arrays.asList(FileStatus.HIJACKED, FileStatus.MODIFIED, FileStatus.NOT_CHANGED, FileStatus.OBSOLETE);

    protected abstract void execute(@NotNull Project var1, @NotNull WorkspaceInfo var2, @NotNull FilePath var3, @NotNull ExtendedItem var4) throws TfsException;

    protected Collection<FileStatus> getAllowedStatuses() {
        return ALLOWED_STATUSES;
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file = VcsUtil.getOneVirtualFile((AnActionEvent)e);
        FilePath localPath = TfsFileUtil.getFilePath(file);
        String actionTitle = StringUtil.trimEnd((String)e.getPresentation().getText(), (String)"...");
        try {
            Pair<WorkspaceInfo, ExtendedItem> workspaceAndItem = TfsUtil.getWorkspaceAndExtendedItem(localPath, project, TFSBundle.message("loading.item", new Object[0]));
            if (workspaceAndItem == null) {
                String itemType = localPath.isDirectory() ? "folder" : "file";
                String message = MessageFormat.format("No mapping found for {0} ''{1}''", itemType, localPath.getPresentableUrl());
                Messages.showErrorDialog((Project)project, (String)message, (String)actionTitle);
                return;
            }
            if (workspaceAndItem.second == null) {
                String itemType = localPath.isDirectory() ? "Folder" : "File";
                String message = MessageFormat.format("{0} ''{1}'' is unversioned", itemType, localPath.getPresentableUrl());
                Messages.showErrorDialog((Project)project, (String)message, (String)actionTitle);
                return;
            }
            this.execute(project, (WorkspaceInfo)workspaceAndItem.first, localPath, (ExtendedItem)workspaceAndItem.second);
        }
        catch (TfsException ex) {
            Messages.showErrorDialog((Project)project, (String)ex.getMessage(), (String)actionTitle);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SingleItemAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabled(this.isEnabled(e.getProject(), VcsUtil.getOneVirtualFile((AnActionEvent)e)));
    }

    protected final boolean isEnabled(@Nullable Project project, @Nullable VirtualFile file) {
        return project != null && file != null && this.getAllowedStatuses().contains(FileStatusManager.getInstance((Project)project).getStatus(file));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/tfsIntegration/actions/SingleItemAction", "update"));
    }
}

