/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.persistence.integration;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.persistence.model.PersistenceListener;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.helpers.PersistenceUnitModelHelper;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.SpringManager;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ReadOnlyGenericValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringPersistencePackage<T extends SpringBeanPointer>
extends UserDataHolderBase
implements PersistencePackage,
PersistenceUnitModelHelper {
    private T myBean;
    private Module myModule;

    public SpringPersistencePackage(T bean, @NotNull Module module) {
        if (module == null) {
            SpringPersistencePackage.$$$reportNull$$$0(0);
        }
        this.myBean = bean;
        this.myModule = module;
        PsiElement element = this.myBean.getPsiElement();
        if (element != null) {
            element.putUserData(PersistencePackage.PERSISTENCE_UNIT_KEY, (Object)this);
        }
    }

    @Nullable
    public GenericValue<String> getName() {
        return ReadOnlyGenericValue.getInstance((Object)this.myBean.getName());
    }

    public PersistenceUnitModelHelper getModelHelper() {
        return this;
    }

    public boolean isValid() {
        return this.myBean.isValid();
    }

    public T getBeanPointer() {
        return this.myBean;
    }

    @Nullable
    public XmlTag getXmlTag() {
        return null;
    }

    public PsiManager getPsiManager() {
        PsiElement element = this.myBean.getPsiElement();
        return element == null ? PsiManager.getInstance((Project)this.myModule.getProject()) : element.getManager();
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            SpringPersistencePackage.$$$reportNull$$$0(1);
        }
        return module;
    }

    @Nullable
    public PsiElement getIdentifyingPsiElement() {
        return this.myBean.getPsiElement();
    }

    @Nullable
    public PsiFile getContainingFile() {
        PsiElement element = this.myBean.getPsiElement();
        return element == null ? null : element.getContainingFile();
    }

    @Nullable
    public String getPersistenceProviderName() {
        return null;
    }

    public PersistenceMappings getAdditionalMapping() {
        return null;
    }

    @NotNull
    public <V extends PersistenceMappings> List<? extends GenericValue<V>> getMappingFiles(Class<V> mappingsClass) {
        List list = Collections.emptyList();
        if (list == null) {
            SpringPersistencePackage.$$$reportNull$$$0(2);
        }
        return list;
    }

    protected <V extends PersistenceMappings> void addMappingsFromDirectory(Collection<V> result, Class<V> mappingsClass, PsiDirectory psiDirectory) {
        for (PsiFile psiFile : psiDirectory.getFiles()) {
            ContainerUtil.addIfNotNull(result, (Object)JamCommonUtil.getRootElement((PsiFile)psiFile, mappingsClass, (Module)this.myModule));
        }
        for (PsiFile psiFile : psiDirectory.getSubdirectories()) {
            this.addMappingsFromDirectory(result, mappingsClass, (PsiDirectory)psiFile);
        }
    }

    @NotNull
    public List<? extends PersistenceListener> getPersistentListeners() {
        List list = Collections.emptyList();
        if (list == null) {
            SpringPersistencePackage.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<? extends GenericValue<PsiFile>> getJarFiles() {
        List list = Collections.emptyList();
        if (list == null) {
            SpringPersistencePackage.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<? extends GenericValue<PsiClass>> getClasses() {
        List list = Collections.emptyList();
        if (list == null) {
            SpringPersistencePackage.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<? extends GenericValue<PsiPackage>> getPackages() {
        List list = Collections.emptyList();
        if (list == null) {
            SpringPersistencePackage.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    public GenericValue<String> getDataSourceName() {
        return null;
    }

    @NotNull
    public Properties getPersistenceUnitProperties() {
        Properties properties = new Properties();
        if (properties == null) {
            SpringPersistencePackage.$$$reportNull$$$0(7);
        }
        return properties;
    }

    public Collection<Object> getCacheDependencies() {
        Object[] objectArray;
        PsiFile containingFile = this.getContainingFile();
        if (containingFile == null) {
            objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
        } else {
            PsiFile[] psiFileArray = new PsiFile[1];
            objectArray = psiFileArray;
            psiFileArray[0] = containingFile;
        }
        Object[] additional = objectArray;
        SpringManager springManager = SpringManager.getInstance((Project)this.myModule.getProject());
        return Arrays.asList(springManager.getModelsDependencies(this.myModule, additional));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SpringPersistencePackage that = (SpringPersistencePackage)((Object)o);
        if (!this.myBean.equals(that.myBean)) {
            return false;
        }
        return this.myModule.equals(that.myModule);
    }

    public int hashCode() {
        int result = this.myBean.hashCode();
        result = 31 * result + this.myModule.hashCode();
        return result;
    }

    protected Processor<PsiPackage> getPackagesCollectProcessor(ArrayList<GenericValue<PsiPackage>> result) {
        return psiPackage -> {
            result.add(ReadOnlyGenericValue.getInstance((Object)psiPackage));
            return true;
        };
    }

    protected static boolean processAllSubPackages(PsiPackage psiPackage, GlobalSearchScope scope, Processor<PsiPackage> processor) {
        if (!processor.process((Object)psiPackage)) {
            return false;
        }
        for (PsiPackage aPackage : psiPackage.getSubPackages(scope)) {
            if (SpringPersistencePackage.processAllSubPackages(aPackage, scope, processor)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/persistence/integration/SpringPersistencePackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/persistence/integration/SpringPersistencePackage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistentListeners";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackages";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistenceUnitProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

